/*
 * Decompiled with CFR 0.152.
 */
package net.mitask.reveonlib.config;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.mitask.reveonlib.config.ConfigListener;
import net.mitask.reveonlib.config.IConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfig<T>
implements IConfig<T> {
    protected final File configFile;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<ConfigListener<T>> listeners = new ArrayList<ConfigListener<T>>();
    protected T configData;

    public AbstractConfig(File file) {
        try {
            Files.createParentDirs((File)file);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create parent directories for config!", e);
        }
        this.configFile = file;
    }

    public void addListener(ConfigListener<T> listener) {
        this.listeners.add(listener);
    }

    protected void notifyListeners(T newConfig) {
        for (ConfigListener<T> listener : this.listeners) {
            listener.onConfigChanged(newConfig);
        }
    }

    @Override
    public T load() {
        this.configData = this.loadConfig();
        return this.configData;
    }

    @Override
    public T reload() {
        this.configData = this.loadConfig();
        return this.configData;
    }

    protected abstract T loadConfig();

    @Override
    public void save(T data) {
        throw new UnsupportedOperationException("[AbstractConfig save] Not implemented!");
    }

    @Override
    public T getDefault() {
        throw new UnsupportedOperationException("[AbstractConfig getDefault] Not implemented!");
    }

    @Override
    public void resetToDefault() {
        this.save(this.getDefault());
    }
}

