/*
 * Decompiled with CFR 0.152.
 */
package net.mitask.reveonlib.logger;

import com.diogonunes.jcolor.Ansi;
import com.diogonunes.jcolor.Attribute;
import java.util.HashMap;
import java.util.Map;

public class Logger {
    private static final Map<String, Logger> loggers = new HashMap<String, Logger>();
    private final String name;

    private Logger(String loggerName) {
        this.name = loggerName;
    }

    public void log(LogLevel level, Object message) {
        String text = Ansi.colorize((String)String.format(" %s ", this.name), (Attribute[])new Attribute[]{Attribute.CYAN_TEXT(), Attribute.BOLD(), Attribute.FRAMED()}) + " ";
        switch (level) {
            case INFO: {
                text = text + Ansi.colorize((String)String.format("INFO: %s", message), (Attribute[])new Attribute[]{Attribute.GREEN_TEXT(), Attribute.BOLD()});
                break;
            }
            case WARN: {
                text = text + Ansi.colorize((String)String.format("WARN: %s", message), (Attribute[])new Attribute[]{Attribute.YELLOW_TEXT(), Attribute.BOLD()});
                break;
            }
            case ERROR: {
                text = text + Ansi.colorize((String)String.format("ERROR: %s", message), (Attribute[])new Attribute[]{Attribute.RED_TEXT(), Attribute.BOLD()});
                break;
            }
            case DEBUG: {
                text = text + Ansi.colorize((String)String.format("DEBUG: %s", message), (Attribute[])new Attribute[]{Attribute.MAGENTA_TEXT(), Attribute.BOLD()});
            }
        }
        System.out.println(text);
    }

    public void info(Object text) {
        this.log(LogLevel.INFO, text);
    }

    public void info(Object text, Object ... args) {
        String out = text.toString();
        for (Object arg : args) {
            out = out.replaceFirst("\\{}", "" + arg);
        }
        this.info(out);
    }

    public void warn(Object text) {
        this.log(LogLevel.WARN, text);
    }

    public void warn(Object text, Object ... args) {
        String out = text.toString();
        for (Object arg : args) {
            out = out.replaceFirst("\\{}", "" + arg);
        }
        this.warn(out);
    }

    public void error(Object text) {
        this.log(LogLevel.ERROR, text);
    }

    public void error(Object text, Exception exception) {
        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
            System.out.println(stackTraceElement);
        }
        this.log(LogLevel.ERROR, text);
    }

    public void error(Object text, Object ... args) {
        String out = text.toString();
        for (Object arg : args) {
            out = out.replaceFirst("\\{}", "" + arg);
        }
        this.error(out);
    }

    public void debug(Object text) {
        this.log(LogLevel.DEBUG, text);
    }

    public void debug(Object text, Object ... args) {
        String out = text.toString();
        for (Object arg : args) {
            out = out.replaceFirst("\\{}", "" + arg);
        }
        this.debug(out);
    }

    public static Logger getLogger(String loggerName) {
        if (loggers.containsKey(loggerName)) {
            return loggers.get(loggerName);
        }
        Logger logger = new Logger(loggerName);
        loggers.put(loggerName, logger);
        return logger;
    }

    public static Logger getLogger(Class logger) {
        return Logger.getLogger(logger.getName());
    }

    public static enum LogLevel {
        INFO,
        WARN,
        ERROR,
        DEBUG;

    }
}

