/*
 * Decompiled with CFR 0.152.
 */
package net.mitask.reveonlib.config.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.mitask.reveonlib.config.AbstractConfig;

public class JsonConfig<T>
extends AbstractConfig<T> {
    private final Class<T> clazz;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public JsonConfig(File file, Class<T> clazz) {
        super(file);
        this.clazz = clazz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T loadConfig() {
        try (FileReader reader = new FileReader(this.configFile);){
            Object object = this.gson.fromJson((Reader)reader, this.clazz);
            return (T)object;
        }
        catch (IOException e) {
            this.logger.error("Error while loading JsonConfig!", (Throwable)e);
            this.configData = this.getDefault();
            this.save(this.configData);
            return (T)this.configData;
        }
    }

    @Override
    public void save(T data) {
        try {
            Files.createFile(Paths.get(this.configFile.getCanonicalPath(), new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            this.logger.error("Error while creating config file on saving!", (Throwable)e);
        }
        try (FileWriter writer = new FileWriter(this.configFile);){
            this.gson.toJson(data, (Appendable)writer);
            this.notifyListeners(data);
        }
        catch (IOException e) {
            this.logger.error("Error while saving JsonConfig!", (Throwable)e);
        }
    }

    @Override
    public T getDefault() {
        try {
            return this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Error while getting default JsonConfig!", (Throwable)e);
            return null;
        }
    }
}

