/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.mine_diver.unsafeevents.EventBus;
import net.mine_diver.unsafeevents.eventbus.ManagedEventBus;
import net.modificationstation.stationapi.api.event.mod.InitEvent;
import net.modificationstation.stationapi.api.mod.entrypoint.Entrypoint;
import net.modificationstation.stationapi.api.mod.entrypoint.EntrypointManager;
import net.modificationstation.stationapi.api.mod.entrypoint.EventBusPolicy;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;
import net.modificationstation.stationapi.api.util.Null;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.jetbrains.annotations.ApiStatus;

@Entrypoint(eventBus=@EventBusPolicy(registerInstance=false, registerStatic=false))
public class StationAPI
implements PreLaunchEntrypoint {
    @Entrypoint.Instance
    public static final StationAPI INSTANCE = (StationAPI)Null.get();
    @Entrypoint.Namespace
    public static final Namespace NAMESPACE = Namespace.of("stationapi");
    @Entrypoint.Logger(value="Station|API")
    public static final Logger LOGGER = (Logger)Null.get();
    @ApiStatus.Internal
    public static final String INTERNAL_PHASE = "stationapi:internal";
    @ApiStatus.Internal
    private static final ManagedEventBus MANAGED_EVENT_BUS = new ManagedEventBus();
    public static final EventBus EVENT_BUS = MANAGED_EVENT_BUS;

    public void onPreLaunch() {
        FabricLoader.getInstance().getModContainer("stationapi").ifPresent(modContainer -> EntrypointManager.setup(this, modContainer));
        String name = NAMESPACE.getName();
        LOGGER.info("Initializing " + name + "...");
        Configurator.setLevel((String)"mixin", (Level)Level.TRACE);
        Configurator.setLevel((String)"Fabric|Loader", (Level)Level.INFO);
        LOGGER.info("Loading entrypoints...");
        this.setupMods();
        LOGGER.info("Finished " + name + " setup.");
    }

    private void setupMods() {
        this.setupEntrypoint(NAMESPACE.id("event_bus"));
        this.setupEntrypoint(NAMESPACE.id("event_bus_" + FabricLoader.getInstance().getEnvironmentType().name().toLowerCase()));
        LOGGER.info("Invoking Init event...");
        EVENT_BUS.post(InitEvent.builder().build());
    }

    private void setupEntrypoint(Identifier entrypoint) {
        MANAGED_EVENT_BUS.disableDispatch("During the registration of listeners, the event dispatch to StationAPI's event bus is temporarily disabled to prevent listeners from causing an illegal event dispatch. This helps ensure that the event bus behaves predictably and without dispatching an event while not all listeners have been registered.");
        FabricLoader.getInstance().getEntrypointContainers(entrypoint.toString(), Object.class).forEach(entrypointContainer -> {
            LOGGER.info("Setting up \"" + entrypointContainer.getProvider().getMetadata().getId() + "\" \"" + String.valueOf(entrypoint) + "\" \"" + entrypointContainer.getEntrypoint().getClass().getName() + "\" entrypoint...");
            EntrypointManager.setup(entrypointContainer);
        });
        MANAGED_EVENT_BUS.enableDispatch();
    }
}

