/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.factory;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.modificationstation.stationapi.api.util.UnsafeProvider;
import sun.reflect.ReflectionFactory;

public class EnumFactory {
    private static final Function<Constructor<?>, Object> NEW_CONSTRUCTOR_ACCESSOR;
    private static final BiFunction<Object, Object[], Object> NEW_INSTANCE;

    private static Object getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws Exception {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return NEW_CONSTRUCTOR_ACCESSOR.apply(enumClass.getDeclaredConstructor(parameterTypes));
    }

    private static <T extends Enum<?>> T makeEnum(Class<T> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object ... additionalValues) throws Exception {
        Object[] parms = new Object[additionalValues.length + 2];
        parms[0] = value;
        parms[1] = ordinal;
        System.arraycopy(additionalValues, 0, parms, 2, additionalValues.length);
        return (T)((Enum)enumClass.cast(NEW_INSTANCE.apply(EnumFactory.getConstructorAccessor(enumClass, additionalTypes), parms)));
    }

    private static void setFailsafeFieldValue(Field field, Object target, Object value) {
        long fieldOffset;
        Object fieldBase;
        if (Modifier.isStatic(field.getModifiers())) {
            fieldBase = UnsafeProvider.theUnsafe.staticFieldBase(field);
            fieldOffset = UnsafeProvider.theUnsafe.staticFieldOffset(field);
        } else {
            fieldBase = target;
            fieldOffset = UnsafeProvider.theUnsafe.objectFieldOffset(field);
        }
        UnsafeProvider.theUnsafe.putObject(fieldBase, fieldOffset, value);
    }

    private static void blankField(Class<?> enumClass, String fieldName) {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            EnumFactory.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) {
        EnumFactory.blankField(enumClass, "enumConstantDirectory");
        EnumFactory.blankField(enumClass, "enumConstants");
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object ... paramValues) {
        Field[] fields;
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            String name = field.getName();
            if (!name.equals("$VALUES") && !name.equals("ENUM$VALUES")) continue;
            valuesField = field;
            break;
        }
        int flags = 4122;
        if (valuesField == null) {
            String valueType = String.format("[L%s;", enumType.getName().replace('.', '/'));
            for (Field field : fields) {
                if ((field.getModifiers() & flags) != flags || !field.getType().getName().replace('.', '/').equals(valueType)) continue;
                valuesField = field;
                break;
            }
        }
        ((Field)Objects.requireNonNull(valuesField)).setAccessible(true);
        try {
            Object[] previousValues = (Object[])valuesField.get(enumType);
            ArrayList<Enum> values = new ArrayList<Enum>();
            for (Object previousValue : previousValues) {
                values.add((Enum)enumType.cast(previousValue));
            }
            T t = EnumFactory.makeEnum(enumType, enumName, values.size(), paramTypes, paramValues);
            values.add((Enum)t);
            Enum[] valuesArray = values.toArray((Enum[])Array.newInstance(enumType, 0));
            EnumFactory.setFailsafeFieldValue(valuesField, null, valuesArray);
            EnumFactory.cleanEnumCache(enumType);
            return (T)((Enum)enumType.cast(t));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            MethodHandles.Lookup implLookup = (MethodHandles.Lookup)UnsafeProvider.theUnsafe.getObject(UnsafeProvider.theUnsafe.staticFieldBase(implLookupField), UnsafeProvider.theUnsafe.staticFieldOffset(implLookupField));
            Field rfDelegateField = ReflectionFactory.class.getDeclaredField("delegate");
            Class<?> rfClass = rfDelegateField.getType();
            rfDelegateField.setAccessible(true);
            Object reflectionFactory = rfDelegateField.get(null);
            Class<?> constructorAccessorClass = Class.forName("jdk.internal.reflect.ConstructorAccessor");
            MethodHandle newConstructorAccessorHandle = implLookup.findVirtual(rfClass, "newConstructorAccessor", MethodType.methodType(constructorAccessorClass, Constructor.class));
            MethodHandle newInstanceHandle = implLookup.findVirtual(constructorAccessorClass, "newInstance", MethodType.methodType(Object.class, Object[].class));
            NEW_CONSTRUCTOR_ACCESSOR = constructor -> {
                try {
                    return newConstructorAccessorHandle.invoke(reflectionFactory, (Constructor)constructor);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
            NEW_INSTANCE = (constructorAccessor, params) -> {
                try {
                    return newInstanceHandle.invoke(constructorAccessor, (Object[])params);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

