/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.modificationstation.stationapi.api.util.Namespace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Identifier
implements Comparable<Identifier> {
    @NotNull
    public static final @NotNull Codec<@NotNull Identifier> CODEC = Codec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)Identifier.of(s));
        }
        catch (IllegalArgumentException var2) {
            return DataResult.error(() -> "Not a valid identifier: " + s + " " + var2.getMessage());
        }
    }, Identifier::toString).stable();
    public static final char NAMESPACE_SEPARATOR = ':';
    @NotNull
    private static final @NotNull Cache<@NotNull IdentifierCacheKey, @NotNull Identifier> CACHE = Caffeine.newBuilder().softValues().build();
    @NotNull
    private static final @NotNull Function<@NotNull IdentifierCacheKey, @NotNull Identifier> IDENTIFIER_FACTORY = Identifier::new;
    @NotNull
    public final Namespace namespace;
    @NotNull
    public final String path;
    @NotNull
    private final String toString;
    private final int hashCode;

    @NotNull
    public static Identifier of(@NotNull String identifier) {
        String path;
        String namespace;
        int i = identifier.indexOf(58);
        if (i < 0) {
            namespace = Namespace.MINECRAFT.toString();
            path = identifier;
        } else {
            namespace = identifier.substring(0, i);
            path = identifier.substring(i + 1);
        }
        return Identifier.of(Namespace.of(namespace), path);
    }

    @NotNull
    public static Identifier of(@NotNull Namespace namespace, @NotNull String id) {
        return (Identifier)CACHE.get((Object)new IdentifierCacheKey(namespace, id), IDENTIFIER_FACTORY);
    }

    @Nullable
    public static Identifier tryParse(@NotNull String string) {
        try {
            return Identifier.of(string);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @NotNull
    public static @NotNull DataResult<@NotNull Identifier> validate(@NotNull String id) {
        try {
            return DataResult.success((Object)Identifier.of(id));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error(() -> "Not a valid identifier: " + id + " " + e.getMessage());
        }
    }

    private Identifier(@NotNull IdentifierCacheKey key) {
        this.namespace = key.namespace;
        this.path = key.id;
        this.toString = String.valueOf(this.namespace) + String.valueOf(':') + this.path;
        this.hashCode = this.toString.hashCode();
    }

    @NotNull
    public Identifier withPath(@NotNull String path) {
        return Identifier.of(this.namespace, path);
    }

    @NotNull
    public Identifier withPath(@NotNull UnaryOperator<String> pathFunction) {
        return this.withPath((String)pathFunction.apply(this.path));
    }

    @NotNull
    public Identifier withPrefixedPath(@NotNull String prefix) {
        return this.withPath(prefix + this.path);
    }

    @NotNull
    public Identifier withSuffixedPath(@NotNull String suffix) {
        return this.withPath(this.path + suffix);
    }

    @Override
    public int compareTo(@NotNull Identifier o) {
        return this.toString.compareTo(o.toString);
    }

    @NotNull
    public String toString() {
        return this.toString;
    }

    public boolean equals(@NotNull Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Identifier) {
            @NotNull Identifier otherId = (Identifier)other;
            if (this.toString.equals(otherId.toString)) {
                throw new IllegalStateException(String.format("Encountered a duplicate instance of Identifier %s!", this.toString));
            }
            return false;
        }
        return this.toString.equals(other);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @NotNull
    public Namespace getNamespace() {
        return this.namespace;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    private record IdentifierCacheKey(@NotNull Namespace namespace, @NotNull String id) {
    }
}

