/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMaps;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.fabricmc.loader.api.FabricLoader;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.util.crash.CrashException;
import org.apache.commons.io.IOUtils;

public class Util {
    private static final int MAX_PARALLELISM = 255;
    private static final String MAX_BG_THREADS_PROPERTY = "max.bg.threads";
    private static final AtomicInteger NEXT_WORKER_ID = new AtomicInteger(1);
    private static final ExecutorService BOOTSTRAP_EXECUTOR = Util.createWorker("Bootstrap");
    private static final ExecutorService MAIN_WORKER_EXECUTOR = Util.createWorker("Main");
    public static LongSupplier nanoTimeSupplier = System::nanoTime;

    private static ExecutorService createWorker(String name) {
        int i = Ints.constrainToRange((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)Util.getMaxBackgroundThreads());
        return i <= 0 ? MoreExecutors.newDirectExecutorService() : new ForkJoinPool(i, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        StationAPI.LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        StationAPI.LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("Worker-" + name + "-" + NEXT_WORKER_ID.getAndIncrement());
            return forkJoinWorkerThread;
        }, Util::uncaughtExceptionHandler, true);
    }

    private static int getMaxBackgroundThreads() {
        String string = System.getProperty(MAX_BG_THREADS_PROPERTY);
        if (string != null) {
            try {
                int i = Integer.parseInt(string);
                if (i >= 1 && i <= 255) {
                    return i;
                }
                StationAPI.LOGGER.error("Wrong {} property value '{}'. Should be an integer value between 1 and {}.", (Object)MAX_BG_THREADS_PROPERTY, (Object)string, (Object)255);
            }
            catch (NumberFormatException numberFormatException) {
                StationAPI.LOGGER.error("Could not parse {} property value '{}'. Should be an integer value between 1 and {}.", (Object)MAX_BG_THREADS_PROPERTY, (Object)string, (Object)255);
            }
        }
        return 255;
    }

    private static void uncaughtExceptionHandler(Thread thread, Throwable throwable) {
        Util.throwOrPause(throwable);
        if (throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof CrashException) {
            CrashException crash = (CrashException)throwable;
            System.out.println(crash.getReport().asString());
            System.exit(-1);
        }
        StationAPI.LOGGER.error(String.format("Caught exception in thread %s", thread), throwable);
    }

    public static void error(String message) {
        StationAPI.LOGGER.error(message);
    }

    public static <T extends Throwable> T throwOrPause(T t) {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            StationAPI.LOGGER.error("Trying to throw a fatal exception, pausing in IDE", t);
            try {
                while (true) {
                    Thread.sleep(1000L);
                    StationAPI.LOGGER.error("paused");
                }
            }
            catch (InterruptedException var2) {
                return t;
            }
        }
        return t;
    }

    public static <T> T make(T object, Consumer<T> initializer) {
        initializer.accept(object);
        return object;
    }

    public static <T> T make(Supplier<T> initializer) {
        return initializer.get();
    }

    public static <T, R> ImmutableMap<T, R> createLookupBy(Function<R, T> keyMapper, R[] values) {
        return (ImmutableMap)Arrays.stream(values).collect(ImmutableMap.toImmutableMap(keyMapper, Function.identity()));
    }

    public static <T, R> Map<T, R> createIdentityLookupBy(Function<R, T> keyMapper, R[] values) {
        return Collections.unmodifiableMap(Arrays.stream(values).collect(Collectors.toMap(keyMapper, Function.identity(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, IdentityHashMap::new)));
    }

    public static <T, R> Reference2ReferenceMap<T, R> createReference2ReferenceLookupBy(Function<R, T> keyMapper, R[] values, IntFunction<T[]> keyArrayFactory) {
        return Reference2ReferenceMaps.unmodifiable((Reference2ReferenceMap)new Reference2ReferenceOpenHashMap((Object[])Arrays.stream(values).map(keyMapper).toArray(keyArrayFactory), (Object[])values));
    }

    public static <K> Hash.Strategy<K> identityHashStrategy() {
        return IdentityHashStrategy.INSTANCE;
    }

    public static <V> CompletableFuture<List<V>> combineSafe(List<? extends CompletableFuture<V>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        if (futures.size() == 1) {
            return futures.get(0).thenApply(List::of);
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return completableFuture.thenApply(void_ -> futures.stream().map(CompletableFuture::join).toList());
    }

    public static <V> CompletableFuture<List<V>> combine(List<? extends CompletableFuture<? extends V>> futures) {
        ArrayList list = Lists.newArrayListWithCapacity((int)futures.size());
        CompletableFuture[] completableFutures = new CompletableFuture[futures.size()];
        CompletableFuture completableFuture = new CompletableFuture();
        futures.forEach(completableFuture2 -> {
            int i = list.size();
            list.add(null);
            completableFutures[i] = completableFuture2.whenComplete((object, throwable) -> {
                if (throwable != null) {
                    completableFuture.completeExceptionally((Throwable)throwable);
                } else {
                    list.set(i, object);
                }
            });
        });
        return CompletableFuture.allOf(completableFutures).applyToEither((CompletionStage)completableFuture, void_ -> list);
    }

    public static ExecutorService getBootstrapExecutor() {
        return BOOTSTRAP_EXECUTOR;
    }

    public static Executor getMainWorkerExecutor() {
        return MAIN_WORKER_EXECUTOR;
    }

    public static <T> T getRandom(T[] array, Random random) {
        return array[random.nextInt(array.length)];
    }

    public static long getMeasuringTimeMs() {
        return Util.getMeasuringTimeNano() / 1000000L;
    }

    public static long getMeasuringTimeNano() {
        return nanoTimeSupplier.getAsLong();
    }

    public static OperatingSystem getOperatingSystem() {
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (string.contains("win")) {
            return OperatingSystem.WINDOWS;
        }
        if (string.contains("mac")) {
            return OperatingSystem.OSX;
        }
        if (string.contains("solaris")) {
            return OperatingSystem.SOLARIS;
        }
        if (string.contains("sunos")) {
            return OperatingSystem.SOLARIS;
        }
        if (string.contains("linux")) {
            return OperatingSystem.LINUX;
        }
        if (string.contains("unix")) {
            return OperatingSystem.LINUX;
        }
        return OperatingSystem.UNKNOWN;
    }

    public static Stream<String> getJVMFlags() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().stream().filter(string -> string.startsWith("-X"));
    }

    public static <T> T assertMixin() {
        throw new AssertionError((Object)"Mixin!");
    }

    public static <T> T assertImpl() {
        throw new AssertionError((Object)"This method was never supposed to be called, as it should have been overriden by a mixin. Something is very broken!");
    }

    public static <T, R> Function<T, R> memoize(Function<T, R> function) {
        return Util.memoize(new HashMap(), function);
    }

    public static <T, R> Function<T, R> memoizeIdentity(Function<T, R> function) {
        return Util.memoize(new IdentityHashMap(), function);
    }

    private static <T, R> Function<T, R> memoize(Map<T, R> cache, Function<T, R> function) {
        return object -> cache.computeIfAbsent(object, function);
    }

    public static <T, U, R> BiFunction<T, U, R> memoize(BiFunction<T, U, R> biFunction) {
        HashMap cache = new HashMap();
        return (object, object2) -> cache.computeIfAbsent(Pair.of((Object)object, (Object)object2), pair -> biFunction.apply(pair.getFirst(), pair.getSecond()));
    }

    public static <T> List<T> copyShuffled(Stream<T> stream, Random random) {
        ObjectArrayList objectArrayList = (ObjectArrayList)stream.collect(ObjectArrayList.toList());
        Util.shuffle(objectArrayList, random);
        return objectArrayList;
    }

    public static IntArrayList shuffle(IntStream stream, Random random) {
        IntArrayList intArrayList = IntArrayList.wrap((int[])stream.toArray());
        for (int j = intArrayList.size(); j > 1; --j) {
            int k = random.nextInt(j);
            intArrayList.set(j - 1, intArrayList.set(k, intArrayList.getInt(j - 1)));
        }
        return intArrayList;
    }

    public static <T> List<T> copyShuffled(T[] array, Random random) {
        ObjectArrayList objectArrayList = new ObjectArrayList((Object[])array);
        Util.shuffle(objectArrayList, random);
        return objectArrayList;
    }

    public static <T> List<T> copyShuffled(ObjectArrayList<T> list, Random random) {
        ObjectArrayList objectArrayList = new ObjectArrayList(list);
        Util.shuffle(objectArrayList, random);
        return objectArrayList;
    }

    public static <T> void shuffle(ObjectArrayList<T> list, Random random) {
        for (int j = list.size(); j > 1; --j) {
            int k = random.nextInt(j);
            list.set(j - 1, list.set(k, list.get(j - 1)));
        }
    }

    public static Consumer<String> addPrefix(String prefix, Consumer<String> consumer) {
        return string -> consumer.accept(prefix + string);
    }

    public static DataResult<int[]> toArray(IntStream stream, int length) {
        int[] is = stream.limit(length + 1).toArray();
        if (is.length != length) {
            String string = "Input is not a list of " + length + " ints";
            if (is.length >= length) {
                return DataResult.error(() -> string, (Object)Arrays.copyOf(is, length));
            }
            return DataResult.error(() -> string);
        }
        return DataResult.success((Object)is);
    }

    public static <T> DataResult<List<T>> toArray(List<T> list, int length) {
        if (list.size() != length) {
            String string = "Input is not a list of " + length + " elements";
            if (list.size() >= length) {
                return DataResult.error(() -> string, list.subList(0, length));
            }
            return DataResult.error(() -> string);
        }
        return DataResult.success(list);
    }

    public static <T> T getRandom(List<T> list, Random random) {
        return list.get(random.nextInt(list.size()));
    }

    public static <T> Optional<T> getRandomOrEmpty(List<T> list, Random random) {
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Util.getRandom(list, random));
    }

    public static void pack(Path sourceDirPath, Path zipFilePath) throws IOException {
        Path p = Files.createFile(zipFilePath, new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));
             Stream<Path> walk = Files.walk(sourceDirPath, new FileVisitOption[0]);){
            Path parentPath = sourceDirPath.getParent();
            walk.forEach(path -> {
                boolean isDir = Files.isDirectory(path, new LinkOption[0]);
                Object entryPath = parentPath.relativize((Path)path).toString();
                if (isDir) {
                    entryPath = (String)entryPath + "/";
                }
                try {
                    zs.putNextEntry(new ZipEntry((String)entryPath));
                    if (!isDir) {
                        Files.copy(path, zs);
                    }
                    zs.closeEntry();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    static enum IdentityHashStrategy implements Hash.Strategy<Object>
    {
        INSTANCE;


        public int hashCode(Object object) {
            return System.identityHashCode(object);
        }

        public boolean equals(Object object, Object object2) {
            return object == object2;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OperatingSystem {
        LINUX("linux"),
        SOLARIS("solaris"),
        WINDOWS("windows"){

            @Override
            protected String[] getURLOpenCommand(URL url) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", url.toString()};
            }
        }
        ,
        OSX("mac"){

            @Override
            protected String[] getURLOpenCommand(URL url) {
                return new String[]{"open", url.toString()};
            }
        }
        ,
        UNKNOWN("unknown");

        private final String name;

        private OperatingSystem(String name) {
            this.name = name;
        }

        public void open(URL url) {
            try {
                Process process = AccessController.doPrivileged(() -> {
                    try {
                        return Runtime.getRuntime().exec(this.getURLOpenCommand(url));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                for (String string : IOUtils.readLines((InputStream)process.getErrorStream())) {
                    StationAPI.LOGGER.error(string);
                }
                process.getInputStream().close();
                process.getErrorStream().close();
                process.getOutputStream().close();
            }
            catch (IOException exception) {
                StationAPI.LOGGER.error("Couldn't open url '{}'", (Object)url, (Object)exception);
            }
        }

        public void open(URI uri) {
            try {
                this.open(uri.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                StationAPI.LOGGER.error("Couldn't open uri '{}'", (Object)uri, (Object)malformedURLException);
            }
        }

        public void open(File file) {
            try {
                this.open(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                StationAPI.LOGGER.error("Couldn't open file '{}'", (Object)file, (Object)malformedURLException);
            }
        }

        protected String[] getURLOpenCommand(URL url) {
            String string = url.toString();
            if ("file".equals(url.getProtocol())) {
                string = string.replace("file:", "file://");
            }
            return new String[]{"xdg-open", string};
        }

        public void open(String uri) {
            try {
                this.open(new URI(uri).toURL());
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
                StationAPI.LOGGER.error("Couldn't open uri '{}'", (Object)uri, (Object)exception);
            }
        }

        public String getName() {
            return this.name;
        }
    }
}

