/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.util.collection;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class WeightedList<T> {
    private final List<T> objects = new ArrayList<T>();
    private final IntList weights = new IntArrayList();
    private int maxWeight;

    public void add(T object, int weight) {
        this.objects.add(object);
        this.maxWeight += weight;
        this.weights.add(this.maxWeight);
    }

    public void addAll(WeightedList<T> list) {
        this.objects.addAll(list.objects);
        int start = this.weights.size();
        this.weights.addAll(list.weights);
        for (int i = start; i < this.weights.size(); ++i) {
            this.weights.set(i, this.weights.getInt(i) + this.maxWeight);
        }
        this.maxWeight += list.maxWeight;
    }

    public void clear() {
        this.objects.clear();
        this.weights.clear();
        this.maxWeight = 0;
    }

    public T get(Random random) {
        if (this.maxWeight == 0 || this.objects.isEmpty()) {
            return null;
        }
        int weight = random.nextInt(this.maxWeight);
        for (int i = 0; i < this.objects.size(); ++i) {
            if (weight >= this.weights.getInt(i)) continue;
            return this.objects.get(i);
        }
        return this.objects.get(0);
    }

    public boolean isEmpty() {
        return this.maxWeight == 0;
    }
}

