/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.util.profiler;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.modificationstation.stationapi.api.util.Util;
import net.modificationstation.stationapi.api.util.profiler.ProfileLocationInfo;
import net.modificationstation.stationapi.api.util.profiler.ProfileResult;
import net.modificationstation.stationapi.api.util.profiler.ProfileResultImpl;
import net.modificationstation.stationapi.api.util.profiler.ReadableProfiler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.jetbrains.annotations.Nullable;

public class ProfilerSystem
implements ReadableProfiler {
    private static final long TIMEOUT_NANOSECONDS = Duration.ofMillis(100L).toNanos();
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<String> path = new ArrayList<String>();
    private final LongList timeList = new LongArrayList();
    private final Map<String, LocatedInfo> locationInfos = new HashMap<String, LocatedInfo>();
    private final IntSupplier endTickGetter;
    private final LongSupplier timeGetter;
    private final long startTime;
    private final int startTick;
    private String fullPath = "";
    private boolean tickStarted;
    @Nullable
    private LocatedInfo currentInfo;
    private final boolean checkTimeout;

    public ProfilerSystem(LongSupplier timeGetter, IntSupplier tickGetter, boolean checkTimeout) {
        this.startTime = timeGetter.getAsLong();
        this.timeGetter = timeGetter;
        this.startTick = tickGetter.getAsInt();
        this.endTickGetter = tickGetter;
        this.checkTimeout = checkTimeout;
    }

    protected String getRoot() {
        return "root";
    }

    @Override
    public void startTick() {
        if (this.tickStarted) {
            LOGGER.error("Profiler tick already started - missing endTick()?");
        } else {
            this.tickStarted = true;
            this.fullPath = "";
            this.path.clear();
            this.push(this.getRoot());
        }
    }

    @Override
    public void endTick() {
        if (!this.tickStarted) {
            LOGGER.error("Profiler tick already ended - missing startTick()?");
        } else {
            this.pop();
            this.tickStarted = false;
            if (!this.fullPath.isEmpty()) {
                LOGGER.error("Profiler tick ended before path was fully popped (remainder: '{}'). Mismatched push/pop?", new Supplier[]{() -> ProfileResult.getHumanReadableName(this.fullPath)});
            }
        }
    }

    @Override
    public void push(String location) {
        if (!this.tickStarted) {
            LOGGER.error("Cannot push '{}' to profiler if profiler tick hasn't started - missing startTick()?", (Object)location);
        } else {
            if (!this.fullPath.isEmpty()) {
                this.fullPath = this.fullPath + "\u001e";
            }
            this.fullPath = this.fullPath + location;
            this.path.add(this.fullPath);
            this.timeList.add(Util.getMeasuringTimeNano());
            this.currentInfo = null;
        }
    }

    @Override
    public void push(java.util.function.Supplier<String> locationGetter) {
        this.push(locationGetter.get());
    }

    @Override
    public void pop() {
        if (!this.tickStarted) {
            LOGGER.error("Cannot pop from profiler if profiler tick hasn't started - missing startTick()?");
        } else if (this.timeList.isEmpty()) {
            LOGGER.error("Tried to pop one too many times! Mismatched push() and pop()?");
        } else {
            long l = Util.getMeasuringTimeNano();
            long m = this.timeList.removeLong(this.timeList.size() - 1);
            this.path.remove(this.path.size() - 1);
            long n = l - m;
            LocatedInfo locatedInfo = this.getCurrentInfo();
            locatedInfo.time += n;
            ++locatedInfo.visits;
            if (this.checkTimeout && n > TIMEOUT_NANOSECONDS) {
                LOGGER.warn("Something's taking too long! '{}' took aprox {} ms", new Supplier[]{() -> ProfileResult.getHumanReadableName(this.fullPath), () -> (double)n / 1000000.0});
            }
            this.fullPath = this.path.isEmpty() ? "" : this.path.get(this.path.size() - 1);
            this.currentInfo = null;
        }
    }

    @Override
    public void swap(String location) {
        this.pop();
        this.push(location);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void swap(java.util.function.Supplier<String> locationGetter) {
        this.pop();
        this.push(locationGetter);
    }

    private LocatedInfo getCurrentInfo() {
        if (this.currentInfo == null) {
            this.currentInfo = this.locationInfos.computeIfAbsent(this.fullPath, string -> new LocatedInfo());
        }
        return this.currentInfo;
    }

    @Override
    public void visit(String marker) {
        this.getCurrentInfo().counts.addTo((Object)marker, 1L);
    }

    @Override
    public void visit(java.util.function.Supplier<String> markerGetter) {
        this.getCurrentInfo().counts.addTo((Object)markerGetter.get(), 1L);
    }

    @Override
    public ProfileResult getResult() {
        return new ProfileResultImpl(this.locationInfos, this.startTime, this.startTick, this.timeGetter.getAsLong(), this.endTickGetter.getAsInt());
    }

    public String getFullPath() {
        return this.fullPath;
    }

    static class LocatedInfo
    implements ProfileLocationInfo {
        private long time;
        private long visits;
        private final Object2LongOpenHashMap<String> counts = new Object2LongOpenHashMap();

        private LocatedInfo() {
        }

        @Override
        public long getTotalTime() {
            return this.time;
        }

        @Override
        public long getVisitCount() {
            return this.visits;
        }

        @Override
        public Object2LongMap<String> getCounts() {
            return Object2LongMaps.unmodifiable(this.counts);
        }
    }
}

