/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.datafixer;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.event.datafixer.DataFixerRegisterEvent;
import net.modificationstation.stationapi.api.util.Namespace;
import net.modificationstation.stationapi.api.util.Util;

public final class DataFixers {
    public static final String DATA_VERSIONS = StationAPI.NAMESPACE.id("data_versions").toString();
    private static final Reference2ReferenceMap<Namespace, DataFixerEntry> DATA_FIXERS = new Reference2ReferenceOpenHashMap();
    private static boolean init;

    public static void registerFixer(Namespace mod, Function<Executor, DataFixer> dataFixer, int currentVersion) {
        DataFixers.registerFixer(mod, () -> (DataFixer)dataFixer.apply(Util.getBootstrapExecutor()), currentVersion);
    }

    public static void registerFixer(Namespace mod, Supplier<DataFixer> dataFixer, int currentVersion) {
        DATA_FIXERS.put((Object)mod, (Object)new DataFixerEntry((Supplier<DataFixer>)Suppliers.memoize(dataFixer::get), currentVersion));
    }

    public static <T> Dynamic<T> update(DSL.TypeReference type, Dynamic<T> dynamic) {
        DataFixers.init();
        Dynamic<T> dataVersions = DataFixers.getDataVersions(dynamic);
        Dynamic ret = dynamic;
        for (Reference2ReferenceMap.Entry entry : DATA_FIXERS.reference2ReferenceEntrySet()) {
            int currentVersion;
            DataFixerEntry fixerEntry = (DataFixerEntry)entry.getValue();
            int version = dataVersions.get(((Namespace)entry.getKey()).toString()).asInt(0);
            if (version >= (currentVersion = fixerEntry.currentVersion)) continue;
            ret = fixerEntry.fixer.get().update(type, ret, version, currentVersion);
        }
        return ret;
    }

    public static <T> Dynamic<T> getDataVersions(Dynamic<T> dynamic) {
        return dynamic.get(DATA_VERSIONS).result().orElseGet(() -> dynamic.createMap(Collections.emptyMap()));
    }

    public static <T> Dynamic<T> addDataVersions(Dynamic<T> dynamic) {
        DataFixers.init();
        return dynamic.set(DATA_VERSIONS, dynamic.createMap(DATA_FIXERS.reference2ReferenceEntrySet().stream().collect(Collectors.toMap(t -> dynamic.createString(((Namespace)t.getKey()).toString()), t -> dynamic.createInt(((DataFixerEntry)t.getValue()).currentVersion)))));
    }

    public static <T> boolean requiresUpdating(Dynamic<T> dynamic) {
        DataFixers.init();
        Dynamic<T> dataVersions = DataFixers.getDataVersions(dynamic);
        for (Reference2ReferenceMap.Entry fixerEntry : DATA_FIXERS.reference2ReferenceEntrySet()) {
            if (dataVersions.get(((Namespace)fixerEntry.getKey()).toString()).asInt(0) >= ((DataFixerEntry)fixerEntry.getValue()).currentVersion) continue;
            return true;
        }
        return false;
    }

    public static <T> Set<UpdateData> getUpdateList(Dynamic<T> dynamic) {
        DataFixers.init();
        HashSet<UpdateData> set = new HashSet<UpdateData>();
        Dynamic<T> dataVersions = DataFixers.getDataVersions(dynamic);
        for (Reference2ReferenceMap.Entry fixerEntry : DATA_FIXERS.reference2ReferenceEntrySet()) {
            int currentVersion;
            int dataVersion = dataVersions.get(((Namespace)fixerEntry.getKey()).toString()).asInt(0);
            if (dataVersion >= (currentVersion = ((DataFixerEntry)fixerEntry.getValue()).currentVersion)) continue;
            set.add(new UpdateData((Namespace)fixerEntry.getKey(), dataVersion, currentVersion));
        }
        return set;
    }

    private static void init() {
        if (!init) {
            init = true;
            StationAPI.EVENT_BUS.post(DataFixerRegisterEvent.builder().build());
        }
    }

    private DataFixers() {
    }

    private record DataFixerEntry(Supplier<DataFixer> fixer, int currentVersion) {
    }

    public record UpdateData(Namespace namespace, int saveVersion, int currentVersion) {
    }
}

