/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.registry;

import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMaps;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.util.Comparator;
import net.minecraft.class_377;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.registry.DimensionContainer;
import net.modificationstation.stationapi.api.registry.MutableRegistry;
import net.modificationstation.stationapi.api.registry.Registries;
import net.modificationstation.stationapi.api.registry.Registry;
import net.modificationstation.stationapi.api.registry.RegistryKey;
import net.modificationstation.stationapi.api.registry.legacy.AbstractInt2ObjectMapBackedLegacyRegistry;
import net.modificationstation.stationapi.api.registry.legacy.WorldLegacyRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.NotNull;

public final class DimensionRegistry
extends AbstractInt2ObjectMapBackedLegacyRegistry<DimensionContainer<?>>
implements WorldLegacyRegistry<DimensionContainer<?>> {
    private static final int VANILLA_MIN = -1;
    private static final int VANILLA_MAX = 0;
    public static final IntComparator DIMENSIONS_COMPARATOR = (a, b) -> {
        boolean bVanilla;
        if (a == b) {
            return 0;
        }
        boolean aVanilla = -1 <= a && a <= 0;
        boolean bl = bVanilla = -1 <= b && b <= 0;
        if (aVanilla && bVanilla) {
            return a < b ? 1 : -1;
        }
        if (aVanilla) {
            return -1;
        }
        if (bVanilla) {
            return 1;
        }
        return a < b ? -1 : 1;
    };
    private static final DimensionContainer<class_377> OVERWORLD = new DimensionContainer<class_377>(class_377::new);
    public static final RegistryKey<DimensionRegistry> KEY = RegistryKey.ofRegistry((Identifier)StationAPI.NAMESPACE.id("dimensions"));
    public static final DimensionRegistry INSTANCE = (DimensionRegistry)Registries.create(KEY, (MutableRegistry)new DimensionRegistry(), registry -> OVERWORLD, (Lifecycle)Lifecycle.experimental());
    private final Int2ObjectSortedMap<DimensionContainer<?>> values = new Int2ObjectAVLTreeMap((Comparator)DIMENSIONS_COMPARATOR);
    public final Int2ObjectSortedMap<DimensionContainer<?>> serialView = Int2ObjectSortedMaps.unmodifiable(this.values);
    private boolean registering;

    private DimensionRegistry() {
        super(KEY, false);
    }

    protected Int2ObjectMap<DimensionContainer<?>> getBackingInt2ObjectMap() {
        return this.serialView;
    }

    public void remap(int newLegacyId, @NotNull DimensionContainer<?> value) {
        this.values.remove(this.getLegacyId(value));
        if (this.serialView.containsKey(newLegacyId)) {
            this.remap(this.getNextLegacyId(), (DimensionContainer)this.serialView.get(newLegacyId));
        }
        value.serialID = newLegacyId;
        this.values.put(newLegacyId, value);
    }

    public void register(@NotNull Identifier identifier, @NotNull DimensionContainer<?> value) {
        if (this.registering) {
            Registry.register((Registry)this, (Identifier)identifier, value);
        } else {
            this.registering = true;
            this.register(identifier, id -> {
                value.serialID = id;
                this.values.put(id, (Object)value);
                return value;
            });
            this.registering = false;
        }
    }

    public void register(@NotNull Identifier identifier, int serialID, @NotNull DimensionContainer<?> value) {
        value.serialID = serialID;
        this.values.put(serialID, value);
        Registry.register((Registry)this, (Identifier)identifier, value);
    }
}

