/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.client.network;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.mine_diver.unsafeevents.Event;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.minecraft.class_127;
import net.minecraft.class_216;
import net.minecraft.class_454;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.entity.HasOwner;
import net.modificationstation.stationapi.api.event.registry.EntityHandlerRegistryEvent;
import net.modificationstation.stationapi.api.event.registry.MessageListenerRegistryEvent;
import net.modificationstation.stationapi.api.event.registry.MobHandlerRegistryEvent;
import net.modificationstation.stationapi.api.mod.entrypoint.Entrypoint;
import net.modificationstation.stationapi.api.mod.entrypoint.EventBusPolicy;
import net.modificationstation.stationapi.api.network.packet.MessagePacket;
import net.modificationstation.stationapi.api.registry.EntityHandlerRegistry;
import net.modificationstation.stationapi.api.registry.MobHandlerRegistry;
import net.modificationstation.stationapi.api.registry.Registry;
import net.modificationstation.stationapi.api.server.entity.StationSpawnDataProvider;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.mixin.entity.client.ClientNetworkHandlerAccessor;
import uk.co.benjiweber.expressions.function.QuadFunction;

@Entrypoint(eventBus=@EventBusPolicy(registerInstance=false))
@EventListener(phase="stationapi:internal")
public final class EntityClientNetworkHandler {
    @EventListener
    private static void registerMessageListeners(MessageListenerRegistryEvent event) {
        Registry.register((Registry)event.registry, (Identifier)StationAPI.NAMESPACE.id("spawn_entity"), EntityClientNetworkHandler::handleEntitySpawn);
        StationAPI.EVENT_BUS.post((Event)new EntityHandlerRegistryEvent());
        Registry.register((Registry)event.registry, (Identifier)StationAPI.NAMESPACE.id("spawn_mob"), EntityClientNetworkHandler::handleMobSpawn);
        StationAPI.EVENT_BUS.post((Event)new MobHandlerRegistryEvent());
    }

    private static void handleEntitySpawn(class_54 player, MessagePacket message) {
        QuadFunction entityHandler = (QuadFunction)EntityHandlerRegistry.INSTANCE.get(Identifier.of((String)message.strings[0]));
        if (entityHandler != null) {
            double x = (double)message.ints[1] / 32.0;
            double y = (double)message.ints[2] / 32.0;
            double z = (double)message.ints[3] / 32.0;
            ClientNetworkHandlerAccessor networkHandler = (ClientNetworkHandlerAccessor)((Minecraft)FabricLoader.getInstance().getGameInstance()).method_2145();
            class_454 world = networkHandler.getField_1973();
            class_57 entity = (class_57)entityHandler.apply((Object)world, (Object)x, (Object)y, (Object)z);
            if (entity != null) {
                entity.field_1654 = message.ints[1];
                entity.field_1655 = message.ints[2];
                entity.field_1656 = message.ints[3];
                entity.field_1606 = 0.0f;
                entity.field_1607 = 0.0f;
                entity.field_1591 = message.ints[0];
                world.method_1495(message.ints[0], entity);
                if (message.ints[4] > 0) {
                    if (entity instanceof HasOwner) {
                        HasOwner hasOwner = (HasOwner)entity;
                        hasOwner.setOwner(networkHandler.invokeMethod_1645(message.ints[4]));
                    }
                    entity.method_1365((double)message.shorts[0] / 8000.0, (double)message.shorts[1] / 8000.0, (double)message.shorts[2] / 8000.0);
                }
                if (entity instanceof StationSpawnDataProvider) {
                    StationSpawnDataProvider provider = (StationSpawnDataProvider)entity;
                    provider.readFromMessage(message);
                }
            }
        }
    }

    private static void handleMobSpawn(class_54 player, MessagePacket message) {
        Function mobHandler = (Function)MobHandlerRegistry.INSTANCE.get(Identifier.of((String)message.strings[0]));
        if (mobHandler != null) {
            double x = (double)message.ints[1] / 32.0;
            double y = (double)message.ints[2] / 32.0;
            double z = (double)message.ints[3] / 32.0;
            float yaw = (float)(message.bytes[0] * 360) / 256.0f;
            float pitch = (float)(message.bytes[1] * 360) / 256.0f;
            ClientNetworkHandlerAccessor networkHandler = (ClientNetworkHandlerAccessor)((Minecraft)FabricLoader.getInstance().getGameInstance()).method_2145();
            class_454 world = networkHandler.getField_1973();
            class_127 mob = (class_127)mobHandler.apply(world);
            if (mob != null) {
                mob.field_1654 = message.ints[1];
                mob.field_1655 = message.ints[2];
                mob.field_1656 = message.ints[3];
                mob.field_1591 = message.ints[0];
                mob.method_1338(x, y, z, yaw, pitch);
                mob.field_1026 = true;
                world.method_1495(message.ints[0], (class_57)mob);
                List data = class_216.method_1503((DataInputStream)new DataInputStream(new ByteArrayInputStream(Arrays.copyOfRange(message.bytes, 2, message.bytes.length))));
                if (data != null) {
                    mob.method_1331().method_1511(data);
                }
                if (mob instanceof StationSpawnDataProvider) {
                    StationSpawnDataProvider provider = (StationSpawnDataProvider)mob;
                    provider.readFromMessage(message);
                }
            }
        }
    }
}

