/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_259;
import net.minecraft.class_339;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.registry.RegistryEntry;
import net.modificationstation.stationapi.api.registry.RegistryEntryList;
import net.modificationstation.stationapi.api.state.State;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.tag.TagKey;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import net.modificationstation.stationapi.impl.block.StationFlatteningBlockInternal;

public abstract class AbstractBlockState
extends State<class_17, BlockState> {
    private final boolean isAir;
    private final class_15 material;
    private final class_259 materialColor;
    private final boolean toolRequired;
    private final boolean opaque;
    private int luminance = -1;

    protected AbstractBlockState(class_17 block, ImmutableMap<Property<?>, Comparable<?>> propertyMap, MapCodec<BlockState> mapCodec) {
        super(block, propertyMap, mapCodec);
        this.isAir = block.field_1900 == class_15.field_979;
        this.material = block.field_1900;
        this.materialColor = block.field_1900.field_973;
        this.toolRequired = !block.field_1900.method_898();
        this.opaque = block.method_1620();
    }

    public class_17 getBlock() {
        return (class_17)this.owner;
    }

    public class_15 getMaterial() {
        return this.material;
    }

    public int getLuminance() {
        return this.luminance == -1 ? (this.luminance = ((StationFlatteningBlockInternal)this.owner).stationapi_getLuminanceProvider().applyAsInt(this.asBlockState())) : this.luminance;
    }

    public boolean isAir() {
        return this.isAir;
    }

    public class_259 getTopMaterialColor(class_14 world, class_339 pos) {
        return this.materialColor;
    }

    public float getHardness(class_14 world, class_339 pos) {
        return this.getBlock().getHardness(this.asBlockState(), world, pos);
    }

    public float calcBlockBreakingDelta(class_54 player, class_14 world, class_339 pos) {
        return this.getBlock().calcBlockBreakingDelta(this.asBlockState(), player, world, pos);
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean canReplace(ItemPlacementContext context) {
        return this.getBlock().canReplace(this.asBlockState(), context);
    }

    public boolean isIn(TagKey<class_17> tag) {
        return this.getBlock().getRegistryEntry().isIn(tag);
    }

    public boolean isIn(TagKey<class_17> tag, Predicate<AbstractBlockState> predicate) {
        return this.isIn(tag) && predicate.test(this);
    }

    public boolean isIn(RegistryEntryList<class_17> blocks) {
        return blocks.contains((RegistryEntry)this.getBlock().getRegistryEntry());
    }

    public Stream<TagKey<class_17>> streamTags() {
        return this.getBlock().getRegistryEntry().streamTags();
    }

    public boolean isOf(class_17 block) {
        return this.getBlock() == block;
    }

    public boolean hasRandomTicks() {
        return class_17.field_1938[this.getBlock().field_1915];
    }

    @Environment(value=EnvType.CLIENT)
    public long getRenderingSeed(class_339 pos) {
        return MathHelper.hashCode((int)pos.field_2100, (int)pos.field_2101, (int)pos.field_2102);
    }

    protected abstract BlockState asBlockState();

    public boolean isToolRequired() {
        return this.toolRequired;
    }
}

