/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.item;

import net.minecraft.class_18;
import net.minecraft.class_26;
import net.minecraft.class_27;
import net.minecraft.class_31;
import net.minecraft.class_339;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.item.ItemUsageContext;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

public class ItemPlacementContext
extends ItemUsageContext {
    private final class_339 placementPos;
    protected boolean canReplaceExisting;

    public ItemPlacementContext(class_54 player, class_31 stack, class_27 hitResult) {
        this(player.field_1596, player, stack, hitResult);
    }

    public ItemPlacementContext(ItemUsageContext context) {
        this(context.getWorld(), context.getPlayer(), context.getStack(), context.getHitResult());
    }

    protected ItemPlacementContext(class_18 world, @Nullable class_54 playerEntity, class_31 itemStack, class_27 blockHitResult) {
        super(world, playerEntity, itemStack, blockHitResult);
        this.placementPos = new class_339(blockHitResult.field_1984, blockHitResult.field_1985, blockHitResult.field_1986).offset(Direction.byId((int)blockHitResult.field_1987));
        this.canReplaceExisting = world.getBlockState(blockHitResult.field_1984, blockHitResult.field_1985, blockHitResult.field_1986).canReplace(this);
    }

    public static ItemPlacementContext offset(ItemPlacementContext context, class_339 pos, Direction side) {
        return new ItemPlacementContext(context.getWorld(), context.getPlayer(), context.getStack(), new class_27(pos.getX(), pos.getY(), pos.getZ(), side.getId(), class_26.method_1297((double)((double)pos.getX() + 0.5 + (double)side.getOffsetX() * 0.5), (double)((double)pos.getY() + 0.5 + (double)side.getOffsetY() * 0.5), (double)((double)pos.getZ() + 0.5 + (double)side.getOffsetZ() * 0.5))));
    }

    @Override
    public class_339 getBlockPos() {
        return this.canReplaceExisting ? super.getBlockPos() : this.placementPos;
    }

    public boolean canPlace() {
        return this.canReplaceExisting || this.getWorld().getBlockState(this.getBlockPos()).canReplace(this);
    }

    public boolean canReplaceExisting() {
        return this.canReplaceExisting;
    }

    public Direction getPlayerLookDirection() {
        return Direction.getEntityFacingOrder((class_57)this.getPlayer())[0];
    }

    public Direction getVerticalPlayerLookDirection() {
        return Direction.getLookDirectionForAxis((class_57)this.getPlayer(), (Direction.Axis)Direction.Axis.Y);
    }

    public Direction[] getPlacementDirections() {
        int i;
        Direction[] directions = Direction.getEntityFacingOrder((class_57)this.getPlayer());
        if (this.canReplaceExisting) {
            return directions;
        }
        Direction direction = this.getSide();
        for (i = 0; i < directions.length && directions[i] != direction.getOpposite(); ++i) {
        }
        if (i > 0) {
            System.arraycopy(directions, 0, directions, 1, i);
            directions[0] = direction.getOpposite();
        }
        return directions;
    }
}

