/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.nbt;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_17;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.block.States;
import net.modificationstation.stationapi.api.registry.BlockRegistry;
import net.modificationstation.stationapi.api.registry.RegistryEntry;
import net.modificationstation.stationapi.api.registry.RegistryEntryLookup;
import net.modificationstation.stationapi.api.registry.RegistryKey;
import net.modificationstation.stationapi.api.state.State;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.mixin.nbt.NbtCompoundAccessor;

public class FlatteningNbtHelper {
    public static BlockState toBlockState(RegistryEntryLookup<class_17> blockLookup, class_8 nbt) {
        if (!nbt.method_1023("Name")) {
            return States.AIR.get();
        }
        Identifier identifier = Identifier.of((String)nbt.method_1031("Name"));
        Optional optional = blockLookup.getOptional(RegistryKey.of(BlockRegistry.KEY, (Identifier)identifier));
        if (optional.isEmpty()) {
            return States.AIR.get();
        }
        class_17 block = (class_17)((RegistryEntry.Reference)optional.get()).value();
        BlockState blockState = block.getDefaultState();
        if (nbt.method_1023("Properties")) {
            class_8 nbtCompound = nbt.method_1033("Properties");
            StateManager stateManager = block.getStateManager();
            for (String string : ((NbtCompoundAccessor)nbtCompound).stationapi$getEntries().keySet()) {
                Property<?> property = stateManager.getProperty(string);
                if (property == null) continue;
                blockState = FlatteningNbtHelper.withProperty(blockState, property, string, nbtCompound, nbt);
            }
        }
        return blockState;
    }

    private static <S extends State<?, S>, T extends Comparable<T>> S withProperty(S state, Property<T> property, String key, class_8 properties, class_8 root) {
        Optional<T> optional = property.parse(properties.method_1031(key));
        if (optional.isPresent()) {
            return (S)((State)state.with(property, (Comparable)((Comparable)optional.get())));
        }
        StationAPI.LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", (Object)key, (Object)properties.method_1031(key), (Object)root.toString());
        return state;
    }

    public static class_8 fromBlockState(BlockState state) {
        class_8 nbtCompound = new class_8();
        nbtCompound.method_1019("Name", Objects.requireNonNull(BlockRegistry.INSTANCE.getId(state.getBlock())).toString());
        ImmutableMap<Property<?>, Comparable<?>> immutableMap = state.getEntries();
        if (!immutableMap.isEmpty()) {
            class_8 nbtCompound2 = new class_8();
            for (Map.Entry entry : immutableMap.entrySet()) {
                Property property = (Property)entry.getKey();
                nbtCompound2.method_1019(property.getName(), FlatteningNbtHelper.nameValue(property, (Comparable)entry.getValue()));
            }
            nbtCompound.method_1018("Properties", nbtCompound2);
        }
        return nbtCompound;
    }

    private static <T extends Comparable<T>> String nameValue(Property<T> property, Comparable<?> value) {
        return property.name(value);
    }
}

