/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.state;

import com.google.common.collect.ArrayTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.modificationstation.stationapi.api.state.StatePropertyTableCache;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.util.collection.FastImmutableTable;
import net.modificationstation.stationapi.api.util.collection.FastImmutableTableCache;
import org.jetbrains.annotations.Nullable;

public abstract class State<O, S> {
    private static final Function<Map.Entry<Property<?>, Comparable<?>>, String> PROPERTY_MAP_PRINTER = new Function<Map.Entry<Property<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<Property<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            Property<?> property = entry.getKey();
            return property.getName() + "=" + this.nameValue(property, entry.getValue());
        }

        private <T extends Comparable<T>> String nameValue(Property<T> property, Comparable<?> value) {
            return property.name(value);
        }
    };
    protected final O owner;
    private final ImmutableMap<Property<?>, Comparable<?>> entries;
    private Table<Property<?>, Comparable<?>, S> withTable;
    protected final MapCodec<S> codec;

    protected State(O owner, ImmutableMap<Property<?>, Comparable<?>> entries, MapCodec<S> codec) {
        this.owner = owner;
        this.entries = entries;
        this.codec = codec;
    }

    public <T extends Comparable<T>> S cycle(Property<T> property) {
        return this.with(property, (Comparable)State.getNext(property.getValues(), this.get(property)));
    }

    protected static <T> T getNext(Collection<T> values, T value) {
        Iterator<T> iterator = values.iterator();
        do {
            if (iterator.hasNext()) continue;
            return iterator.next();
        } while (!iterator.next().equals(value));
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return values.iterator().next();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.owner);
        if (!this.getEntries().isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(this.getEntries().entrySet().stream().map(PROPERTY_MAP_PRINTER).collect(Collectors.joining(",")));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public Collection<Property<?>> getProperties() {
        return Collections.unmodifiableCollection(this.entries.keySet());
    }

    public <T extends Comparable<T>> boolean contains(Property<T> property) {
        return this.entries.containsKey(property);
    }

    public <T extends Comparable<T>> T get(Property<T> property) {
        Comparable comparable = (Comparable)this.entries.get(property);
        if (comparable == null) {
            throw new IllegalArgumentException("Cannot get property " + String.valueOf(property) + " as it does not exist in " + String.valueOf(this.owner));
        }
        return (T)((Comparable)property.getType().cast(comparable));
    }

    public <T extends Comparable<T>> Optional<T> method_28500(Property<T> property) {
        Comparable comparable = (Comparable)this.entries.get(property);
        return comparable == null ? Optional.empty() : Optional.of((Comparable)property.getType().cast(comparable));
    }

    public <T extends Comparable<T>, V extends T> S with(Property<T> property, V value) {
        Comparable comparable = (Comparable)this.entries.get(property);
        if (comparable == null) {
            throw new IllegalArgumentException("Cannot set property " + String.valueOf(property) + " as it does not exist in " + String.valueOf(this.owner));
        }
        if (comparable == value) {
            return (S)this;
        }
        Object object = this.withTable.get(property, value);
        if (object == null) {
            throw new IllegalArgumentException("Cannot set property " + String.valueOf(property) + " to " + String.valueOf(value) + " on " + String.valueOf(this.owner) + ", it is not an allowed value");
        }
        return (S)object;
    }

    public void createWithTable(Map<Map<Property<?>, Comparable<?>>, S> states) {
        if (this.withTable != null) {
            throw new IllegalStateException();
        }
        HashBasedTable table = HashBasedTable.create();
        for (Map.Entry propertyComparableEntry : this.entries.entrySet()) {
            Property property = (Property)propertyComparableEntry.getKey();
            for (Comparable value : property.getValues()) {
                if (value == propertyComparableEntry.getValue()) continue;
                table.put((Object)property, (Object)value, states.get(this.toMapWith(property, value)));
            }
        }
        this.withTable = table.isEmpty() ? table : ArrayTable.create((Table)table);
        FastImmutableTableCache fitCache = StatePropertyTableCache.getTableCache(this.owner);
        if (fitCache != null) {
            this.withTable = new FastImmutableTable(this.withTable, fitCache);
        }
    }

    private Map<Property<?>, Comparable<?>> toMapWith(Property<?> property, Comparable<?> value) {
        HashMap map = Maps.newHashMap(this.entries);
        map.put(property, value);
        return map;
    }

    public ImmutableMap<Property<?>, Comparable<?>> getEntries() {
        return this.entries;
    }

    protected static <O, S extends State<O, S>> Codec<S> createCodec(Codec<O> codec, Function<O, S> ownerToStateFunction) {
        return codec.dispatch("Name", state -> state.owner, object -> {
            State state = (State)ownerToStateFunction.apply(object);
            return state.getEntries().isEmpty() ? Codec.unit((Object)state) : state.codec.fieldOf("Properties").codec();
        });
    }
}

