/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.state.property;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import net.modificationstation.stationapi.api.state.property.Property;

public class BooleanProperty
extends Property<Boolean> {
    private final ImmutableSet<Boolean> values = ImmutableSet.of((Object)true, (Object)false);

    protected BooleanProperty(String name) {
        super(name, Boolean.class);
    }

    @Override
    public Collection<Boolean> getValues() {
        return this.values;
    }

    public static BooleanProperty of(String name) {
        return new BooleanProperty(name);
    }

    @Override
    public Optional<Boolean> parse(String name) {
        return "true".equals(name) || "false".equals(name) ? Optional.of(Boolean.valueOf(name)) : Optional.empty();
    }

    @Override
    public String name(Boolean boolean_) {
        return boolean_.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof BooleanProperty)) return false;
        BooleanProperty booleanProperty = (BooleanProperty)object;
        if (!super.equals(object)) return false;
        if (!this.values.equals(booleanProperty.values)) return false;
        return true;
    }

    @Override
    public int computeHashCode() {
        return 31 * super.computeHashCode() + this.values.hashCode();
    }
}

