/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_18;
import net.minecraft.class_240;
import net.minecraft.class_6;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.network.packet.IdentifiablePacket;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.impl.network.StationFlatteningPacketHandler;
import net.modificationstation.stationapi.impl.world.chunk.ChunkSection;
import net.modificationstation.stationapi.impl.world.chunk.FlattenedChunk;
import org.jetbrains.annotations.ApiStatus;

public class FlattenedChunkDataS2CPacket
extends class_6
implements IdentifiablePacket {
    public static final Identifier PACKET_ID = StationAPI.NAMESPACE.id("flattening/chunk_data");
    public int chunkX;
    public int chunkZ;
    private int sectionsSize;
    public byte[] sectionsData;

    @ApiStatus.Internal
    public FlattenedChunkDataS2CPacket() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Environment(value=EnvType.SERVER)
    public FlattenedChunkDataS2CPacket(class_18 world, int chunkX, int chunkZ) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        FlattenedChunk chunk = (FlattenedChunk)world.method_214(chunkX, chunkZ);
        ChunkSection[] sections = chunk.sections;
        byte[] sectionsData = new byte[FlattenedChunkDataS2CPacket.getSectionsPacketSize(chunk)];
        ByteBuffer buf = ByteBuffer.wrap(sectionsData);
        for (ChunkSection section : sections) {
            Objects.requireNonNullElse(section, ChunkSection.EMPTY).toPacket(buf);
        }
        Deflater deflater = new Deflater(-1);
        try {
            deflater.setInput(sectionsData);
            deflater.finish();
            this.sectionsData = new byte[sectionsData.length];
            this.sectionsSize = deflater.deflate(this.sectionsData);
        }
        finally {
            deflater.end();
        }
    }

    private static int getSectionsPacketSize(FlattenedChunk chunk) {
        int i = 0;
        for (ChunkSection chunkSection : chunk.sections) {
            i += Objects.requireNonNullElse(chunkSection, ChunkSection.EMPTY).getPacketSize();
        }
        return i;
    }

    public void method_806(DataInputStream in) {
        try {
            this.chunkX = in.readInt();
            this.chunkZ = in.readInt();
            int realSectionsSize = in.readInt();
            int sectionsSize = in.readInt();
            byte[] sectionsData = new byte[sectionsSize];
            in.readFully(sectionsData);
            this.sectionsData = new byte[realSectionsSize];
            Inflater inflater = new Inflater();
            inflater.setInput(sectionsData);
            try {
                inflater.inflate(this.sectionsData);
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException("Bad compressed data format");
            }
            finally {
                inflater.end();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_807(DataOutputStream out) {
        try {
            out.writeInt(this.chunkX);
            out.writeInt(this.chunkZ);
            out.writeInt(this.sectionsData.length);
            out.writeInt(this.sectionsSize);
            out.write(this.sectionsData, 0, this.sectionsSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_808(class_240 handler) {
        ((StationFlatteningPacketHandler)handler).onMapChunk(this);
    }

    public int method_798() {
        return 16 + this.sectionsSize;
    }

    public Identifier getId() {
        return PACKET_ID;
    }
}

