/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.class_169;
import net.minecraft.class_18;
import net.minecraft.class_240;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.network.packet.IdentifiablePacket;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.impl.network.StationFlatteningPacketHandler;
import net.modificationstation.stationapi.impl.world.chunk.ChunkSection;
import net.modificationstation.stationapi.impl.world.chunk.FlattenedChunk;
import org.jetbrains.annotations.ApiStatus;

public class FlattenedChunkSectionDataS2CPacket
extends class_169
implements IdentifiablePacket {
    public static final Identifier PACKET_ID = StationAPI.NAMESPACE.id("flattening/chunk_section_data");
    public int chunkX;
    public int chunkZ;
    public int sectionIndex;
    private int sectionSize;
    public byte[] sectionData;

    @ApiStatus.Internal
    public FlattenedChunkSectionDataS2CPacket() {
        this.field_906 = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlattenedChunkSectionDataS2CPacket(class_18 world, int chunkX, int chunkZ, int sectionIndex) {
        this.field_906 = true;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.sectionIndex = sectionIndex;
        FlattenedChunk chunk = (FlattenedChunk)world.method_214(chunkX, chunkZ);
        ChunkSection section = Objects.requireNonNullElse(chunk.sections[sectionIndex], ChunkSection.EMPTY);
        byte[] sectionData = new byte[section.getPacketSize()];
        ByteBuffer buf = ByteBuffer.wrap(sectionData);
        section.toPacket(buf);
        Deflater deflater = new Deflater(-1);
        try {
            deflater.setInput(sectionData);
            deflater.finish();
            this.sectionData = new byte[sectionData.length];
            this.sectionSize = deflater.deflate(this.sectionData);
        }
        finally {
            deflater.end();
        }
    }

    public void method_806(DataInputStream in) {
        try {
            this.chunkX = in.readInt();
            this.chunkZ = in.readInt();
            this.sectionIndex = in.read();
            int realSectionSize = in.readInt();
            int sectionSize = in.readInt();
            byte[] sectionData = new byte[sectionSize];
            in.readFully(sectionData);
            this.sectionData = new byte[realSectionSize];
            Inflater inflater = new Inflater();
            inflater.setInput(sectionData);
            try {
                inflater.inflate(this.sectionData);
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException("Bad compressed data format");
            }
            finally {
                inflater.end();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_807(DataOutputStream out) {
        try {
            out.writeInt(this.chunkX);
            out.writeInt(this.chunkZ);
            out.write(this.sectionIndex);
            out.writeInt(this.sectionData.length);
            out.writeInt(this.sectionSize);
            out.write(this.sectionData, 0, this.sectionSize);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_808(class_240 arg) {
        ((StationFlatteningPacketHandler)arg).onChunkSection(this);
    }

    public int method_798() {
        return 17 + this.sectionSize;
    }

    public Identifier getId() {
        return PACKET_ID;
    }
}

