/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_240;
import net.minecraft.class_441;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.network.packet.IdentifiablePacket;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.impl.network.StationFlatteningPacketHandler;
import net.modificationstation.stationapi.impl.util.math.ChunkSectionPos;
import net.modificationstation.stationapi.impl.world.chunk.ChunkSection;
import net.modificationstation.stationapi.impl.world.chunk.FlattenedChunk;
import org.jetbrains.annotations.ApiStatus;

public class FlattenedMultiBlockChangeS2CPacket
extends class_441
implements IdentifiablePacket {
    public static final Identifier PACKET_ID = StationAPI.NAMESPACE.id("flattening/multi_block_change");
    public int sectionIndex;
    public int[] stateArray;

    @ApiStatus.Internal
    public FlattenedMultiBlockChangeS2CPacket() {
    }

    public FlattenedMultiBlockChangeS2CPacket(int chunkX, int chunkZ, int sectionIndex, short[] positions, int arraySize, class_18 world) {
        this.field_2153 = chunkX;
        this.field_2154 = chunkZ;
        this.sectionIndex = sectionIndex;
        this.field_2158 = arraySize;
        this.field_2155 = new short[arraySize];
        this.stateArray = new int[arraySize];
        this.field_2157 = new byte[arraySize];
        ChunkSection section = Objects.requireNonNullElse(((FlattenedChunk)world.method_214((int)chunkX, (int)chunkZ)).sections[sectionIndex], ChunkSection.EMPTY);
        for (int i = 0; i < arraySize; ++i) {
            short position;
            this.field_2155[i] = position = positions[i];
            int localX = ChunkSectionPos.unpackLocalX(position);
            int localY = ChunkSectionPos.unpackLocalY(position);
            int localZ = ChunkSectionPos.unpackLocalZ(position);
            this.stateArray[i] = class_17.STATE_IDS.getRawId((Object)section.getBlockState(localX, localY, localZ));
            this.field_2157[i] = (byte)section.getMeta(localX, localY, localZ);
        }
    }

    public void method_806(DataInputStream in) {
        try {
            int i;
            this.field_2153 = in.readInt();
            this.field_2154 = in.readInt();
            this.sectionIndex = in.read();
            this.field_2158 = in.read();
            this.field_2155 = new short[this.field_2158];
            this.stateArray = new int[this.field_2158];
            this.field_2157 = new byte[this.field_2158];
            for (i = 0; i < this.field_2158; ++i) {
                this.field_2155[i] = in.readShort();
            }
            for (i = 0; i < this.field_2158; ++i) {
                this.stateArray[i] = in.readInt();
            }
            in.readFully(this.field_2157);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_807(DataOutputStream out) {
        try {
            out.writeInt(this.field_2153);
            out.writeInt(this.field_2154);
            out.write(this.sectionIndex);
            out.write(this.field_2158);
            for (short position : this.field_2155) {
                out.writeShort(position);
            }
            for (int stateId : this.stateArray) {
                out.writeInt(stateId);
            }
            out.write(this.field_2157);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void method_808(class_240 handler) {
        ((StationFlatteningPacketHandler)handler).onMultiBlockChange(this);
    }

    public int method_798() {
        return 10 + this.field_2158 * 7;
    }

    public Identifier getId() {
        return PACKET_ID;
    }
}

