/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.world;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_187;
import net.minecraft.class_202;
import net.minecraft.class_206;
import net.minecraft.class_43;
import net.minecraft.class_55;
import net.minecraft.class_56;
import net.minecraft.class_57;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.block.States;
import net.modificationstation.stationapi.api.nbt.NbtOps;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;
import net.modificationstation.stationapi.impl.world.chunk.ChunkSection;
import net.modificationstation.stationapi.impl.world.chunk.FlattenedChunk;
import net.modificationstation.stationapi.impl.world.chunk.PalettedContainer;
import org.apache.logging.log4j.Logger;

public class FlattenedWorldManager {
    private static final Codec<PalettedContainer<BlockState>> CODEC = PalettedContainer.createCodec(class_17.STATE_IDS, BlockState.CODEC, PalettedContainer.PaletteProvider.BLOCK_STATE, States.AIR.get());
    public static final String SECTIONS = Identifier.of((Namespace)StationAPI.NAMESPACE, (String)"sections").toString();
    private static final String METADATA_KEY = "data";
    private static final String SKY_LIGHT_KEY = "sky_light";
    private static final String BLOCK_LIGHT_KEY = "block_light";
    private static final String HEIGHTMAP_KEY = "height_map";
    private static final String HEIGHT_KEY = "y";

    public static void saveChunk(FlattenedChunk chunk, class_18 world, class_8 chunkTag) {
        world.method_251();
        chunkTag.method_1015("xPos", chunk.field_962);
        chunkTag.method_1015("zPos", chunk.field_963);
        chunkTag.method_1016("LastUpdate", world.method_256());
        ChunkSection[] sections = chunk.sections;
        class_202 sectionTags = new class_202();
        for (int sectionY = world.getBottomSectionCoord(); sectionY < world.getTopSectionCoord() + 2; ++sectionY) {
            ChunkSection section;
            int index = world.sectionCoordToIndex(sectionY);
            if (index < 0 || index >= sections.length || ChunkSection.isEmpty(section = sections[index])) continue;
            class_8 sectionTag = new class_8();
            sectionTag.method_1012(HEIGHT_KEY, (byte)sectionY);
            sectionTag.method_1017("block_states", (class_187)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, section.getBlockStateContainer()).getOrThrow(false, arg_0 -> ((Logger)StationAPI.LOGGER).error(arg_0)));
            sectionTag.method_1017(METADATA_KEY, (class_187)section.getMetadataArray().toTag());
            sectionTag.method_1017(SKY_LIGHT_KEY, (class_187)section.getLightArray(class_56.field_2757).toTag());
            sectionTag.method_1017(BLOCK_LIGHT_KEY, (class_187)section.getLightArray(class_56.field_2758).toTag());
            sectionTags.method_1397((class_187)sectionTag);
        }
        chunkTag.method_1017(SECTIONS, (class_187)sectionTags);
        chunkTag.method_1022(HEIGHTMAP_KEY, chunk.getStoredHeightmap());
        chunkTag.method_1021("TerrainPopulated", chunk.field_966);
        chunk.field_969 = false;
        class_202 entityTags = new class_202();
        for (int i = 0; i < chunk.field_965.length; ++i) {
            for (Object object : chunk.field_965[i]) {
                chunk.field_969 = true;
                class_8 entityTag = new class_8();
                if (!((class_57)object).method_1343(entityTag)) continue;
                entityTags.method_1397((class_187)entityTag);
            }
        }
        chunkTag.method_1017("Entities", (class_187)entityTags);
        class_202 tileEntityTags = new class_202();
        for (Object object : chunk.field_964.values()) {
            class_8 tileEntityTag = new class_8();
            ((class_55)object).method_1078(tileEntityTag);
            tileEntityTags.method_1397((class_187)tileEntityTag);
        }
        chunkTag.method_1017("TileEntities", (class_187)tileEntityTags);
    }

    public static class_43 loadChunk(class_18 world, class_8 chunkTag) {
        class_202 tileEntityTags;
        int i;
        int xPos = chunkTag.method_1027("xPos");
        int zPos = chunkTag.method_1027("zPos");
        FlattenedChunk chunk = new FlattenedChunk(world, xPos, zPos);
        ChunkSection[] sections = chunk.sections;
        if (chunkTag.method_1023(SECTIONS)) {
            class_202 sectionTags = chunkTag.method_1034(SECTIONS);
            for (i = 0; i < sectionTags.method_1398(); ++i) {
                class_8 sectionTag = (class_8)sectionTags.method_1396(i);
                byte sectionY = sectionTag.method_1025(HEIGHT_KEY);
                int index = world.sectionCoordToIndex((int)sectionY);
                if (index < 0 || index >= sections.length) continue;
                PalettedContainer blockStates = sectionTag.method_1023("block_states") ? (PalettedContainer)CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)sectionTag.method_1033("block_states")).promotePartial(errorMessage -> FlattenedWorldManager.logRecoverableError(xPos, zPos, sectionY, errorMessage)).getOrThrow(false, arg_0 -> ((Logger)StationAPI.LOGGER).error(arg_0)) : new PalettedContainer(class_17.STATE_IDS, States.AIR.get(), PalettedContainer.PaletteProvider.BLOCK_STATE);
                ChunkSection chunkSection = new ChunkSection(sectionY, blockStates);
                chunkSection.getMetadataArray().copyArray(sectionTag.method_1032(METADATA_KEY));
                chunkSection.getLightArray(class_56.field_2757).copyArray(sectionTag.method_1032(SKY_LIGHT_KEY));
                chunkSection.getLightArray(class_56.field_2758).copyArray(sectionTag.method_1032(BLOCK_LIGHT_KEY));
                sections[index] = chunkSection;
            }
        }
        chunk.loadStoredHeightmap(chunkTag.method_1032(HEIGHTMAP_KEY));
        chunk.field_966 = chunkTag.method_1035("TerrainPopulated");
        class_202 entityTags = chunkTag.method_1034("Entities");
        if (entityTags != null) {
            for (i = 0; i < entityTags.method_1398(); ++i) {
                class_8 compoundTag = (class_8)entityTags.method_1396(i);
                class_57 object = class_206.method_730((class_8)compoundTag, (class_18)world);
                chunk.field_969 = true;
                if (object == null) continue;
                chunk.method_868(object);
            }
        }
        if ((tileEntityTags = chunkTag.method_1034("TileEntities")) != null) {
            for (int i2 = 0; i2 < tileEntityTags.method_1398(); ++i2) {
                class_8 object = (class_8)tileEntityTags.method_1396(i2);
                class_55 tileEntityBase = class_55.method_1068((class_8)object);
                if (tileEntityBase == null) continue;
                chunk.method_867(tileEntityBase);
            }
        }
        return chunk;
    }

    private static void logRecoverableError(int chunkX, int chunkZ, int y, String message) {
        StationAPI.LOGGER.error("Recoverable errors when loading section [" + chunkX + ", " + y + ", " + chunkZ + "]: " + message);
    }
}

