/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.world.chunk;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_17;
import net.minecraft.class_56;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.block.States;
import net.modificationstation.stationapi.api.util.Util;
import net.modificationstation.stationapi.api.util.collection.IndexedIterable;
import net.modificationstation.stationapi.impl.world.chunk.NibbleArray;
import net.modificationstation.stationapi.impl.world.chunk.PalettedContainer;
import org.jetbrains.annotations.Nullable;

public class ChunkSection {
    private static final byte[] INITIAL_SKY_LIGHT = (byte[])Util.make((Object)new byte[2048], array -> Arrays.fill(array, (byte)(class_56.field_2757.field_2759 << 4 | class_56.field_2757.field_2759)));
    public static final ChunkSection EMPTY = (ChunkSection)Util.make((Object)new ChunkSection(0), ChunkSection::initSkyLight);
    private final short yOffset;
    private short nonEmptyBlockCount;
    private short randomTickableBlockCount;
    private short nonEmptyFluidCount;
    private final PalettedContainer<BlockState> blockStateContainer;
    private final NibbleArray metadataArray = new NibbleArray(4096);
    private final NibbleArray skyLightArray = new NibbleArray(4096);
    private final NibbleArray blockLightArray = new NibbleArray(4096);

    public ChunkSection(int chunkPos, PalettedContainer<BlockState> blockStateContainer) {
        this.yOffset = (short)ChunkSection.blockCoordFromChunkCoord(chunkPos);
        this.blockStateContainer = blockStateContainer;
        this.calculateCounts();
    }

    public ChunkSection(int chunkPos) {
        this.yOffset = (short)ChunkSection.blockCoordFromChunkCoord(chunkPos);
        this.blockStateContainer = new PalettedContainer<BlockState>((IndexedIterable<BlockState>)class_17.STATE_IDS, States.AIR.get(), PalettedContainer.PaletteProvider.BLOCK_STATE);
    }

    public static int blockCoordFromChunkCoord(int chunkPos) {
        return chunkPos << 4;
    }

    public BlockState getBlockState(int x, int y, int z) {
        return this.blockStateContainer.get(x, y, z);
    }

    public BlockState setBlockState(int x, int y, int z, BlockState state) {
        BlockState blockState = this.blockStateContainer.swap(x, y, z, state);
        if (!blockState.isAir()) {
            this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount - 1);
            if (blockState.hasRandomTicks()) {
                this.randomTickableBlockCount = (short)(this.randomTickableBlockCount - 1);
            }
        }
        if (!state.isAir()) {
            this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount + 1);
            if (state.hasRandomTicks()) {
                this.randomTickableBlockCount = (short)(this.randomTickableBlockCount + 1);
            }
        }
        return blockState;
    }

    public boolean isEmpty() {
        return this.nonEmptyBlockCount == 0;
    }

    public static boolean isEmpty(@Nullable ChunkSection section) {
        return section == null || section.isEmpty();
    }

    public boolean hasRandomTicks() {
        return this.hasRandomBlockTicks() || this.hasRandomFluidTicks();
    }

    public boolean hasRandomBlockTicks() {
        return this.randomTickableBlockCount > 0;
    }

    public boolean hasRandomFluidTicks() {
        return this.nonEmptyFluidCount > 0;
    }

    public int getYOffset() {
        return this.yOffset;
    }

    public void calculateCounts() {
        this.nonEmptyBlockCount = 0;
        this.randomTickableBlockCount = 0;
        this.nonEmptyFluidCount = 0;
        this.blockStateContainer.count((blockState, i) -> {
            if (!blockState.isAir()) {
                this.nonEmptyBlockCount = (short)(this.nonEmptyBlockCount + i);
                if (blockState.hasRandomTicks()) {
                    this.randomTickableBlockCount = (short)(this.randomTickableBlockCount + i);
                }
            }
        });
    }

    public PalettedContainer<BlockState> getBlockStateContainer() {
        return this.blockStateContainer;
    }

    public NibbleArray getMetadataArray() {
        return this.metadataArray;
    }

    @Environment(value=EnvType.CLIENT)
    public void readDataPacket(ByteBuffer buf) {
        this.nonEmptyBlockCount = buf.getShort();
        this.blockStateContainer.readPacket(buf);
        buf.get(this.metadataArray.data);
        buf.get(this.blockLightArray.data);
        buf.get(this.skyLightArray.data);
    }

    public void toPacket(ByteBuffer buf) {
        buf.putShort(this.nonEmptyBlockCount);
        this.blockStateContainer.writePacket(buf);
        buf.put(this.metadataArray.data);
        buf.put(this.blockLightArray.data);
        buf.put(this.skyLightArray.data);
    }

    public int getPacketSize() {
        return 2 + this.blockStateContainer.getPacketSize() + this.metadataArray.data.length + this.skyLightArray.data.length + this.blockLightArray.data.length;
    }

    public boolean hasAny(Predicate<BlockState> predicate) {
        return this.blockStateContainer.hasAny(predicate);
    }

    public int getMeta(int index) {
        return this.metadataArray.getValue(index);
    }

    public int getMeta(int x, int y, int z) {
        return this.getMeta(this.getIndex(x, y, z));
    }

    public void setMeta(int index, int meta) {
        this.metadataArray.setValue(index, meta);
    }

    public void setMeta(int x, int y, int z, int meta) {
        this.setMeta(this.getIndex(x, y, z), meta);
    }

    public int getLight(class_56 type, int index) {
        return this.getLightArray(type).getValue(index);
    }

    public int getLight(class_56 type, int x, int y, int z) {
        return this.getLight(type, this.getIndex(x, y, z));
    }

    public void setLight(class_56 type, int index, int light) {
        this.getLightArray(type).setValue(index, light);
    }

    public void setLight(class_56 type, int x, int y, int z, int light) {
        this.setLight(type, this.getIndex(x, y, z), light);
    }

    private int getIndex(int x, int y, int z) {
        return x << 8 | y << 4 | z;
    }

    public NibbleArray getLightArray(class_56 type) {
        return type == class_56.field_2758 ? this.blockLightArray : this.skyLightArray;
    }

    public void initSkyLight() {
        this.skyLightArray.copyArray(INITIAL_SKY_LIGHT);
    }
}

