/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.world.chunk;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mine_diver.unsafeevents.Event;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_189;
import net.minecraft.class_25;
import net.minecraft.class_339;
import net.minecraft.class_43;
import net.minecraft.class_55;
import net.minecraft.class_56;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.block.States;
import net.modificationstation.stationapi.api.event.block.BlockEvent;
import net.modificationstation.stationapi.api.event.world.BlockSetEvent;
import net.modificationstation.stationapi.api.event.world.MetaSetEvent;
import net.modificationstation.stationapi.api.event.world.WorldEvent;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import net.modificationstation.stationapi.impl.world.chunk.ChunkSection;
import net.modificationstation.stationapi.mixin.flattening.ChunkAccessor;

public class FlattenedChunk
extends class_43 {
    public final ChunkSection[] sections;
    public final short firstBlock;
    public final short lastBlock;
    private final short[] stationHeightmap = new short[256];

    public FlattenedChunk(class_18 world, int xPos, int zPos) {
        super(world, xPos, zPos);
        int countSections = this.field_956.countVerticalSections();
        this.sections = new ChunkSection[countSections];
        this.firstBlock = (short)this.field_956.getBottomY();
        this.lastBlock = (short)(this.field_956.getTopY() - 1);
        this.field_965 = new List[countSections];
        for (int i = 0; i < this.field_965.length; i = (int)((short)(i + 1))) {
            this.field_965[i] = new ArrayList();
        }
    }

    public void fromLegacy(byte[] tiles) {
        int mask = (tiles.length >> 8) - 1;
        int offsetZ = mask == 127 ? 7 : MathHelper.ceilLog2((int)(mask + 1));
        int offsetX = offsetZ + 4;
        for (int i = 0; i < tiles.length; ++i) {
            int by;
            int id = Byte.toUnsignedInt(tiles[i]);
            if (id == 0 || id >= class_17.field_1937.length || (by = i & mask) > this.lastBlock) continue;
            int bx = i >> offsetX & 0xF;
            int bz = i >> offsetZ & 0xF;
            Objects.requireNonNull(this.getOrCreateSection(by, false)).setBlockState(bx, by & 0xF, bz, class_17.field_1937[id].getDefaultState());
        }
    }

    public byte[] getStoredHeightmap() {
        byte[] heightmap = new byte[512];
        for (int i = 0; i < 512; i = (int)((short)(i + 1))) {
            byte val;
            short value = this.stationHeightmap[i >> 1];
            heightmap[i] = val = (i & 1) == 0 ? (byte)(value & 0xFF) : (byte)(value >> 8 & 0xFF);
        }
        return heightmap;
    }

    public void loadStoredHeightmap(byte[] heightmap) {
        if (heightmap.length == 256) {
            for (int i = 0; i < 256; i = (int)((short)(i + 1))) {
                this.stationHeightmap[i] = (short)(heightmap[i] & 0xFF);
            }
        } else {
            for (int i = 0; i < 256; i = (int)((short)(i + 1))) {
                int index = i << 1;
                this.stationHeightmap[i] = (short)(heightmap[index] | heightmap[index | 1] << 8);
            }
        }
    }

    private short getShortHeight(int x, int z) {
        return this.stationHeightmap[z << 4 | x];
    }

    public int method_874(int x, int z) {
        return this.getShortHeight(x, z);
    }

    public boolean method_879(int relX, int y, int relZ) {
        return y >= this.getShortHeight(relX, relZ);
    }

    private ChunkSection getSection(int y) {
        if (y < this.firstBlock || y > this.lastBlock) {
            return null;
        }
        return this.sections[this.field_956.sectionCoordToIndex(y >> 4)];
    }

    public int method_864(class_56 type, int x, int y, int z) {
        ChunkSection section = this.getSection(y);
        return section == null ? (type == class_56.field_2757 && this.field_956.field_216.field_2177 ? 0 : type.field_2759) : section.getLight(type, x, y & 0xF, z);
    }

    public ChunkSection getOrCreateSection(int y, boolean fillSkyLight) {
        if (y < this.firstBlock || y > this.lastBlock) {
            return null;
        }
        int index = this.field_956.sectionCoordToIndex(y >> 4);
        ChunkSection section = this.sections[index];
        if (section == null) {
            section = new ChunkSection(this.field_956.sectionIndexToCoord(index));
            if (!this.field_956.field_216.field_2177 && fillSkyLight) {
                section.initSkyLight();
            }
            this.sections[index] = section;
        }
        return section;
    }

    public void method_865(class_56 type, int x, int y, int z, int light) {
        this.field_967 = true;
        ChunkSection section = this.getOrCreateSection(y, true);
        if (section != null) {
            section.setLight(type, x, y & 0xF, z, light);
        }
    }

    public int method_880(int x, int y, int z, int light) {
        int blockLight;
        int lightLevel;
        ChunkSection section = this.getSection(y);
        int n = lightLevel = section == null ? 15 : section.getLight(class_56.field_2757, x, y & 0xF, z);
        if (lightLevel > 0) {
            field_953 = true;
        }
        int n2 = blockLight = section == null ? 0 : section.getLight(class_56.field_2758, x, y & 0xF, z);
        if (blockLight > (lightLevel -= light)) {
            lightLevel = blockLight;
        }
        return lightLevel;
    }

    private void setShortHeight(int x, int z, short height) {
        this.stationHeightmap[z << 4 | x] = height;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_892() {
        short chunkHeight = this.lastBlock;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                short height;
                for (height = this.lastBlock; height > this.firstBlock && class_17.field_1941[this.method_859(x, height - 1, z)] == 0; height = (short)(height - 1)) {
                }
                this.setShortHeight(x, z, height);
                if (height >= chunkHeight) continue;
                chunkHeight = height;
            }
        }
        this.field_961 = chunkHeight;
        this.field_967 = true;
    }

    public void method_873() {
        short minHeight = this.lastBlock;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                short height;
                for (height = this.lastBlock; height > this.firstBlock && class_17.field_1941[this.method_859(x, height - 1, z)] == 0; height = (short)(height - 1)) {
                }
                this.setShortHeight(x, z, height);
                if (height < minHeight) {
                    minHeight = height;
                }
                if (this.field_956.field_216.field_2177) continue;
                int light = 15;
                int lightY = this.lastBlock;
                do {
                    ChunkSection section;
                    if ((light -= class_17.field_1941[this.method_859(x, lightY, z)]) <= 0 || (section = this.getSection(lightY)) == null) continue;
                    section.setLight(class_56.field_2757, x, lightY & 0xF, z, light);
                } while (--lightY > this.firstBlock && light > 0);
            }
        }
        this.field_961 = minHeight;
        for (int i = 0; i < 256; i = (int)((short)(i + 1))) {
            ((ChunkAccessor)((Object)this)).invokeMethod_887(i & 0xF, i >> 4);
        }
        this.field_967 = true;
    }

    private void method_889(int x, int y, int z) {
        short height = this.getShortHeight(x, z);
        int maxHeight = Math.max(y, height);
        if (maxHeight > this.lastBlock) {
            maxHeight = this.lastBlock;
        }
        while (maxHeight > this.firstBlock && class_17.field_1941[this.method_859(x, maxHeight - 1, z)] == 0) {
            maxHeight = (short)(maxHeight - 1);
        }
        if (maxHeight != height) {
            int h;
            this.field_956.method_240(x, z, maxHeight, (int)height);
            this.setShortHeight(x, z, (short)maxHeight);
            if (maxHeight < this.field_961) {
                this.field_961 = maxHeight;
            } else {
                short var7 = this.lastBlock;
                for (int i = 0; i < 256; ++i) {
                    short mapHeight = this.stationHeightmap[i];
                    if (mapHeight >= var7) continue;
                    var7 = mapHeight;
                }
                this.field_961 = var7;
            }
            int posX = this.field_962 << 4 | x;
            int posZ = this.field_963 << 4 | z;
            if (maxHeight < height) {
                for (h = maxHeight; h < height; ++h) {
                    section = this.getSection(h);
                    if (section == null) continue;
                    section.setLight(class_56.field_2757, x, h & 0xF, z, 15);
                }
            } else {
                this.field_956.method_166(class_56.field_2757, posX, (int)height, posZ, posX, maxHeight, posZ);
                for (h = (int)height; h < maxHeight; ++h) {
                    section = this.getSection(h);
                    if (section == null) continue;
                    section.setLight(class_56.field_2757, x, h & 0xF, z, 0);
                }
            }
            int light = 15;
            h = maxHeight;
            while (maxHeight > this.firstBlock && light > 0) {
                ChunkSection section;
                int var11 = class_17.field_1941[this.method_859(x, maxHeight = (int)((short)(maxHeight - 1)), z)];
                if (var11 == 0) {
                    var11 = 1;
                }
                if ((light -= var11) < 0) {
                    light = 0;
                }
                if ((section = this.getSection(maxHeight)) == null) continue;
                section.setLight(class_56.field_2757, x, maxHeight & 0xF, z, light);
            }
            while (maxHeight > this.firstBlock && class_17.field_1941[this.method_859(x, maxHeight - 1, z)] == 0) {
                maxHeight = (short)(maxHeight - 1);
            }
            if (maxHeight != h) {
                this.field_956.method_166(class_56.field_2757, posX - 1, maxHeight, posZ - 1, posX + 1, h, posZ + 1);
            }
            this.field_967 = true;
        }
    }

    public int method_859(int x, int y, int z) {
        return this.getBlockState((int)x, (int)y, (int)z).getBlock().field_1915;
    }

    public boolean method_861(int x, int y, int z, int blockId, int meta) {
        return this.setBlockStateWithMetadata(x, y, z, class_17.field_1937[blockId].getDefaultState(), meta) != null;
    }

    public boolean method_860(int x, int y, int z, int blockId) {
        return this.setBlockState(x, y, z, class_17.field_1937[blockId].getDefaultState()) != null;
    }

    public int method_875(int x, int y, int z) {
        ChunkSection section = this.getSection(y);
        return section == null ? 0 : section.getMeta(x, y & 0xF, z);
    }

    public void method_876(int x, int y, int z, int meta) {
        WorldEvent event = ((MetaSetEvent.MetaSetEventBuilder)((Object)((MetaSetEvent.MetaSetEventBuilder)((Object)((MetaSetEvent.MetaSetEventBuilder)((Object)((MetaSetEvent.MetaSetEventBuilder)((Object)((MetaSetEvent.MetaSetEventBuilder)((Object)((MetaSetEvent.MetaSetEventBuilder)((Object)((MetaSetEvent.MetaSetEventBuilder)MetaSetEvent.builder().world(this.field_956)).chunk(this))).x(this.field_962 << 4 | x))).y(y))).z(this.field_963 << 4 | z))).blockMeta(meta))).overrideMeta(meta))).build();
        if (event.isCanceled()) {
            return;
        }
        meta = event.overrideMeta;
        ChunkSection section = this.getSection(y);
        if (section != null) {
            section.setMeta(x, y & 0xF, z, meta);
        }
    }

    public BlockState getBlockState(int x, int y, int z) {
        ChunkSection section = this.getSection(y);
        if (section == null) {
            return States.AIR.get();
        }
        BlockState blockState = section.getBlockState(x, y & 0xF, z);
        if (blockState == null) {
            throw new RuntimeException();
        }
        return blockState;
    }

    public BlockState setBlockStateWithMetadata(int x, int y, int z, BlockState state, int meta) {
        int worldX = this.field_962 << 4 | x;
        int worldZ = this.field_963 << 4 | z;
        WorldEvent event = ((BlockSetEvent.BlockSetEventBuilder)((Object)((BlockSetEvent.BlockSetEventBuilder)((Object)((BlockSetEvent.BlockSetEventBuilder)((Object)((BlockSetEvent.BlockSetEventBuilder)((Object)((BlockSetEvent.BlockSetEventBuilder)((Object)((BlockSetEvent.BlockSetEventBuilder)((Object)((BlockSetEvent.BlockSetEventBuilder)((Object)((BlockSetEvent.BlockSetEventBuilder)((Object)((BlockSetEvent.BlockSetEventBuilder)BlockSetEvent.builder().world(this.field_956)).chunk(this))).x(worldX))).y(y))).z(worldZ))).blockState(state))).blockMeta(meta))).overrideState(state))).overrideMeta(meta))).build();
        if (((BlockSetEvent)StationAPI.EVENT_BUS.post((Event)event)).isCanceled()) {
            return null;
        }
        state = event.overrideState;
        meta = event.overrideMeta;
        ChunkSection section = this.getOrCreateSection(y, true);
        if (section == null) {
            return null;
        }
        boolean sameMeta = section.getMeta(x, y & 0xF, z) == meta;
        short var6 = this.getShortHeight(x, z);
        BlockState oldState = section.getBlockState(x, y & 0xF, z);
        if (oldState == state && sameMeta) {
            return null;
        }
        class_17 oldBlock = oldState.getBlock();
        if (((BlockEvent.BeforeRemoved)StationAPI.EVENT_BUS.post((Event)((BlockEvent.BeforeRemoved.BeforeRemovedBuilder)((Object)((BlockEvent.BeforeRemoved.BeforeRemovedBuilder)((Object)((BlockEvent.BeforeRemoved.BeforeRemovedBuilder)((Object)((BlockEvent.BeforeRemoved.BeforeRemovedBuilder)((Object)((BlockEvent.BeforeRemoved.BeforeRemovedBuilder)((Object)BlockEvent.BeforeRemoved.builder().block(oldBlock))).world(this.field_956))).x(worldX))).y(y))).z(worldZ))).build())).isCanceled()) {
            return null;
        }
        section.setBlockState(x, y & 0xF, z, state);
        if (!this.field_956.field_180) {
            oldBlock.method_1630(this.field_956, worldX, y, worldZ);
        }
        section.setMeta(x, y & 0xF, z, meta);
        if (!this.field_956.field_216.field_2177) {
            if (class_17.field_1941[state.getBlock().field_1915] != 0) {
                if (y >= var6) {
                    this.method_889(x, y + 1, z);
                }
            } else if (y == var6 - 1) {
                this.method_889(x, y, z);
            }
            this.field_956.method_166(class_56.field_2757, worldX, y, worldZ, worldX, y, worldZ);
        }
        this.field_956.method_166(class_56.field_2758, worldX, y, worldZ, worldX, y, worldZ);
        ((ChunkAccessor)((Object)this)).invokeMethod_887(x, z);
        section.setMeta(x, y & 0xF, z, meta);
        state.getBlock().onBlockPlaced(this.field_956, worldX, y, worldZ, oldState);
        this.field_967 = true;
        return oldState;
    }

    public BlockState setBlockState(int x, int y, int z, BlockState state) {
        int worldX = this.field_962 << 4 | x;
        int worldZ = this.field_963 << 4 | z;
        if (((BlockSetEvent)StationAPI.EVENT_BUS.post((Event)((BlockSetEvent.BlockSetEventBuilder)((Object)((BlockSetEvent.BlockSetEventBuilder)((Object)((BlockSetEvent.BlockSetEventBuilder)((Object)((BlockSetEvent.BlockSetEventBuilder)((Object)((BlockSetEvent.BlockSetEventBuilder)((Object)((BlockSetEvent.BlockSetEventBuilder)BlockSetEvent.builder().world(this.field_956)).chunk(this))).x(worldX))).y(y))).z(worldZ))).blockState(state))).build())).isCanceled()) {
            return null;
        }
        ChunkSection section = this.getOrCreateSection(y, true);
        if (section == null) {
            return null;
        }
        BlockState oldState = section.getBlockState(x, y & 0xF, z);
        if (oldState == state) {
            return null;
        }
        short topY = this.getShortHeight(x, z);
        class_17 oldBlock = oldState.getBlock();
        if (((BlockEvent.BeforeRemoved)StationAPI.EVENT_BUS.post((Event)((BlockEvent.BeforeRemoved.BeforeRemovedBuilder)((Object)((BlockEvent.BeforeRemoved.BeforeRemovedBuilder)((Object)((BlockEvent.BeforeRemoved.BeforeRemovedBuilder)((Object)((BlockEvent.BeforeRemoved.BeforeRemovedBuilder)((Object)((BlockEvent.BeforeRemoved.BeforeRemovedBuilder)((Object)BlockEvent.BeforeRemoved.builder().block(oldBlock))).world(this.field_956))).x(worldX))).y(y))).z(worldZ))).build())).isCanceled()) {
            return null;
        }
        section.setBlockState(x, y & 0xF, z, state);
        oldBlock.method_1630(this.field_956, worldX, y, worldZ);
        section.setMeta(x, y & 0xF, z, 0);
        if (class_17.field_1941[state.getBlock().field_1915] != 0) {
            if (y >= topY) {
                this.method_889(x, y + 1, z);
            }
        } else if (y == topY - 1) {
            this.method_889(x, y, z);
        }
        this.field_956.method_166(class_56.field_2757, worldX, y, worldZ, worldX, y, worldZ);
        this.field_956.method_166(class_56.field_2758, worldX, y, worldZ, worldX, y, worldZ);
        ((ChunkAccessor)((Object)this)).invokeMethod_887(x, z);
        if (!this.field_956.field_180) {
            state.getBlock().onBlockPlaced(this.field_956, worldX, y, worldZ, oldState);
        }
        this.field_967 = true;
        return oldState;
    }

    public void method_868(class_57 entity) {
        int n;
        this.field_969 = true;
        int n2 = class_189.method_645((double)(entity.field_1600 / 16.0));
        int n3 = class_189.method_645((double)(entity.field_1602 / 16.0));
        if (n2 != this.field_962 || n3 != this.field_963) {
            System.out.println("Wrong location! " + String.valueOf(entity));
            Thread.dumpStack();
        }
        if ((n = class_189.method_645((double)((entity.field_1601 - (double)this.field_956.getBottomY()) / 16.0))) < 0) {
            n = 0;
        }
        if (n >= this.field_965.length) {
            n = this.field_965.length - 1;
        }
        entity.field_1618 = true;
        entity.field_1619 = this.field_962;
        entity.field_1620 = n;
        entity.field_1621 = this.field_963;
        this.field_965[n].add(entity);
    }

    public void method_870(class_57 entity, class_25 box, List entities) {
        int n = class_189.method_645((double)((box.field_130 - (double)this.field_956.getBottomY() - 2.0) / 16.0));
        int n2 = class_189.method_645((double)((box.field_133 - (double)this.field_956.getBottomY() + 2.0) / 16.0));
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.field_965.length) {
            n2 = this.field_965.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            List list2 = this.field_965[i];
            for (int j = 0; j < list2.size(); ++j) {
                class_57 entityBase = (class_57)list2.get(j);
                if (entityBase == entity || !entityBase.field_1610.method_90(box)) continue;
                entities.add(entityBase);
            }
        }
    }

    public void method_866(Class class_, class_25 arg, List list) {
        int n = class_189.method_645((double)((arg.field_130 - (double)this.field_956.getBottomY() - 2.0) / 16.0));
        int n2 = class_189.method_645((double)((arg.field_133 - (double)this.field_956.getBottomY() + 2.0) / 16.0));
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.field_965.length) {
            n2 = this.field_965.length - 1;
        }
        for (int i = n; i <= n2; ++i) {
            List list2 = this.field_965[i];
            for (int j = 0; j < list2.size(); ++j) {
                class_57 entityBase = (class_57)list2.get(j);
                if (!class_.isAssignableFrom(entityBase.getClass()) || !entityBase.field_1610.method_90(arg)) continue;
                list.add(entityBase);
            }
        }
    }

    public void method_890() {
    }

    public void method_862(int relX, int relY, int relZ, class_55 arg) {
        class_339 tilePos = new class_339(relX, relY, relZ);
        arg.field_1238 = this.field_956;
        arg.field_1239 = this.field_962 * 16 + relX;
        arg.field_1240 = relY;
        arg.field_1241 = this.field_963 * 16 + relZ;
        if (this.method_859(relX, relY, relZ) == 0 || !class_17.field_1940[this.method_859(relX, relY, relZ)]) {
            System.out.println("Attempted to place a tile entity where there was no entity tile!");
            return;
        }
        arg.method_1073();
        this.field_964.put(tilePos, arg);
    }
}

