/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.world.chunk;

import com.mojang.datafixers.DSL;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import net.minecraft.class_18;
import net.minecraft.class_187;
import net.minecraft.class_243;
import net.minecraft.class_379;
import net.minecraft.class_43;
import net.minecraft.class_7;
import net.minecraft.class_8;
import net.minecraft.class_83;
import net.modificationstation.stationapi.api.datafixer.TypeReferences;
import net.modificationstation.stationapi.api.nbt.NbtHelper;
import net.modificationstation.stationapi.impl.world.FlattenedWorldManager;
import net.modificationstation.stationapi.impl.world.chunk.FlattenedChunk;

public class FlattenedWorldChunkLoader
implements class_243 {
    protected final File dimFolder;

    public FlattenedWorldChunkLoader(File dimFolder) {
        this.dimFolder = dimFolder;
    }

    public class_43 method_811(class_18 arg, int i, int j) {
        DataInputStream dataInputStream = class_379.method_1215((File)this.dimFolder, (int)i, (int)j);
        if (dataInputStream == null) {
            return null;
        }
        class_8 compoundTag = class_83.method_337((DataInput)dataInputStream);
        if (!compoundTag.method_1023("Level")) {
            System.out.println("Chunk file at " + i + "," + j + " is missing level data, skipping");
            return null;
        }
        if (!(compoundTag = NbtHelper.update((DSL.TypeReference)TypeReferences.CHUNK, (class_8)compoundTag)).method_1033("Level").method_1023(FlattenedWorldManager.SECTIONS)) {
            System.out.println("Chunk file at " + i + "," + j + " is missing section data, skipping");
            return null;
        }
        class_43 chunk = FlattenedWorldManager.loadChunk(arg, compoundTag.method_1033("Level"));
        if (!chunk.method_858(i, j)) {
            System.out.println("Chunk file at " + i + "," + j + " is in the wrong location; relocating. (Expected " + i + ", " + j + ", got " + chunk.field_962 + ", " + chunk.field_963 + ")");
            compoundTag.method_1015("xPos", i);
            compoundTag.method_1015("zPos", j);
            chunk = FlattenedWorldManager.loadChunk(arg, compoundTag.method_1033("Level"));
        }
        chunk.method_890();
        return chunk;
    }

    public void method_812(class_18 world, class_43 oldChunk) {
        if (!(oldChunk instanceof FlattenedChunk)) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " can't save chunk of type \"" + oldChunk.getClass().getName() + "\"!");
        }
        FlattenedChunk chunk = (FlattenedChunk)oldChunk;
        world.method_251();
        DataOutputStream dataOutputStream = class_379.method_1216((File)this.dimFolder, (int)chunk.field_962, (int)chunk.field_963);
        class_8 compoundTag = new class_8();
        class_8 compoundTag2 = new class_8();
        compoundTag.method_1017("Level", (class_187)compoundTag2);
        FlattenedWorldManager.saveChunk(chunk, world, compoundTag2);
        compoundTag = NbtHelper.addDataVersions((class_8)compoundTag);
        class_83.method_335((class_8)compoundTag, (DataOutput)dataOutputStream);
        try {
            dataOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        class_7 worldProperties = world.method_262();
        worldProperties.method_13(worldProperties.method_20() + (long)class_379.method_1214((File)this.dimFolder, (int)chunk.field_962, (int)chunk.field_963));
    }

    public void method_814(class_18 arg, class_43 arg2) {
    }

    public void method_810() {
    }

    public void method_813() {
    }
}

