/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.world.chunk;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Predicate;
import net.modificationstation.stationapi.api.util.collection.IndexedIterable;
import net.modificationstation.stationapi.impl.world.chunk.EntryMissingException;
import net.modificationstation.stationapi.impl.world.chunk.Palette;
import net.modificationstation.stationapi.impl.world.chunk.PaletteResizeListener;

public class IdListPalette<T>
implements Palette<T> {
    private final IndexedIterable<T> idList;

    public IdListPalette(IndexedIterable<T> idList) {
        this.idList = idList;
    }

    public static <A> Palette<A> create(int bits, IndexedIterable<A> idList, PaletteResizeListener<A> listener, List<A> list) {
        return new IdListPalette<A>(idList);
    }

    @Override
    public int index(T object) {
        int i = this.idList.getRawId(object);
        return i == -1 ? 0 : i;
    }

    @Override
    public boolean hasAny(Predicate<T> predicate) {
        return true;
    }

    @Override
    public T get(int id) {
        Object object = this.idList.get(id);
        if (object == null) {
            throw new EntryMissingException(id);
        }
        return (T)object;
    }

    @Override
    public void readPacket(ByteBuffer buf) {
    }

    @Override
    public void writePacket(ByteBuffer buf) {
    }

    @Override
    public int getPacketSize() {
        return 0;
    }

    @Override
    public int getSize() {
        return this.idList.size();
    }

    @Override
    public Palette<T> copy() {
        return this;
    }
}

