/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.world.chunk;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.modificationstation.stationapi.api.util.collection.IndexedIterable;
import net.modificationstation.stationapi.impl.world.chunk.Palette;
import net.modificationstation.stationapi.impl.world.chunk.PaletteResizeListener;

public class LithiumHashPalette<T>
implements Palette<T> {
    private static final int ABSENT_VALUE = -1;
    private final IndexedIterable<T> idList;
    private final PaletteResizeListener<T> resizeHandler;
    private final int indexBits;
    private final Reference2IntMap<T> table;
    private T[] entries;
    private int size = 0;

    public LithiumHashPalette(IndexedIterable<T> idList, PaletteResizeListener<T> resizeHandler, int indexBits, T[] entries, Reference2IntMap<T> table, int size) {
        this.idList = idList;
        this.resizeHandler = resizeHandler;
        this.indexBits = indexBits;
        this.entries = entries;
        this.table = table;
        this.size = size;
    }

    public LithiumHashPalette(IndexedIterable<T> idList, int bits, PaletteResizeListener<T> resizeHandler, List<T> list) {
        this(idList, bits, resizeHandler);
        for (T t : list) {
            this.addEntry(t);
        }
    }

    public LithiumHashPalette(IndexedIterable<T> idList, int bits, PaletteResizeListener<T> resizeHandler) {
        this.idList = idList;
        this.indexBits = bits;
        this.resizeHandler = resizeHandler;
        int capacity = 1 << bits;
        this.entries = new Object[capacity];
        this.table = new Reference2IntOpenHashMap(capacity, 0.5f);
        this.table.defaultReturnValue(-1);
    }

    @Override
    public int index(T obj) {
        int id = this.table.getInt(obj);
        if (id == -1) {
            id = this.computeEntry(obj);
        }
        return id;
    }

    @Override
    public boolean hasAny(Predicate<T> predicate) {
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.test(this.entries[i])) continue;
            return true;
        }
        return false;
    }

    private int computeEntry(T obj) {
        int id = this.addEntry(obj);
        if (id >= 1 << this.indexBits) {
            if (this.resizeHandler == null) {
                throw new IllegalStateException("Cannot grow");
            }
            id = this.resizeHandler.onResize(this.indexBits + 1, obj);
        }
        return id;
    }

    private int addEntry(T obj) {
        int nextId = this.size;
        if (nextId >= this.entries.length) {
            this.resize(this.size);
        }
        this.table.put(obj, nextId);
        this.entries[nextId] = obj;
        ++this.size;
        return nextId;
    }

    private void resize(int neededCapacity) {
        this.entries = Arrays.copyOf(this.entries, HashCommon.nextPowerOfTwo((int)(neededCapacity + 1)));
    }

    @Override
    public T get(int id) {
        T[] entries = this.entries;
        if (id >= 0 && id < entries.length) {
            return entries[id];
        }
        return null;
    }

    @Override
    public void readPacket(ByteBuffer buf) {
        this.clear();
        int entryCount = buf.getInt();
        for (int i = 0; i < entryCount; ++i) {
            this.addEntry(this.idList.get(buf.getInt()));
        }
    }

    @Override
    public void writePacket(ByteBuffer buf) {
        int size = this.size;
        buf.putInt(size);
        for (int i = 0; i < size; ++i) {
            buf.putInt(this.idList.getRawId(this.get(i)));
        }
    }

    @Override
    public int getPacketSize() {
        return 4 + this.size * 4;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public Palette<T> copy() {
        return new LithiumHashPalette<Object>((IndexedIterable<Object>)this.idList, (PaletteResizeListener<Object>)this.resizeHandler, this.indexBits, (T[])((Object[])this.entries.clone()), (Reference2IntMap<Object>)new Reference2IntOpenHashMap(this.table), this.size);
    }

    private void clear() {
        Arrays.fill(this.entries, null);
        this.table.clear();
        this.size = 0;
    }

    public List<T> getElements() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (T entry : this.entries) {
            if (entry == null) continue;
            builder.add(entry);
        }
        return builder.build();
    }

    public static <A> Palette<A> create(int bits, IndexedIterable<A> idList, PaletteResizeListener<A> listener, List<A> list) {
        return new LithiumHashPalette<A>(idList, bits, listener, list);
    }
}

