/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.world.chunk;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import net.modificationstation.stationapi.api.util.Util;
import net.modificationstation.stationapi.api.util.collection.EmptyPaletteStorage;
import net.modificationstation.stationapi.api.util.collection.IndexedIterable;
import net.modificationstation.stationapi.api.util.collection.PackedIntegerArray;
import net.modificationstation.stationapi.api.util.collection.PaletteStorage;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import net.modificationstation.stationapi.api.world.chunk.CompactingPackedIntegerArray;
import net.modificationstation.stationapi.impl.util.dynamic.Codecs;
import net.modificationstation.stationapi.impl.world.chunk.ArrayPalette;
import net.modificationstation.stationapi.impl.world.chunk.BiMapPalette;
import net.modificationstation.stationapi.impl.world.chunk.IdListPalette;
import net.modificationstation.stationapi.impl.world.chunk.LithiumHashPalette;
import net.modificationstation.stationapi.impl.world.chunk.Palette;
import net.modificationstation.stationapi.impl.world.chunk.PaletteResizeListener;
import net.modificationstation.stationapi.impl.world.chunk.SingularPalette;
import org.jetbrains.annotations.Nullable;

public class PalettedContainer<T>
implements PaletteResizeListener<T> {
    private static final ThreadLocal<short[]> CACHED_ARRAY_4096 = ThreadLocal.withInitial(() -> new short[4096]);
    private static final ThreadLocal<short[]> CACHED_ARRAY_64 = ThreadLocal.withInitial(() -> new short[64]);
    private final PaletteResizeListener<T> dummyListener = (newSize, added) -> 0;
    private final IndexedIterable<T> idList;
    private volatile Data<T> data;
    private final PaletteProvider paletteProvider;

    public static <T> Codec<PalettedContainer<T>> createCodec(IndexedIterable<T> idList, Codec<T> entryCodec, PaletteProvider provider, T object) {
        return RecordCodecBuilder.create(instance -> instance.group((App)entryCodec.mapResult(Codecs.orElsePartial(object)).listOf().fieldOf("palette").forGetter(Serialized::paletteEntries), (App)Codec.LONG_STREAM.optionalFieldOf("data").forGetter(Serialized::storage)).apply((Applicative)instance, Serialized::new)).comapFlatMap(serialized -> PalettedContainer.read(idList, provider, serialized), container -> container.write(idList, provider));
    }

    public PalettedContainer(IndexedIterable<T> idList, PaletteProvider paletteProvider, DataProvider<T> dataProvider, PaletteStorage storage, List<T> paletteEntries) {
        this.idList = idList;
        this.paletteProvider = paletteProvider;
        this.data = new Data<T>(dataProvider, storage, dataProvider.factory().create(dataProvider.bits(), idList, this, paletteEntries));
    }

    private PalettedContainer(IndexedIterable<T> idList, PaletteProvider paletteProvider, Data<T> data) {
        this.idList = idList;
        this.paletteProvider = paletteProvider;
        this.data = data;
    }

    public PalettedContainer(IndexedIterable<T> idList, T object, PaletteProvider paletteProvider) {
        this.paletteProvider = paletteProvider;
        this.idList = idList;
        this.data = this.getCompatibleData(null, 0);
        this.data.palette.index(object);
    }

    private Data<T> getCompatibleData(@Nullable Data<T> previousData, int bits) {
        DataProvider<T> dataProvider = this.paletteProvider.createDataProvider(this.idList, bits);
        if (previousData != null && dataProvider.equals(previousData.configuration())) {
            return previousData;
        }
        return dataProvider.createData(this.idList, this, this.paletteProvider.getContainerSize());
    }

    @Override
    public int onResize(int i, T object) {
        Data<T> data = this.data;
        Data data2 = this.getCompatibleData(data, i);
        data2.importFrom(data.palette, data.storage);
        this.data = data2;
        return data2.palette.index(object);
    }

    public T swap(int x, int y, int z, T value) {
        return this.swap(this.paletteProvider.computeIndex(x, y, z), value);
    }

    private T swap(int index, T value) {
        int i = this.data.palette.index(value);
        int j = this.data.storage.swap(index, i);
        return this.data.palette.get(j);
    }

    public void set(int x, int y, int z, T value) {
        this.set(this.paletteProvider.computeIndex(x, y, z), value);
    }

    private void set(int index, T value) {
        int i = this.data.palette.index(value);
        this.data.storage.set(index, i);
    }

    public T get(int x, int y, int z) {
        return this.get(this.paletteProvider.computeIndex(x, y, z));
    }

    protected T get(int index) {
        Data<T> data = this.data;
        return data.palette.get(data.storage.get(index));
    }

    public void method_39793(Consumer<T> consumer) {
        Palette palette = this.data.palette();
        IntArraySet intSet = new IntArraySet();
        this.data.storage.forEach(arg_0 -> ((IntArraySet)intSet).add(arg_0));
        intSet.forEach(id -> consumer.accept(palette.get(id)));
    }

    public void readPacket(ByteBuffer buf) {
        byte i = buf.get();
        Data<T> data = this.getCompatibleData(this.data, i);
        data.palette.readPacket(buf);
        buf.position(buf.position() + buf.slice().asLongBuffer().get(data.storage.getData()).position() * 8);
        this.data = data;
    }

    public void writePacket(ByteBuffer buf) {
        this.data.writePacket(buf);
    }

    private static <T> DataResult<PalettedContainer<T>> read(IndexedIterable<T> idList, PaletteProvider provider, Serialized<T> serialized) {
        PaletteStorage paletteStorage;
        List<T> list = serialized.paletteEntries();
        int i2 = provider.getContainerSize();
        int j = provider.getBits(idList, list.size());
        DataProvider<T> dataProvider = provider.createDataProvider(idList, j);
        if (j == 0) {
            paletteStorage = new EmptyPaletteStorage(i2);
        } else {
            Optional<LongStream> optional = serialized.storage();
            if (optional.isEmpty()) {
                return DataResult.error(() -> "Missing values for non-zero storage");
            }
            long[] ls = optional.get().toArray();
            try {
                if (dataProvider.factory() == PaletteProvider.ID_LIST) {
                    BiMapPalette<Object> palette = new BiMapPalette<Object>(idList, j, (i, object) -> 0, list);
                    PackedIntegerArray packedIntegerArray = new PackedIntegerArray(j, i2, ls);
                    int[] is = new int[i2];
                    packedIntegerArray.method_39892(is);
                    PalettedContainer.method_39894(is, i -> idList.getRawId(palette.get(i)));
                    paletteStorage = new PackedIntegerArray(dataProvider.bits(), i2, is);
                } else {
                    paletteStorage = new PackedIntegerArray(dataProvider.bits(), i2, ls);
                }
            }
            catch (PackedIntegerArray.InvalidLengthException palette) {
                return DataResult.error(() -> "Failed to read PalettedContainer: " + palette.getMessage());
            }
        }
        return DataResult.success(new PalettedContainer<T>(idList, provider, dataProvider, paletteStorage, list));
    }

    private Serialized<T> write(IndexedIterable<T> idList, PaletteProvider provider) {
        LithiumHashPalette hashPalette = null;
        Optional<LongStream> data = Optional.empty();
        List<T> elements = null;
        Palette<T> palette = this.data.palette();
        PaletteStorage storage = this.data.storage();
        if (storage instanceof EmptyPaletteStorage || palette.getSize() == 1) {
            elements = List.of(palette.get(0));
        } else if (palette instanceof LithiumHashPalette) {
            LithiumHashPalette lithiumHashPalette;
            hashPalette = lithiumHashPalette = (LithiumHashPalette)palette;
        }
        if (elements == null) {
            LithiumHashPalette<T> compactedPalette = new LithiumHashPalette<T>(idList, storage.getElementBits(), this.dummyListener);
            int size = provider.getContainerSize();
            short[] array = switch (size) {
                case 64 -> CACHED_ARRAY_64.get();
                case 4096 -> CACHED_ARRAY_4096.get();
                default -> new short[size];
            };
            ((CompactingPackedIntegerArray)((Object)storage)).compact(this.data.palette(), compactedPalette, array);
            if (hashPalette != null && hashPalette.getSize() == compactedPalette.getSize() && storage.getElementBits() == provider.getBits(idList, hashPalette.getSize())) {
                data = Optional.of(Arrays.stream((long[])storage.getData().clone()));
                elements = hashPalette.getElements();
            } else {
                int bits = provider.getBits(idList, compactedPalette.getSize());
                if (bits != 0) {
                    PackedIntegerArray copy = new PackedIntegerArray(bits, array.length);
                    for (int i = 0; i < array.length; ++i) {
                        copy.set(i, array[i]);
                    }
                    data = Optional.of(Arrays.stream(copy.getData()));
                }
                elements = compactedPalette.getElements();
            }
        }
        return new Serialized<T>(elements, data);
    }

    private static void method_39894(int[] is, IntUnaryOperator intUnaryOperator) {
        int i = -1;
        int j = -1;
        for (int k = 0; k < is.length; ++k) {
            int l = is[k];
            if (l != i) {
                i = l;
                j = intUnaryOperator.applyAsInt(l);
            }
            is[k] = j;
        }
    }

    public int getPacketSize() {
        return this.data.getPacketSize();
    }

    public boolean hasAny(Predicate<T> predicate) {
        return this.data.palette.hasAny(predicate);
    }

    public PalettedContainer<T> copy() {
        return new PalettedContainer<T>(this.idList, this.paletteProvider, new Data<T>(this.data.configuration(), this.data.storage().copy(), this.data.palette().copy()));
    }

    public void count(Counter<T> counter) {
        int len = this.data.palette().getSize();
        if (len <= 4096) {
            short[] counts = new short[len];
            this.data.storage().forEach(i -> {
                int n = i;
                counts[n] = (short)(counts[n] + 1);
            });
            for (int i2 = 0; i2 < counts.length; ++i2) {
                T obj = this.data.palette().get(i2);
                if (obj == null) continue;
                counter.accept(obj, counts[i2]);
            }
        } else {
            Int2IntOpenHashMap int2IntOpenHashMap = new Int2IntOpenHashMap();
            this.data.storage.forEach(key -> int2IntOpenHashMap.addTo(key, 1));
            int2IntOpenHashMap.int2IntEntrySet().forEach(entry -> counter.accept(this.data.palette.get(entry.getIntKey()), entry.getIntValue()));
        }
    }

    public static abstract class PaletteProvider {
        public static final Palette.Factory SINGULAR = SingularPalette::create;
        public static final Palette.Factory ARRAY = ArrayPalette::create;
        public static final Palette.Factory BI_MAP = BiMapPalette::create;
        static final Palette.Factory ID_LIST = IdListPalette::create;
        private static final Palette.Factory HASH = LithiumHashPalette::create;
        private static final DataProvider<?>[] BLOCKSTATE_DATA_PROVIDERS = (DataProvider[])Util.make(() -> {
            DataProvider arrayDataProvider4bit = new DataProvider(ARRAY, 4);
            DataProvider hashDataProvider4bit = new DataProvider(HASH, 4);
            return new DataProvider[]{new DataProvider(SINGULAR, 0), arrayDataProvider4bit, arrayDataProvider4bit, hashDataProvider4bit, hashDataProvider4bit, new DataProvider(HASH, 5), new DataProvider(HASH, 6), new DataProvider(HASH, 7), new DataProvider(HASH, 8)};
        });
        public static final PaletteProvider BLOCK_STATE = new PaletteProvider(4){

            @Override
            public <A> DataProvider<A> createDataProvider(IndexedIterable<A> idList, int bits) {
                if (bits >= 0 && bits < BLOCKSTATE_DATA_PROVIDERS.length) {
                    return BLOCKSTATE_DATA_PROVIDERS[bits];
                }
                return new DataProvider(ID_LIST, MathHelper.ceilLog2((int)idList.size()));
            }
        };
        private final int edgeBits;

        PaletteProvider(int edgeBits) {
            this.edgeBits = edgeBits;
        }

        public int getContainerSize() {
            return 1 << this.edgeBits * 3;
        }

        public int computeIndex(int x, int y, int z) {
            return (y << this.edgeBits | z) << this.edgeBits | x;
        }

        public abstract <A> DataProvider<A> createDataProvider(IndexedIterable<A> var1, int var2);

        <A> int getBits(IndexedIterable<A> idList, int size) {
            int i = MathHelper.ceilLog2((int)size);
            DataProvider<A> dataProvider = this.createDataProvider(idList, i);
            return dataProvider.factory() == ID_LIST ? i : dataProvider.bits();
        }
    }

    public record Data<T>(DataProvider<T> configuration, PaletteStorage storage, Palette<T> palette) {
        public void importFrom(Palette<T> palette, PaletteStorage storage) {
            for (int i = 0; i < storage.getSize(); ++i) {
                T object = palette.get(storage.get(i));
                this.storage.set(i, this.palette.index(object));
            }
        }

        public int getPacketSize() {
            return 1 + this.palette.getPacketSize() + 4 + this.storage.getData().length * 8;
        }

        public void writePacket(ByteBuffer buf) {
            buf.put((byte)this.storage.getElementBits());
            this.palette.writePacket(buf);
            buf.position(buf.position() + buf.slice().asLongBuffer().put(this.storage.getData()).position() * 8);
        }
    }

    public record DataProvider<T>(Palette.Factory factory, int bits) {
        public Data<T> createData(IndexedIterable<T> idList, PaletteResizeListener<T> listener, int size) {
            PaletteStorage paletteStorage = this.bits == 0 ? new EmptyPaletteStorage(size) : new PackedIntegerArray(this.bits, size);
            Palette<T> palette = this.factory.create(this.bits, idList, listener, List.of());
            return new Data<T>(this, paletteStorage, palette);
        }
    }

    record Serialized<T>(List<T> paletteEntries, Optional<LongStream> storage) {
    }

    @FunctionalInterface
    public static interface Counter<T> {
        public void accept(T var1, int var2);
    }
}

