/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.world.storage;

import com.mojang.datafixers.DSL;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_157;
import net.minecraft.class_189;
import net.minecraft.class_353;
import net.minecraft.class_379;
import net.minecraft.class_52;
import net.minecraft.class_591;
import net.minecraft.class_62;
import net.minecraft.class_7;
import net.minecraft.class_8;
import net.minecraft.class_83;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.datafixer.TypeReferences;
import net.modificationstation.stationapi.api.nbt.NbtHelper;
import net.modificationstation.stationapi.api.util.Util;
import net.modificationstation.stationapi.impl.world.dimension.FlattenedDimensionFile;
import net.modificationstation.stationapi.mixin.flattening.RegionFileAccessor;

public class FlattenedWorldStorage
extends class_157 {
    public FlattenedWorldStorage(File file) {
        super(file);
    }

    @Environment(value=EnvType.CLIENT)
    public String method_1001() {
        return "Modded " + super.method_1001();
    }

    @Environment(value=EnvType.CLIENT)
    public String getPreviousWorldFormat() {
        return super.method_1001();
    }

    @Environment(value=EnvType.CLIENT)
    public List<class_591> method_1002() {
        ArrayList<class_591> worlds = new ArrayList<class_591>();
        for (File worldPath : Objects.requireNonNull(this.field_1706.listFiles())) {
            String worldFolder;
            class_7 data;
            if (!worldPath.isDirectory() || (data = this.method_1004(worldFolder = worldPath.getName())) == null) continue;
            class_8 worldTag = this.getWorldTag(worldFolder);
            boolean requiresUpdating = data.method_22() != 19132 || NbtHelper.requiresUpdating((class_8)worldTag);
            String worldName = data.method_32();
            if (worldName == null || class_189.method_651((String)worldName)) {
                worldName = worldFolder;
            }
            worlds.add(new class_591(worldFolder, worldName, data.method_33(), data.method_20(), requiresUpdating));
        }
        return worlds;
    }

    public class_8 getWorldTag(String worldFolder) {
        File worldPath = new File(this.field_1706, worldFolder);
        if (!worldPath.exists()) {
            return null;
        }
        File worldData = new File(worldPath, "level.dat");
        if (worldData.exists()) {
            try {
                return class_83.method_338((InputStream)new FileInputStream(worldData)).method_1033("Data");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((worldData = new File(worldPath, "level.dat_old")).exists()) {
            try {
                return class_83.method_338((InputStream)new FileInputStream(worldData)).method_1033("Data");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public class_52 method_1009(String string, boolean bl) {
        return new FlattenedDimensionFile(this.field_1706, string, bl);
    }

    public boolean method_1007(String string) {
        if (super.method_1007(string)) {
            return true;
        }
        class_8 worldTag = this.getWorldTag(string);
        return worldTag != null && NbtHelper.requiresUpdating((class_8)worldTag);
    }

    public boolean method_1008(String worldFolder, class_62 progress) {
        return this.convertWorld(worldFolder, (type, compound) -> NbtHelper.addDataVersions((class_8)NbtHelper.update((DSL.TypeReference)type, (class_8)compound)), progress);
    }

    public boolean convertWorld(String worldFolder, BiFunction<DSL.TypeReference, class_8, class_8> convertFunction, class_62 progress) {
        class_379.method_1212();
        StationAPI.LOGGER.info("Creating a backup of world \"" + worldFolder + "\"...");
        File worldFile = new File(this.field_1706, worldFolder);
        try {
            Util.pack((Path)worldFile.toPath(), (Path)new File(this.field_1706, worldFolder + "-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".zip").toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (super.method_1007(worldFolder)) {
            StationAPI.LOGGER.info("Converting to \"" + super.method_1001() + "\" first...");
            super.method_1008(worldFolder, progress);
        }
        progress.method_1794(0);
        ArrayList<class_353> regions = new ArrayList<class_353>();
        StationAPI.LOGGER.info("Scanning folders...");
        this.scanDimensionDir(worldFile, regions);
        File[] dims = worldFile.listFiles((dir, name) -> new File(dir, name).isDirectory() && name.startsWith("DIM"));
        if (dims != null) {
            for (File dim : dims) {
                this.scanDimensionDir(dim, regions);
            }
        }
        this.convertChunks(regions, convertFunction, progress);
        class_8 newWorldTag = new class_8();
        class_8 newWorldDataTag = convertFunction.apply(TypeReferences.LEVEL, this.getWorldTag(worldFolder));
        StationAPI.LOGGER.info("Converting player inventory...");
        newWorldDataTag.method_1018("Player", convertFunction.apply(TypeReferences.PLAYER, newWorldDataTag.method_1033("Player")));
        newWorldTag.method_1018("Data", newWorldDataTag);
        try {
            File file = new File(worldFile, "level.dat_new");
            File file2 = new File(worldFile, "level.dat_old");
            File file3 = new File(worldFile, "level.dat");
            class_83.method_336((class_8)newWorldTag, (OutputStream)new FileOutputStream(file));
            if (file2.exists()) {
                file2.delete();
            }
            file3.renameTo(file2);
            if (file3.exists()) {
                file3.delete();
            }
            file.renameTo(file3);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private void scanDimensionDir(File dimensionFolder, List<class_353> regions) {
        File regionFolder = new File(dimensionFolder, "region");
        File[] regionFiles = regionFolder.listFiles((dir, name) -> new File(dir, name).isFile() && name.endsWith(".mcr"));
        if (regionFiles != null) {
            Arrays.stream(regionFiles).map(class_353::new).forEach(regions::add);
        }
    }

    private void convertChunks(List<class_353> regions, BiFunction<DSL.TypeReference, class_8, class_8> convertFunction, class_62 progress) {
        IntOpenHashSet chunks;
        ArrayList<IntOpenHashSet> existingChunks = new ArrayList<IntOpenHashSet>();
        int totalChunks = 0;
        for (class_353 region : regions) {
            int[] offsets = ((RegionFileAccessor)region).getField_1318();
            chunks = new IntOpenHashSet(offsets.length);
            for (int i = 0; i < offsets.length; ++i) {
                if (offsets[i] == 0) continue;
                chunks.add(i);
            }
            existingChunks.add(chunks);
            totalChunks += chunks.size();
        }
        StationAPI.LOGGER.info("Total conversion count is " + totalChunks);
        int updatedChunks = 0;
        for (int i = 0; i < regions.size(); ++i) {
            class_353 region = regions.get(i);
            chunks = (IntSet)existingChunks.get(i);
            IntIterator it = chunks.iterator();
            while (it.hasNext()) {
                int z;
                int index = it.nextInt();
                int x = index & 0x1F;
                DataInputStream stream = region.method_1159(x, z = index >> 5);
                if (stream != null) {
                    class_8 chunkTag = class_83.method_337((DataInput)stream);
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    class_8 updatedChunkTag = convertFunction.apply(TypeReferences.CHUNK, chunkTag);
                    try (DataOutputStream outStream = region.method_1167(x, z);){
                        class_83.method_335((class_8)updatedChunkTag, (DataOutput)outStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                progress.method_1794(++updatedChunks * 100 / totalChunks);
            }
            region.method_1166();
        }
    }
}

