/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.mixin.flattening;

import java.util.Optional;
import net.minecraft.class_18;
import net.minecraft.class_50;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.registry.DimensionRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.impl.world.StationDimension;
import net.modificationstation.stationapi.impl.world.StationWorldProperties;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_50.class})
class DimensionMixin
implements StationDimension {
    @Unique
    private static final String HEIGHT_KEY = "LevelHeight";
    @Unique
    private static final String BOTTOM_Y_KEY = "BottomY";
    @Unique
    private short height = (short)128;
    @Unique
    private short bottomY = 0;
    @Shadow
    public int field_2179;
    @Shadow
    public class_18 field_2173;

    DimensionMixin() {
    }

    @Inject(method={"method_1768"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/dimension/Dimension;method_1765()V", shift=At.Shift.AFTER)})
    private void stationapi_onDimensionInit(class_18 world, CallbackInfo info) {
        StationWorldProperties properties = (StationWorldProperties)world.method_262();
        Optional optional = DimensionRegistry.INSTANCE.getIdByLegacyId(this.field_2179);
        if (optional.isPresent()) {
            Identifier id = (Identifier)optional.get();
            class_8 tag = properties.getDimensionTag(id);
            this.loadFromNBT(tag);
            this.saveToNBT(tag);
        } else {
            System.out.println("No key!");
        }
    }

    @Override
    @Unique
    public short getDefaultWorldHeight() {
        return 128;
    }

    @Override
    @Unique
    public short getActualWorldHeight() {
        return this.height;
    }

    @Override
    @Unique
    public short getActualBottomY() {
        return this.bottomY;
    }

    @Override
    @Unique
    @Deprecated
    public short getSectionCount() {
        return (short)this.field_2173.countVerticalSections();
    }

    @Unique
    public void loadFromNBT(class_8 tag) {
        this.height = tag.method_1023(HEIGHT_KEY) ? tag.method_1026(HEIGHT_KEY) : this.getDefaultWorldHeight();
        short s = this.bottomY = tag.method_1023(BOTTOM_Y_KEY) ? tag.method_1026(BOTTOM_Y_KEY) : this.getDefaultBottomY();
        if (this.height <= 0) {
            this.height = (short)16;
        }
        if ((this.height & 0xF) != 0) {
            this.height = (short)(1 << (int)Math.ceil(Math.log(this.height) / Math.log(2.0)));
        }
    }

    @Unique
    public void saveToNBT(class_8 tag) {
        tag.method_1020(HEIGHT_KEY, this.getActualWorldHeight());
        tag.method_1020(BOTTOM_Y_KEY, this.getActualBottomY());
    }
}

