/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.mixin.flattening;

import java.util.Objects;
import net.mine_diver.unsafeevents.Event;
import net.minecraft.class_124;
import net.minecraft.class_17;
import net.minecraft.class_31;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.event.item.IsItemSuitableForStateEvent;
import net.modificationstation.stationapi.api.event.item.ItemMiningSpeedMultiplierOnStateEvent;
import net.modificationstation.stationapi.api.item.StationFlatteningItemStack;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.registry.RegistryEntry;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_31.class})
abstract class ItemStackMixin
implements StationFlatteningItemStack {
    @Shadow
    public int field_753;
    @Unique
    private static final String STATION_ID = Identifier.of((Namespace)StationAPI.NAMESPACE, (String)"id").toString();

    ItemStackMixin() {
    }

    @Shadow
    public abstract class_124 method_694();

    @Inject(method={"<init>(Lnet/minecraft/block/Block;)V"}, at={@At(value="TAIL")})
    private void stationapi_onInitFromBlock(class_17 block, CallbackInfo info) {
        class_124 item = block.asItem();
        if (item != null) {
            this.field_753 = item.field_461;
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/block/Block;I)V"}, at={@At(value="TAIL")})
    private void stationapi_onInitFromBlock(class_17 block, int count, CallbackInfo info) {
        class_124 item = block.asItem();
        if (item != null) {
            this.field_753 = item.field_461;
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/block/Block;II)V"}, at={@At(value="TAIL")})
    private void stationapi_onInitFromBlock(class_17 block, int count, int meta, CallbackInfo info) {
        class_124 item = block.asItem();
        if (item != null) {
            this.field_753 = item.field_461;
        }
    }

    @Redirect(method={"writeNbt"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/NbtCompound;putShort(Ljava/lang/String;S)V", ordinal=0))
    private void stationapi_saveIdentifier(class_8 instance, String item, short i) {
        instance.method_1019(STATION_ID, ((Identifier)ItemRegistry.INSTANCE.getId(this.field_753).orElseThrow()).toString());
    }

    @Inject(method={"readNbt"}, at={@At(value="FIELD", target="Lnet/minecraft/item/ItemStack;itemId:I", opcode=181, shift=At.Shift.AFTER)})
    private void stationapi_loadIdentifier(class_8 par1, CallbackInfo ci) {
        String id = par1.method_1031(STATION_ID);
        if (id.isEmpty()) {
            StationAPI.LOGGER.warn("Attempted to load an item stack without Station Flattening ID! StationAPI will ignore this and accept the vanilla ID (" + this.field_753 + "), but this should have been handled by DFU beforehand");
        } else {
            this.field_753 = Objects.requireNonNull((class_124)ItemRegistry.INSTANCE.get((Identifier)Identifier.of((String)id))).field_461;
        }
    }

    @Override
    @Unique
    public RegistryEntry.Reference<class_124> getRegistryEntry() {
        return this.method_694().getRegistryEntry();
    }

    @Override
    @Unique
    public boolean isSuitableFor(BlockState state) {
        return ((IsItemSuitableForStateEvent)StationAPI.EVENT_BUS.post((Event)((IsItemSuitableForStateEvent.IsItemSuitableForStateEventBuilder)((Object)((IsItemSuitableForStateEvent.IsItemSuitableForStateEventBuilder)((Object)((IsItemSuitableForStateEvent.IsItemSuitableForStateEventBuilder)((Object)IsItemSuitableForStateEvent.builder().itemStack((class_31)((class_31)class_31.class.cast((Object)this))))).state((BlockState)state))).suitable((boolean)this.method_694().isSuitableFor((class_31)((class_31)class_31.class.cast((Object)this)), (BlockState)state)))).build())).suitable;
    }

    @Override
    @Unique
    public float getMiningSpeedMultiplier(BlockState state) {
        return ((ItemMiningSpeedMultiplierOnStateEvent)StationAPI.EVENT_BUS.post((Event)((ItemMiningSpeedMultiplierOnStateEvent.ItemMiningSpeedMultiplierOnStateEventBuilder)((Object)((ItemMiningSpeedMultiplierOnStateEvent.ItemMiningSpeedMultiplierOnStateEventBuilder)((Object)((ItemMiningSpeedMultiplierOnStateEvent.ItemMiningSpeedMultiplierOnStateEventBuilder)((Object)ItemMiningSpeedMultiplierOnStateEvent.builder().itemStack((class_31)((class_31)class_31.class.cast((Object)this))))).state((BlockState)state))).miningSpeedMultiplier((float)this.method_694().getMiningSpeedMultiplier((class_31)((class_31)class_31.class.cast((Object)this)), (BlockState)state)))).build())).miningSpeedMultiplier;
    }

    @Override
    @Unique
    public boolean isOf(class_124 item) {
        return this.method_694() == item;
    }
}

