/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.bonemeal;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_239;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.tag.TagKey;
import net.modificationstation.stationapi.api.util.collection.WeightedList;
import net.modificationstation.stationapi.api.util.math.Direction;

public class BonemealAPI {
    private static final Map<TagKey<class_17>, WeightedList<class_239>> PLACERS_TAG = new Reference2ObjectOpenHashMap();
    private static final Map<BlockState, WeightedList<class_239>> PLACERS_BLOCK = new Reference2ObjectOpenHashMap();
    private static final WeightedList<class_239> CACHE = new WeightedList();

    public static void addPlant(BlockState ground, BlockState plant, int weight) {
        BonemealAPI.addPlant(ground, (class_239)new SimpleStateFeature(plant), weight);
    }

    public static void addPlant(BlockState ground, class_239 plant, int weight) {
        PLACERS_BLOCK.computeIfAbsent(ground, g -> new WeightedList()).add((Object)plant, weight);
    }

    public static void addPlant(TagKey<class_17> ground, BlockState plant, int weight) {
        BonemealAPI.addPlant(ground, (class_239)new SimpleStateFeature(plant), weight);
    }

    public static void addPlant(TagKey<class_17> ground, class_239 plant, int weight) {
        PLACERS_TAG.computeIfAbsent(ground, g -> new WeightedList()).add((Object)plant, weight);
    }

    public static boolean generate(class_18 world, int x, int y, int z, BlockState state, int side) {
        BonemealAPI.updateCache(state);
        if (CACHE.isEmpty()) {
            return false;
        }
        Random random = world.field_214;
        Direction offset = Direction.byId((int)side);
        ((class_239)CACHE.get(random)).method_1142(world, random, x + offset.getOffsetX(), y + offset.getOffsetY(), z + offset.getOffsetZ());
        for (int i = 0; i < 127; i = (int)((byte)(i + 1))) {
            int px = x + random.nextInt(7) - 3;
            int py = y + random.nextInt(5) - 2;
            int pz = z + random.nextInt(7) - 3;
            state = world.getBlockState(px, py, pz);
            BonemealAPI.updateCache(state);
            if (CACHE.isEmpty()) continue;
            ((class_239)CACHE.get(random)).method_1142(world, random, px, py + 1, pz);
        }
        return true;
    }

    private static void updateCache(BlockState state) {
        CACHE.clear();
        WeightedList<class_239> structures = PLACERS_BLOCK.get(state);
        if (structures != null) {
            CACHE.addAll(structures);
        }
        state.streamTags().forEach(tag -> {
            WeightedList<class_239> tagStructures = PLACERS_TAG.get(tag);
            if (tagStructures != null) {
                CACHE.addAll(tagStructures);
            }
        });
    }

    static {
        BlockState grass = class_17.field_1946.getDefaultState();
        BonemealAPI.addPlant(grass, (class_239)new GrassFeature(), 10);
        BonemealAPI.addPlant(grass, class_17.field_1878.getDefaultState(), 1);
        BonemealAPI.addPlant(grass, class_17.field_1879.getDefaultState(), 1);
    }

    private static class SimpleStateFeature
    extends class_239 {
        private final BlockState state;

        private SimpleStateFeature(BlockState state) {
            this.state = state;
        }

        public boolean method_1142(class_18 world, Random random, int x, int y, int z) {
            BlockState worldState = world.getBlockState(x, y, z);
            if (!worldState.isAir() && !worldState.getMaterial().method_893()) {
                return false;
            }
            if (this.state.getBlock().method_1567(world, x, y, z)) {
                world.setBlockState(x, y, z, this.state);
                return true;
            }
            return false;
        }
    }

    private static class GrassFeature
    extends class_239 {
        private static final BlockState STATE = class_17.field_1845.getDefaultState();

        private GrassFeature() {
        }

        public boolean method_1142(class_18 world, Random random, int x, int y, int z) {
            BlockState worldState = world.getBlockState(x, y, z);
            if (!worldState.isAir() && !worldState.getMaterial().method_893()) {
                return false;
            }
            if (STATE.getBlock().method_1567(world, x, y, z)) {
                world.setBlockState(x, y, z, STATE);
                world.method_215(x, y, z, 1);
                return true;
            }
            return false;
        }
    }
}

