/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.tick;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public enum TickScheduler {
    CLIENT_RENDER_START,
    CLIENT_RENDER_END;

    private final Queue<Runnable> distributed = new ConcurrentLinkedQueue<Runnable>();
    private final Queue<Runnable> immediate = new ConcurrentLinkedQueue<Runnable>();

    public void distributed(@NotNull Runnable command) {
        this.distributed.add(command);
    }

    public void immediate(@NotNull Runnable command) {
        this.immediate.add(command);
    }

    @ApiStatus.Internal
    public void tick() {
        Runnable command;
        Runnable distributedCommand = this.distributed.poll();
        if (distributedCommand != null) {
            this.immediate(distributedCommand);
        }
        while ((command = this.immediate.poll()) != null) {
            command.run();
        }
    }
}

