/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.util.math;

import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;

public class MathHelper {
    public static final float SQUARE_ROOT_OF_TWO = MathHelper.sqrt(2.0f);
    private static final int[] MULTIPLY_DE_BRUIJN_BIT_POSITION = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};

    public static int ceil(float value) {
        int i = (int)value;
        return value > (float)i ? i + 1 : i;
    }

    public static float sqrt(float value) {
        return (float)Math.sqrt(value);
    }

    public static double square(double n) {
        return n * n;
    }

    public static int lerp(double delta, int start, int end) {
        return (int)Math.round((double)start + (double)(end - start) * delta);
    }

    public static float lerp(double delta, float start, float end) {
        return (float)((double)start + (double)(end - start) * delta);
    }

    public static double lerp(double delta, double start, double end) {
        return start + delta * (end - start);
    }

    public static float interpolate2D(double x, double y, float v1, float v2, float v3, float v4) {
        return MathHelper.lerp(y, MathHelper.lerp(x, v1, v2), MathHelper.lerp(x, v3, v4));
    }

    public static float interpolate3D(double x, double y, double z, float v1, float v2, float v3, float v4, float v5, float v6, float v7, float v8) {
        return MathHelper.lerp(z, MathHelper.interpolate2D(x, y, v1, v2, v3, v4), MathHelper.interpolate2D(x, y, v5, v6, v7, v8));
    }

    public static long hashCode(int x, int y, int z) {
        long l = (long)x * 3129871L ^ (long)z * 116129781L ^ (long)y;
        l = l * l * 42317861L + l * 11L;
        return l >> 16;
    }

    public static int smallestEncompassingPowerOfTwo(int value) {
        int i = value - 1;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i + 1;
    }

    public static float clamp(float value, float min, float max) {
        return Floats.constrainToRange((float)value, (float)min, (float)max);
    }

    public static int clamp(int value, int min, int max) {
        return Ints.constrainToRange((int)value, (int)min, (int)max);
    }

    public static float fastInverseSqrt(float x) {
        float f = 0.5f * x;
        int i = Float.floatToIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - f * x * x;
        return x;
    }

    public static float fastInverseCbrt(float x) {
        int i = Float.floatToIntBits(x);
        i = 1419967116 - i / 3;
        float f = Float.intBitsToFloat(i);
        f = 0.6666667f * f + 1.0f / (3.0f * f * f * x);
        f = 0.6666667f * f + 1.0f / (3.0f * f * f * x);
        return f;
    }

    public static boolean approximatelyEquals(float a, float b) {
        return Math.abs(b - a) < 1.0E-5f;
    }

    public static boolean isPowerOfTwo(int i) {
        return i != 0 && (i & i - 1) == 0;
    }

    public static int ceilLog2(int value) {
        value = MathHelper.isPowerOfTwo(value) ? value : MathHelper.smallestEncompassingPowerOfTwo(value);
        return MULTIPLY_DE_BRUIJN_BIT_POSITION[(int)((long)value * 125613361L >> 27) & 0x1F];
    }

    public static int floorLog2(int value) {
        return MathHelper.ceilLog2(value) - (MathHelper.isPowerOfTwo(value) ? 0 : 1);
    }

    public static boolean isMultipleOf(int a, int b) {
        return a % b == 0;
    }

    public static int idealHash(int i) {
        i ^= i >>> 16;
        i *= -2048144789;
        i ^= i >>> 13;
        i *= -1028477387;
        i ^= i >>> 16;
        return i;
    }

    public static int roundUpToMultiple(int value, int divisor) {
        return MathHelper.ceilDiv(value, divisor) * divisor;
    }

    public static int ceilDiv(int a, int b) {
        return -Math.floorDiv(-a, b);
    }
}

