/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.util.math;

import java.util.ArrayList;
import java.util.List;
import net.modificationstation.stationapi.api.util.Util;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import net.modificationstation.stationapi.api.util.math.Matrix3f;
import net.modificationstation.stationapi.api.util.math.Matrix4f;
import net.modificationstation.stationapi.api.util.math.Quaternion;

public class MatrixStack {
    private final List<Entry> stack = (List)Util.make(new ArrayList(), list -> list.add(new Entry((Matrix4f)Util.make((Object)new Matrix4f(), Matrix4f::loadIdentity), (Matrix3f)Util.make((Object)new Matrix3f(), Matrix3f::loadIdentity))));
    private int n = 0;

    public void translate(double x, double y, double z) {
        Entry entry = this.stack.get(this.n);
        entry.positionMatrix.multiply(Matrix4f.translateTmp((float)x, (float)y, (float)z));
    }

    public void scale(float x, float y, float z) {
        Entry entry = this.stack.get(this.n);
        entry.positionMatrix.multiply(Matrix4f.scaleTmp(x, y, z));
        if (x == y && y == z) {
            if (x > 0.0f) {
                return;
            }
            entry.normalMatrix.multiply(-1.0f);
        }
        float f = 1.0f / x;
        float g = 1.0f / y;
        float h = 1.0f / z;
        float i = MathHelper.fastInverseCbrt(f * g * h);
        entry.normalMatrix.multiply(Matrix3f.scaleTmp(i * f, i * g, i * h));
    }

    public void multiply(Quaternion quaternion) {
        Entry entry = this.stack.get(this.n);
        entry.positionMatrix.multiply(quaternion);
        entry.normalMatrix.multiply(quaternion);
    }

    public void push() {
        Entry entry = this.stack.get(this.n);
        ++this.n;
        if (this.n >= this.stack.size()) {
            this.stack.add(new Entry((Matrix4f)Util.make((Object)new Matrix4f(), Matrix4f::loadIdentity), (Matrix3f)Util.make((Object)new Matrix3f(), Matrix3f::loadIdentity)));
        }
        Entry nextEntry = this.stack.get(this.n);
        nextEntry.positionMatrix.load(entry.positionMatrix);
        nextEntry.normalMatrix.load(entry.normalMatrix);
    }

    public void pop() {
        --this.n;
    }

    public Entry peek() {
        return this.stack.get(this.n);
    }

    public boolean isEmpty() {
        return this.stack.size() == 1;
    }

    public void loadIdentity() {
        Entry entry = this.stack.get(this.n);
        entry.positionMatrix.loadIdentity();
        entry.normalMatrix.loadIdentity();
    }

    public void multiplyPositionMatrix(Matrix4f matrix) {
        this.stack.get((int)this.n).positionMatrix.multiply(matrix);
    }

    public static final class Entry {
        private final Matrix4f positionMatrix;
        private final Matrix3f normalMatrix;

        private Entry(Matrix4f matrix4f, Matrix3f matrix3f) {
            this.positionMatrix = matrix4f;
            this.normalMatrix = matrix3f;
        }

        public Matrix4f getPositionMatrix() {
            return this.positionMatrix;
        }

        public Matrix3f getNormalMatrix() {
            return this.normalMatrix;
        }
    }
}

