/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.util.math;

import com.google.common.collect.AbstractIterator;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_189;
import net.minecraft.class_25;
import net.minecraft.class_339;
import net.modificationstation.stationapi.api.util.BlockRotation;
import net.modificationstation.stationapi.api.util.Util;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import net.modificationstation.stationapi.api.util.math.MutableBlockPos;
import net.modificationstation.stationapi.api.util.math.Position;
import net.modificationstation.stationapi.api.util.math.Vec3d;
import net.modificationstation.stationapi.api.util.math.Vec3i;
import org.apache.commons.lang3.Validate;

public interface StationBlockPos {
    public static final Codec<class_339> CODEC = Codec.INT_STREAM.comapFlatMap(stream -> Util.toArray((IntStream)stream, (int)3).map(values -> new class_339(values[0], values[1], values[2])), pos -> IntStream.of(pos.getX(), pos.getY(), pos.getZ())).stable();
    public static final class_339 ORIGIN = new class_339(0, 0, 0);
    public static final int SIZE_BITS_X;
    public static final int SIZE_BITS_Z;
    public static final int SIZE_BITS_Y;
    public static final int BIT_SHIFT_X;
    public static final int BIT_SHIFT_Z;
    public static final long BITS_X;
    public static final long BITS_Z;
    public static final long BITS_Y;

    public static class_339 create(double x, double y, double z) {
        return new class_339(class_189.method_645((double)x), class_189.method_645((double)y), class_189.method_645((double)z));
    }

    public static class_339 create(Vec3d pos) {
        return StationBlockPos.create(pos.x, pos.y, pos.z);
    }

    public static class_339 create(Position pos) {
        return StationBlockPos.create(pos.getX(), pos.getY(), pos.getZ());
    }

    public static class_339 create(Vec3i pos) {
        return new class_339(pos.getX(), pos.getY(), pos.getZ());
    }

    public static long offset(long value, Direction direction) {
        return StationBlockPos.add(value, direction.getOffsetX(), direction.getOffsetY(), direction.getOffsetZ());
    }

    public static long add(long value, int x, int y, int z) {
        return StationBlockPos.asLong(StationBlockPos.unpackLongX(value) + x, StationBlockPos.unpackLongY(value) + y, StationBlockPos.unpackLongZ(value) + z);
    }

    public static int unpackLongX(long packedPos) {
        return (int)(packedPos << 64 - BIT_SHIFT_X - SIZE_BITS_X >> 64 - SIZE_BITS_X);
    }

    public static int unpackLongY(long packedPos) {
        return (int)(packedPos << 64 - SIZE_BITS_Y >> 64 - SIZE_BITS_Y);
    }

    public static int unpackLongZ(long packedPos) {
        return (int)(packedPos << 64 - BIT_SHIFT_Z - SIZE_BITS_Z >> 64 - SIZE_BITS_Z);
    }

    public static class_339 fromLong(long packedPos) {
        return new class_339(StationBlockPos.unpackLongX(packedPos), StationBlockPos.unpackLongY(packedPos), StationBlockPos.unpackLongZ(packedPos));
    }

    public static long asLong(int x, int y, int z) {
        long l = 0L;
        l |= ((long)x & BITS_X) << BIT_SHIFT_X;
        l |= (long)y & BITS_Y;
        return l |= ((long)z & BITS_Z) << BIT_SHIFT_Z;
    }

    public static long removeChunkSectionLocalY(long y) {
        return y & 0xFFFFFFFFFFFFFFF0L;
    }

    public static Iterable<class_339> iterateRandomly(Random random, int count, class_339 around, int range) {
        return StationBlockPos.iterateRandomly(random, count, around.getX() - range, around.getY() - range, around.getZ() - range, around.getX() + range, around.getY() + range, around.getZ() + range);
    }

    public static Iterable<class_339> iterateRandomly(final Random random, final int count, final int minX, final int minY, final int minZ, int maxX, int maxY, int maxZ) {
        final int i = maxX - minX + 1;
        final int j = maxY - minY + 1;
        final int k = maxZ - minZ + 1;
        return () -> new AbstractIterator<class_339>(){
            final MutableBlockPos pos = new MutableBlockPos();
            int remaining = count;

            protected class_339 computeNext() {
                if (this.remaining <= 0) {
                    return (class_339)this.endOfData();
                }
                MutableBlockPos blockPos = this.pos.set(minX + random.nextInt(i), minY + random.nextInt(j), minZ + random.nextInt(k));
                --this.remaining;
                return blockPos;
            }
        };
    }

    public static Iterable<class_339> iterateOutwards(class_339 center, final int rangeX, final int rangeY, final int rangeZ) {
        final int sum = rangeX + rangeY + rangeZ;
        final int x = center.getX();
        final int y = center.getY();
        final int z = center.getZ();
        return () -> new AbstractIterator<class_339>(){
            private final MutableBlockPos pos = new MutableBlockPos();
            private int manhattanDistance;
            private int limitX;
            private int limitY;
            private int dx;
            private int dy;
            private boolean swapZ;

            protected class_339 computeNext() {
                if (this.swapZ) {
                    this.swapZ = false;
                    this.pos.setZ(z - (this.pos.field_2102 - z));
                    return this.pos;
                }
                MutableBlockPos blockPos = null;
                while (blockPos == null) {
                    if (this.dy > this.limitY) {
                        ++this.dx;
                        if (this.dx > this.limitX) {
                            ++this.manhattanDistance;
                            if (this.manhattanDistance > sum) {
                                return (class_339)this.endOfData();
                            }
                            this.limitX = Math.min(rangeX, this.manhattanDistance);
                            this.dx = -this.limitX;
                        }
                        this.limitY = Math.min(rangeY, this.manhattanDistance - Math.abs(this.dx));
                        this.dy = -this.limitY;
                    }
                    int i2 = this.dx;
                    int j2 = this.dy;
                    int k2 = this.manhattanDistance - Math.abs(i2) - Math.abs(j2);
                    if (k2 <= rangeZ) {
                        this.swapZ = k2 != 0;
                        blockPos = this.pos.set(x + i2, y + j2, z + k2);
                    }
                    ++this.dy;
                }
                return blockPos;
            }
        };
    }

    public static Optional<class_339> findClosest(class_339 pos, int horizontalRange, int verticalRange, Predicate<class_339> condition) {
        for (class_339 blockPos : StationBlockPos.iterateOutwards(pos, horizontalRange, verticalRange, horizontalRange)) {
            if (!condition.test(blockPos)) continue;
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    public static Stream<class_339> streamOutwards(class_339 center, int maxX, int maxY, int maxZ) {
        return StreamSupport.stream(StationBlockPos.iterateOutwards(center, maxX, maxY, maxZ).spliterator(), false);
    }

    public static Iterable<class_339> iterate(class_339 start, class_339 end) {
        return StationBlockPos.iterate(Math.min(start.getX(), end.getX()), Math.min(start.getY(), end.getY()), Math.min(start.getZ(), end.getZ()), Math.max(start.getX(), end.getX()), Math.max(start.getY(), end.getY()), Math.max(start.getZ(), end.getZ()));
    }

    public static Stream<class_339> stream(class_339 start, class_339 end) {
        return StreamSupport.stream(StationBlockPos.iterate(start, end).spliterator(), false);
    }

    public static Stream<class_339> stream(class_25 box) {
        return StationBlockPos.stream(class_189.method_645((double)box.field_129), class_189.method_645((double)box.field_130), class_189.method_645((double)box.field_131), class_189.method_645((double)box.field_132), class_189.method_645((double)box.field_133), class_189.method_645((double)box.field_134));
    }

    public static Stream<class_339> stream(int startX, int startY, int startZ, int endX, int endY, int endZ) {
        return StreamSupport.stream(StationBlockPos.iterate(startX, startY, startZ, endX, endY, endZ).spliterator(), false);
    }

    public static Iterable<class_339> iterate(final int startX, final int startY, final int startZ, int endX, int endY, int endZ) {
        final int i = endX - startX + 1;
        final int j = endY - startY + 1;
        int k = endZ - startZ + 1;
        final int l = i * j * k;
        return () -> new AbstractIterator<class_339>(){
            private final MutableBlockPos pos = new MutableBlockPos();
            private int index;

            protected class_339 computeNext() {
                if (this.index == l) {
                    return (class_339)this.endOfData();
                }
                int i2 = this.index % i;
                int j2 = this.index / i;
                int k = j2 % j;
                int l2 = j2 / j;
                ++this.index;
                return this.pos.set(startX + i2, startY + k, startZ + l2);
            }
        };
    }

    public static Iterable<MutableBlockPos> iterateInSquare(final class_339 center, final int radius, final Direction firstDirection, final Direction secondDirection) {
        Validate.validState((firstDirection.getAxis() != secondDirection.getAxis() ? 1 : 0) != 0, (String)"The two directions cannot be on the same axis", (Object[])new Object[0]);
        return () -> new AbstractIterator<MutableBlockPos>(){
            private final Direction[] directions;
            private final MutableBlockPos pos;
            private final int maxDirectionChanges;
            private int directionChangeCount;
            private int maxSteps;
            private int steps;
            private int currentX;
            private int currentY;
            private int currentZ;
            {
                this.directions = new Direction[]{firstDirection, secondDirection, firstDirection.getOpposite(), secondDirection.getOpposite()};
                this.pos = center.mutableCopy().move(secondDirection);
                this.maxDirectionChanges = 4 * radius;
                this.directionChangeCount = -1;
                this.currentX = this.pos.getX();
                this.currentY = this.pos.getY();
                this.currentZ = this.pos.getZ();
            }

            protected MutableBlockPos computeNext() {
                this.pos.set(this.currentX, this.currentY, this.currentZ).move(this.directions[(this.directionChangeCount + 4) % 4]);
                this.currentX = this.pos.getX();
                this.currentY = this.pos.getY();
                this.currentZ = this.pos.getZ();
                if (this.steps >= this.maxSteps) {
                    if (this.directionChangeCount >= this.maxDirectionChanges) {
                        return (MutableBlockPos)((Object)this.endOfData());
                    }
                    ++this.directionChangeCount;
                    this.steps = 0;
                    this.maxSteps = this.directionChangeCount / 2 + 1;
                }
                ++this.steps;
                return this.pos;
            }
        };
    }

    default public int getX() {
        return (Integer)Util.assertImpl();
    }

    default public int getY() {
        return (Integer)Util.assertImpl();
    }

    default public int getZ() {
        return (Integer)Util.assertImpl();
    }

    default public long asLong() {
        return StationBlockPos.asLong(this.getX(), this.getY(), this.getZ());
    }

    default public class_339 add(double d, double e, double f) {
        return (class_339)Util.assertImpl();
    }

    default public class_339 add(int i, int j, int k) {
        return (class_339)Util.assertImpl();
    }

    default public class_339 add(Vec3i vec3i) {
        return this.add(vec3i.getX(), vec3i.getY(), vec3i.getZ());
    }

    default public class_339 subtract(Vec3i vec3i) {
        return this.add(-vec3i.getX(), -vec3i.getY(), -vec3i.getZ());
    }

    default public class_339 multiply(int i) {
        return (class_339)Util.assertImpl();
    }

    default public class_339 down() {
        return new class_339(this.getX(), this.getY() - 1, this.getZ());
    }

    default public class_339 down(int distance) {
        return new class_339(this.getX(), this.getY() - distance, this.getZ());
    }

    default public class_339 up() {
        return new class_339(this.getX(), this.getY() + 1, this.getZ());
    }

    default public class_339 up(int distance) {
        return new class_339(this.getX(), this.getY() + distance, this.getZ());
    }

    default public class_339 east() {
        return new class_339(this.getX(), this.getY(), this.getZ() - 1);
    }

    default public class_339 east(int distance) {
        return new class_339(this.getX(), this.getY(), this.getZ() - distance);
    }

    default public class_339 west() {
        return new class_339(this.getX(), this.getY(), this.getZ() + 1);
    }

    default public class_339 west(int distance) {
        return new class_339(this.getX(), this.getY(), this.getZ() + distance);
    }

    default public class_339 north() {
        return new class_339(this.getX() - 1, this.getY(), this.getZ());
    }

    default public class_339 north(int distance) {
        return new class_339(this.getX() - distance, this.getY(), this.getZ());
    }

    default public class_339 south() {
        return new class_339(this.getX() + 1, this.getY(), this.getZ());
    }

    default public class_339 south(int distance) {
        return new class_339(this.getX() + distance, this.getY(), this.getZ());
    }

    default public class_339 offset(Direction direction) {
        return new class_339(this.getX() + direction.getOffsetX(), this.getY() + direction.getOffsetY(), this.getZ() + direction.getOffsetZ());
    }

    default public class_339 offset(Direction direction, int i) {
        return (class_339)Util.assertImpl();
    }

    default public class_339 offset(Direction.Axis axis, int i) {
        return (class_339)Util.assertImpl();
    }

    default public class_339 rotate(BlockRotation rotation) {
        return (class_339)Util.assertImpl();
    }

    default public class_339 crossProduct(Vec3i pos) {
        return new class_339(this.getY() * pos.getZ() - this.getZ() * pos.getY(), this.getZ() * pos.getX() - this.getX() * pos.getZ(), this.getX() * pos.getY() - this.getY() * pos.getX());
    }

    default public class_339 withY(int y) {
        return new class_339(this.getX(), y, this.getZ());
    }

    default public class_339 toImmutable() {
        return (class_339)Util.assertImpl();
    }

    default public MutableBlockPos mutableCopy() {
        return new MutableBlockPos(this.getX(), this.getY(), this.getZ());
    }

    static {
        SIZE_BITS_Z = SIZE_BITS_X = 1 + MathHelper.floorLog2(MathHelper.smallestEncompassingPowerOfTwo(30000000));
        SIZE_BITS_Y = 64 - SIZE_BITS_X - SIZE_BITS_Z;
        BIT_SHIFT_X = SIZE_BITS_Y + SIZE_BITS_Z;
        BIT_SHIFT_Z = SIZE_BITS_Y;
        BITS_X = (1L << SIZE_BITS_X) - 1L;
        BITS_Z = (1L << SIZE_BITS_Z) - 1L;
        BITS_Y = (1L << SIZE_BITS_Y) - 1L;
    }
}

