/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.nbt;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.minecraft.class_165;
import net.minecraft.class_187;
import net.minecraft.class_202;
import net.minecraft.class_253;
import net.minecraft.class_273;
import net.minecraft.class_347;
import net.minecraft.class_358;
import net.minecraft.class_360;
import net.minecraft.class_419;
import net.minecraft.class_462;
import net.minecraft.class_522;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.nbt.NbtIntArray;
import net.modificationstation.stationapi.api.nbt.NbtLongArray;
import net.modificationstation.stationapi.api.util.Util;
import net.modificationstation.stationapi.mixin.nbt.NbtCompoundAccessor;
import net.modificationstation.stationapi.mixin.nbt.NbtListAccessor;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class NbtOps
implements DynamicOps<class_187> {
    public static final NbtOps INSTANCE = new NbtOps();
    private static final class_187 NBT_END = new class_253();

    protected NbtOps() {
    }

    public class_187 empty() {
        return NBT_END;
    }

    public <U> U convertTo(DynamicOps<U> dynamicOps, class_187 nbtElement) {
        return (U)(switch (nbtElement.method_629()) {
            case 0 -> dynamicOps.empty();
            case 1 -> dynamicOps.createByte(((class_360)nbtElement).field_1356);
            case 2 -> dynamicOps.createShort(((class_462)nbtElement).field_1770);
            case 3 -> dynamicOps.createInt(((class_347)nbtElement).field_1312);
            case 4 -> dynamicOps.createLong(((class_273)nbtElement).field_1122);
            case 5 -> dynamicOps.createFloat(((class_358)nbtElement).field_1336);
            case 6 -> dynamicOps.createDouble(((class_419)nbtElement).field_1680);
            case 7 -> dynamicOps.createByteList(ByteBuffer.wrap(((class_165)nbtElement).field_576));
            case 8 -> dynamicOps.createString(((class_522)nbtElement).field_2190);
            case 9 -> this.convertList(dynamicOps, nbtElement);
            case 10 -> this.convertMap(dynamicOps, nbtElement);
            case 11 -> dynamicOps.createIntList(Arrays.stream(((NbtIntArray)nbtElement).data));
            case 12 -> dynamicOps.createLongList(Arrays.stream(((NbtLongArray)nbtElement).data));
            default -> throw new IllegalStateException("Unknown tag type: " + String.valueOf(nbtElement));
        });
    }

    public DataResult<Number> getNumberValue(class_187 nbtElement) {
        return switch (nbtElement.method_629()) {
            case 1 -> DataResult.success((Object)((class_360)nbtElement).field_1356);
            case 2 -> DataResult.success((Object)((class_462)nbtElement).field_1770);
            case 3 -> DataResult.success((Object)((class_347)nbtElement).field_1312);
            case 4 -> DataResult.success((Object)((class_273)nbtElement).field_1122);
            case 5 -> DataResult.success((Object)Float.valueOf(((class_358)nbtElement).field_1336));
            case 6 -> DataResult.success((Object)((class_419)nbtElement).field_1680);
            default -> DataResult.error(() -> "Not a number");
        };
    }

    public class_187 createNumeric(Number number) {
        return new class_419(number.doubleValue());
    }

    public class_187 createByte(byte b) {
        return new class_360(b);
    }

    public class_187 createShort(short s) {
        return new class_462(s);
    }

    public class_187 createInt(int i) {
        return new class_347(i);
    }

    public class_187 createLong(long l) {
        return new class_273(l);
    }

    public class_187 createFloat(float f) {
        return new class_358(f);
    }

    public class_187 createDouble(double d) {
        return new class_419(d);
    }

    public class_187 createBoolean(boolean bl) {
        return new class_360((byte)(bl ? 1 : 0));
    }

    public DataResult<String> getStringValue(class_187 nbtElement) {
        DataResult dataResult;
        if (nbtElement instanceof class_522) {
            class_522 stringTag = (class_522)nbtElement;
            dataResult = DataResult.success((Object)stringTag.field_2190);
        } else {
            dataResult = DataResult.error(() -> "Not a string");
        }
        return dataResult;
    }

    public class_187 createString(String string) {
        return new class_522(string);
    }

    private static class_202 createList(byte knownType, byte valueType) {
        if (NbtOps.isTypeEqual(knownType, valueType, (byte)4)) {
            return new ListArrayTag<NbtLongArray>(new NbtLongArray(new long[0]), array -> Predicates.compose((com.google.common.base.Predicate)Predicates.alwaysTrue(), tag -> {
                array.data = ArrayUtils.insert((int)array.data.length, (long[])array.data, (long[])new long[]{tag.field_1122});
                return array.data;
            }), array -> i -> new class_273(array.data[i]), array -> () -> array.data.length, 4);
        }
        if (NbtOps.isTypeEqual(knownType, valueType, (byte)1)) {
            return new ListArrayTag<class_165>(new class_165(new byte[0]), array -> Predicates.compose((com.google.common.base.Predicate)Predicates.alwaysTrue(), tag -> {
                array.field_576 = ArrayUtils.insert((int)array.field_576.length, (byte[])array.field_576, (byte[])new byte[]{tag.field_1356});
                return array.field_576;
            }), array -> i -> new class_360(array.field_576[i]), array -> () -> array.field_576.length, 1);
        }
        if (NbtOps.isTypeEqual(knownType, valueType, (byte)3)) {
            return new ListArrayTag<NbtIntArray>(new NbtIntArray(new int[0]), array -> Predicates.compose((com.google.common.base.Predicate)Predicates.alwaysTrue(), tag -> {
                array.data = ArrayUtils.insert((int)array.data.length, (int[])array.data, (int[])new int[]{tag.field_1312});
                return array.data;
            }), array -> i -> new class_347(array.data[i]), array -> () -> array.data.length, 3);
        }
        return new class_202();
    }

    private static boolean isTypeEqual(byte knownType, byte valueType, byte expectedType) {
        return knownType == expectedType && (valueType == expectedType || valueType == 0);
    }

    private static void addAll(class_202 destination, class_187 source, class_187 additionalValue) {
        if (source instanceof class_202) {
            class_202 abstractNbtList = (class_202)source;
            IntStream.of(0, abstractNbtList.method_1398()).mapToObj(arg_0 -> ((class_202)abstractNbtList).method_1396(arg_0)).forEach(arg_0 -> ((class_202)destination).method_1397(arg_0));
        }
        destination.method_1397(additionalValue);
    }

    private static void addAll(class_202 destination, class_187 source, List<class_187> additionalValues) {
        if (source instanceof class_202) {
            class_202 abstractNbtList = (class_202)source;
            IntStream.of(0, abstractNbtList.method_1398()).mapToObj(arg_0 -> ((class_202)abstractNbtList).method_1396(arg_0)).forEach(arg_0 -> ((class_202)destination).method_1397(arg_0));
        }
        additionalValues.forEach(arg_0 -> ((class_202)destination).method_1397(arg_0));
    }

    public DataResult<class_187> mergeToList(class_187 nbtElement, class_187 nbtElement2) {
        if (!(nbtElement instanceof class_202) && !(nbtElement instanceof class_253)) {
            return DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(nbtElement), (Object)nbtElement);
        }
        class_202 abstractNbtList = NbtOps.createList(nbtElement instanceof class_202 ? ((NbtListAccessor)nbtElement).stationapi$getType() : (byte)0, nbtElement2.method_629());
        NbtOps.addAll(abstractNbtList, nbtElement, nbtElement2);
        return DataResult.success((Object)abstractNbtList);
    }

    public DataResult<class_187> mergeToList(class_187 nbtElement, List<class_187> list) {
        if (!(nbtElement instanceof class_202) && !(nbtElement instanceof class_253)) {
            return DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(nbtElement), (Object)nbtElement);
        }
        class_202 abstractNbtList = NbtOps.createList(nbtElement instanceof class_202 ? ((NbtListAccessor)nbtElement).stationapi$getType() : (byte)0, list.stream().findFirst().map(class_187::method_629).orElse((byte)0));
        NbtOps.addAll(abstractNbtList, nbtElement, list);
        return DataResult.success((Object)abstractNbtList);
    }

    public DataResult<class_187> mergeToMap(class_187 nbtElement, class_187 nbtElement2, class_187 nbtElement3) {
        class_8 class_82;
        if (!(nbtElement instanceof class_8) && !(nbtElement instanceof class_253)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(nbtElement), (Object)nbtElement);
        }
        if (!(nbtElement2 instanceof class_522)) {
            return DataResult.error(() -> "key is not a string: " + String.valueOf(nbtElement2), (Object)nbtElement);
        }
        class_522 stringTag = (class_522)nbtElement2;
        if (nbtElement instanceof class_8) {
            class_8 nbtCompound2 = (class_8)nbtElement;
            class_82 = nbtCompound2.copy();
        } else {
            class_82 = new class_8();
        }
        class_8 nbtCompound = class_82;
        nbtCompound.method_1017(stringTag.field_2190, nbtElement3);
        return DataResult.success((Object)nbtCompound);
    }

    public DataResult<class_187> mergeToMap(class_187 nbtElement, MapLike<class_187> mapLike) {
        class_8 class_82;
        if (!(nbtElement instanceof class_8) && !(nbtElement instanceof class_253)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(nbtElement), (Object)nbtElement);
        }
        if (nbtElement instanceof class_8) {
            class_8 nbtCompound2 = (class_8)nbtElement;
            class_82 = nbtCompound2.copy();
        } else {
            class_82 = new class_8();
        }
        class_8 nbtCompound = class_82;
        ArrayList invalidKeys = new ArrayList();
        mapLike.entries().forEach(pair -> {
            class_187 key = (class_187)pair.getFirst();
            if (key instanceof class_522) {
                class_522 stringTag = (class_522)key;
                nbtCompound.method_1017(stringTag.field_2190, (class_187)pair.getSecond());
            } else {
                invalidKeys.add(key);
            }
        });
        return invalidKeys.isEmpty() ? DataResult.success((Object)nbtCompound) : DataResult.error(() -> "some keys are not strings: " + String.valueOf(invalidKeys), (Object)nbtCompound);
    }

    public DataResult<Stream<Pair<class_187, class_187>>> getMapValues(class_187 nbtElement) {
        if (!(nbtElement instanceof class_8)) {
            return DataResult.error(() -> "Not a map: " + String.valueOf(nbtElement));
        }
        class_8 nbtCompound = (class_8)nbtElement;
        return DataResult.success(((NbtCompoundAccessor)nbtCompound).stationapi$getEntries().entrySet().stream().map(entry -> Pair.of((Object)this.createString((String)entry.getKey()), (Object)((class_187)entry.getValue()))));
    }

    public DataResult<Consumer<BiConsumer<class_187, class_187>>> getMapEntries(class_187 nbtElement) {
        if (!(nbtElement instanceof class_8)) {
            return DataResult.error(() -> "Not a map: " + String.valueOf(nbtElement));
        }
        class_8 nbtCompound = (class_8)nbtElement;
        return DataResult.success(entryConsumer -> ((NbtCompoundAccessor)nbtCompound).stationapi$getEntries().forEach((key, value) -> entryConsumer.accept(this.createString((String)key), value)));
    }

    public DataResult<MapLike<class_187>> getMap(class_187 nbtElement) {
        if (!(nbtElement instanceof class_8)) {
            return DataResult.error(() -> "Not a map: " + String.valueOf(nbtElement));
        }
        final class_8 nbtCompound = (class_8)nbtElement;
        return DataResult.success((Object)new MapLike<class_187>(){

            @Nullable
            public class_187 get(class_187 nbtElement) {
                return ((NbtCompoundAccessor)nbtCompound).stationapi$getEntries().get(nbtElement.toString());
            }

            @Nullable
            public class_187 get(String string) {
                return ((NbtCompoundAccessor)nbtCompound).stationapi$getEntries().get(string);
            }

            public Stream<Pair<class_187, class_187>> entries() {
                return ((NbtCompoundAccessor)nbtCompound).stationapi$getEntries().entrySet().stream().map(entry -> Pair.of((Object)NbtOps.this.createString((String)entry.getKey()), (Object)((class_187)entry.getValue())));
            }

            public String toString() {
                return "MapLike[" + String.valueOf(nbtCompound) + "]";
            }
        });
    }

    public class_187 createMap(Stream<Pair<class_187, class_187>> stream) {
        return (class_187)Util.make((Object)new class_8(), nbtCompound -> stream.forEach(entry -> nbtCompound.method_1017(((class_187)entry.getFirst()).toString(), (class_187)entry.getSecond())));
    }

    public DataResult<Stream<class_187>> getStream(class_187 nbtElement) {
        DataResult dataResult;
        if (nbtElement instanceof class_202) {
            class_202 listTag = (class_202)nbtElement;
            dataResult = DataResult.success(IntStream.range(0, listTag.method_1398()).mapToObj(arg_0 -> ((class_202)listTag).method_1396(arg_0)));
        } else {
            dataResult = DataResult.error(() -> "Not a list");
        }
        return dataResult;
    }

    public DataResult<Consumer<Consumer<class_187>>> getList(class_187 nbtElement) {
        if (nbtElement instanceof class_202) {
            class_202 abstractNbtList = (class_202)nbtElement;
            return DataResult.success(IntStream.range(0, abstractNbtList.method_1398()).mapToObj(arg_0 -> ((class_202)abstractNbtList).method_1396(arg_0))::forEach);
        }
        return DataResult.error(() -> "Not a list: " + String.valueOf(nbtElement));
    }

    public DataResult<ByteBuffer> getByteBuffer(class_187 nbtElement) {
        if (nbtElement instanceof class_165) {
            class_165 nbtByteArray = (class_165)nbtElement;
            return DataResult.success((Object)ByteBuffer.wrap(nbtByteArray.field_576));
        }
        return super.getByteBuffer((Object)nbtElement);
    }

    public class_187 createByteList(ByteBuffer byteBuffer) {
        return new class_165(DataFixUtils.toArray((ByteBuffer)byteBuffer));
    }

    public DataResult<IntStream> getIntStream(class_187 nbtElement) {
        if (nbtElement instanceof NbtIntArray) {
            NbtIntArray nbtIntArray = (NbtIntArray)nbtElement;
            return DataResult.success((Object)Arrays.stream(nbtIntArray.data));
        }
        return super.getIntStream((Object)nbtElement);
    }

    public class_187 createIntList(IntStream intStream) {
        return new NbtIntArray(intStream.toArray());
    }

    public DataResult<LongStream> getLongStream(class_187 nbtElement) {
        if (nbtElement instanceof NbtLongArray) {
            NbtLongArray nbtLongArray = (NbtLongArray)nbtElement;
            return DataResult.success((Object)Arrays.stream(nbtLongArray.data));
        }
        return super.getLongStream((Object)nbtElement);
    }

    public class_187 createLongList(LongStream longStream) {
        return new NbtLongArray(longStream.toArray());
    }

    public class_187 createList(Stream<class_187> stream) {
        PeekingIterator peekingIterator = Iterators.peekingIterator(stream.iterator());
        if (!peekingIterator.hasNext()) {
            return new class_202();
        }
        class_187 nbtElement = (class_187)peekingIterator.peek();
        if (nbtElement instanceof class_360) {
            class_360 nbtByte = (class_360)nbtElement;
            ArrayList list = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, nbt -> nbtByte.field_1356));
            return new class_165(Bytes.toArray((Collection)list));
        }
        if (nbtElement instanceof class_347) {
            class_347 nbtInt = (class_347)nbtElement;
            ArrayList list = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, nbt -> nbtInt.field_1312));
            return new NbtIntArray(Ints.toArray((Collection)list));
        }
        if (nbtElement instanceof class_273) {
            class_273 nbtLong = (class_273)nbtElement;
            ArrayList list = Lists.newArrayList((Iterator)Iterators.transform((Iterator)peekingIterator, nbt -> nbtLong.field_1122));
            return new NbtLongArray(Longs.toArray((Collection)list));
        }
        class_202 list = new class_202();
        while (peekingIterator.hasNext()) {
            class_187 nbtElement2 = (class_187)peekingIterator.next();
            if (nbtElement2 instanceof class_253) continue;
            list.method_1397(nbtElement2);
        }
        return list;
    }

    public class_187 remove(class_187 nbtElement, String string) {
        if (nbtElement instanceof class_8) {
            class_8 nbtCompound = (class_8)nbtElement;
            class_8 nbtCompound2 = new class_8();
            ((NbtCompoundAccessor)nbtCompound).stationapi$getEntries().entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), string)).forEach(entry -> nbtCompound2.method_1017((String)entry.getKey(), (class_187)entry.getValue()));
            return nbtCompound2;
        }
        return nbtElement;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<class_187> mapBuilder() {
        return new MapBuilder();
    }

    private static class ListArrayTag<T extends class_187>
    extends class_202 {
        private final T array;

        private <U extends class_187> ListArrayTag(T array, Function<T, Predicate<U>> adderFactory, Function<T, IntFunction<U>> getterFactory, Function<T, IntSupplier> sizeGetterFactory, byte listTypeId) {
            this.array = array;
            final Predicate<U> adder = adderFactory.apply(array);
            final IntFunction<U> getter = getterFactory.apply(array);
            final IntSupplier sizeGetter = sizeGetterFactory.apply(array);
            NbtListAccessor _super = (NbtListAccessor)((Object)this);
            _super.stationapi$setValue(new AbstractList<U>(){

                @Override
                public boolean add(U abstractTag) {
                    return adder.test(abstractTag);
                }

                @Override
                public U get(int index) {
                    return (class_187)getter.apply(index);
                }

                @Override
                public int size() {
                    return sizeGetter.getAsInt();
                }
            });
            _super.stationapi$setType(listTypeId);
        }

        public byte method_629() {
            return this.array.method_629();
        }

        public String toString() {
            return this.array.toString();
        }

        public void method_631(DataOutput out) {
            this.array.method_631(out);
        }

        public void method_630(DataInput in) {
            this.array.method_630(in);
        }

        public String method_626() {
            return this.array.method_626();
        }

        public class_187 method_625(String string) {
            return this.array.method_625(string);
        }
    }

    class MapBuilder
    extends RecordBuilder.AbstractStringBuilder<class_187, class_8> {
        protected MapBuilder() {
            super((DynamicOps)NbtOps.this);
        }

        protected class_8 initBuilder() {
            return new class_8();
        }

        protected class_8 append(String string, class_187 nbtElement, class_8 nbtCompound) {
            nbtCompound.method_1017(string, nbtElement);
            return nbtCompound;
        }

        protected DataResult<class_187> build(class_8 nbtCompound, class_187 nbtElement) {
            if (nbtElement == null || nbtElement instanceof class_253) {
                return DataResult.success((Object)nbtCompound);
            }
            if (nbtElement instanceof class_8) {
                class_8 nbtCompound3 = (class_8)nbtElement;
                class_8 nbtCompound2 = (class_8)Util.make((Object)new class_8(), compoundTag -> ((NbtCompoundAccessor)nbtCompound3).stationapi$getEntries().forEach((arg_0, arg_1) -> ((class_8)compoundTag).method_1017(arg_0, arg_1)));
                ((NbtCompoundAccessor)nbtCompound).stationapi$getEntries().forEach((arg_0, arg_1) -> ((class_8)nbtCompound2).method_1017(arg_0, arg_1));
                return DataResult.success((Object)nbtCompound2);
            }
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(nbtElement), (Object)nbtElement);
        }
    }
}

