/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.network.packet;

import net.minecraft.class_169;
import net.minecraft.class_240;
import net.modificationstation.stationapi.api.registry.IdentifiablePacketRegistry;
import net.modificationstation.stationapi.api.registry.Registry;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.impl.network.packet.IdentifiablePacketImpl;

public interface IdentifiablePacket {
    public static final int PACKET_ID = 254;

    public static Factory register(Identifier id, boolean clientBound, boolean serverBound, Factory factory) {
        if (IdentifiablePacketRegistry.INSTANCE.containsId(id)) {
            throw new IllegalArgumentException("Duplicate packet id:" + String.valueOf(id));
        }
        Factory ret = (Factory)Registry.register(IdentifiablePacketRegistry.INSTANCE, (Identifier)id, (Object)factory);
        if (clientBound) {
            IdentifiablePacketImpl.CLIENT_BOUND_PACKETS.add(id);
        }
        if (serverBound) {
            IdentifiablePacketImpl.SERVER_BOUND_PACKETS.add(id);
        }
        return ret;
    }

    public static void setHandler(Identifier packetId, class_240 handler) {
        class_240 previous = IdentifiablePacketImpl.HANDLERS.put(packetId, handler);
        if (previous != null) {
            throw new IllegalArgumentException("Duplicate handler for packet id \"" + String.valueOf(packetId) + "\"! Previous: \"" + previous.getClass().getName() + "\", new: \"" + handler.getClass().getName() + "\"");
        }
    }

    public static class_169 create(Identifier id) {
        Factory factory = (Factory)IdentifiablePacketRegistry.INSTANCE.get(id);
        return factory == null ? null : factory.create();
    }

    public Identifier getId();

    @FunctionalInterface
    public static interface Factory {
        public class_169 create();
    }
}

