/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.network.packet;

import com.google.gson.Gson;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.function.BiConsumer;
import net.minecraft.class_169;
import net.minecraft.class_240;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.entity.player.PlayerHelper;
import net.modificationstation.stationapi.api.network.packet.IdentifiablePacket;
import net.modificationstation.stationapi.api.registry.MessageListenerRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.ApiStatus;

public class MessagePacket
extends class_169
implements IdentifiablePacket {
    public static final Identifier PACKET_ID = StationAPI.NAMESPACE.id("message");
    private Identifier identifier;
    public boolean[] booleans;
    public byte[] bytes;
    public short[] shorts;
    public char[] chars;
    public int[] ints;
    public long[] longs;
    public float[] floats;
    public double[] doubles;
    public String[] strings;
    private String[] objectsInternal;
    public Object[] objects;

    @ApiStatus.Internal
    public MessagePacket() {
    }

    public MessagePacket(Identifier identifier) {
        this.identifier = identifier;
    }

    public static int size(boolean[] booleans) {
        return 4 + (int)Math.ceil((double)booleans.length / 8.0);
    }

    public static int size(byte[] bytes) {
        return 4 + bytes.length;
    }

    public static int size(short[] shorts) {
        return 4 + shorts.length * 2;
    }

    public static int size(char[] chars) {
        return 4 + chars.length * 2;
    }

    public static int size(int[] ints) {
        return 4 + ints.length * 4;
    }

    public static int size(long[] longs) {
        return 4 + longs.length * 8;
    }

    public static int size(float[] floats) {
        return 4 + floats.length * 4;
    }

    public static int size(double[] doubles) {
        return 4 + doubles.length * 8;
    }

    public static int size(String[] strings) {
        int size = 4;
        for (String string : strings) {
            size += MessagePacket.size(string.toCharArray());
        }
        return size;
    }

    public static int size(Object[] objects) {
        int size = 4;
        Gson gson = new Gson();
        for (Object o : objects) {
            size += MessagePacket.size(gson.toJson(o).toCharArray()) + MessagePacket.size(o == null ? "null".toCharArray() : o.getClass().getName().toCharArray());
        }
        return size;
    }

    public void method_806(DataInputStream in) {
        try {
            int i;
            int length;
            this.identifier = Identifier.of((String)MessagePacket.method_802((DataInputStream)in, (int)Short.MAX_VALUE));
            short s = in.readShort();
            boolean[] present = new boolean[]{(s & 0x200) != 0, (s & 0x100) != 0, (s & 0x80) != 0, (s & 0x40) != 0, (s & 0x20) != 0, (s & 0x10) != 0, (s & 8) != 0, (s & 4) != 0, (s & 2) != 0, (s & 1) != 0};
            if (present[0]) {
                length = in.readInt();
                this.booleans = new boolean[length];
                int lengthBytes = (int)Math.ceil((double)length / 8.0);
                for (int i2 = 0; i2 < lengthBytes; ++i2) {
                    byte b = in.readByte();
                    for (int j = i2 * 8; j < Math.min((i2 + 1) * 8, length); ++j) {
                        this.booleans[j] = (b & (int)Math.pow(2.0, 7 - (j - i2 * 8))) != 0;
                    }
                }
            }
            if (present[1]) {
                length = in.readInt();
                this.bytes = new byte[length];
                for (i = 0; i < length; ++i) {
                    this.bytes[i] = in.readByte();
                }
            }
            if (present[2]) {
                length = in.readInt();
                this.shorts = new short[length];
                for (i = 0; i < length; ++i) {
                    this.shorts[i] = in.readShort();
                }
            }
            if (present[3]) {
                length = in.readInt();
                this.chars = new char[length];
                for (i = 0; i < length; ++i) {
                    this.chars[i] = in.readChar();
                }
            }
            if (present[4]) {
                length = in.readInt();
                this.ints = new int[length];
                for (i = 0; i < length; ++i) {
                    this.ints[i] = in.readInt();
                }
            }
            if (present[5]) {
                length = in.readInt();
                this.longs = new long[length];
                for (i = 0; i < length; ++i) {
                    this.longs[i] = in.readLong();
                }
            }
            if (present[6]) {
                length = in.readInt();
                this.floats = new float[length];
                for (i = 0; i < length; ++i) {
                    this.floats[i] = in.readFloat();
                }
            }
            if (present[7]) {
                length = in.readInt();
                this.doubles = new double[length];
                for (i = 0; i < length; ++i) {
                    this.doubles[i] = in.readDouble();
                }
            }
            if (present[8]) {
                length = in.readInt();
                this.strings = new String[length];
                for (i = 0; i < length; ++i) {
                    this.strings[i] = MessagePacket.method_802((DataInputStream)in, (int)Short.MAX_VALUE);
                }
            }
            if (present[9]) {
                length = in.readInt();
                this.objectsInternal = new String[length * 2];
                for (i = 0; i < length * 2; ++i) {
                    this.objectsInternal[i] = MessagePacket.method_802((DataInputStream)in, (int)Short.MAX_VALUE);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_807(DataOutputStream out) {
        try {
            MessagePacket.method_804((String)this.identifier.toString(), (DataOutputStream)out);
            boolean[] absent = new boolean[]{this.booleans == null, this.bytes == null, this.shorts == null, this.chars == null, this.ints == null, this.longs == null, this.floats == null, this.doubles == null, this.strings == null, this.objects == null};
            out.writeShort((short)((absent[0] ? 0 : 512) + (absent[1] ? 0 : 256) + (absent[2] ? 0 : 128) + (absent[3] ? 0 : 64) + (absent[4] ? 0 : 32) + (absent[5] ? 0 : 16) + (absent[6] ? 0 : 8) + (absent[7] ? 0 : 4) + (absent[8] ? 0 : 2) + (absent[9] ? 0 : 1)));
            if (!absent[0]) {
                int length = this.booleans.length;
                out.writeInt(length);
                for (int i = 0; i < (int)Math.ceil((double)length / 8.0); ++i) {
                    int i0 = i * 8;
                    int i1 = i * 8 + 1;
                    int i2 = i * 8 + 2;
                    int i3 = i * 8 + 3;
                    int i4 = i * 8 + 4;
                    int i5 = i * 8 + 5;
                    int i6 = i * 8 + 6;
                    int i7 = i * 8 + 7;
                    out.writeByte((byte)((length > i0 && this.booleans[i0] ? 128 : 0) + (length > i1 && this.booleans[i1] ? 64 : 0) + (length > i2 && this.booleans[i2] ? 32 : 0) + (length > i3 && this.booleans[i3] ? 16 : 0) + (length > i4 && this.booleans[i4] ? 8 : 0) + (length > i5 && this.booleans[i5] ? 4 : 0) + (length > i6 && this.booleans[i6] ? 2 : 0) + (length > i7 && this.booleans[i7] ? 1 : 0)));
                }
            }
            if (!absent[1]) {
                out.writeInt(this.bytes.length);
                for (byte b : this.bytes) {
                    out.writeByte(b);
                }
            }
            if (!absent[2]) {
                out.writeInt(this.shorts.length);
                for (short s : this.shorts) {
                    out.writeShort(s);
                }
            }
            if (!absent[3]) {
                out.writeInt(this.chars.length);
                for (char c : this.chars) {
                    out.writeChar(c);
                }
            }
            if (!absent[4]) {
                out.writeInt(this.ints.length);
                for (int i : this.ints) {
                    out.writeInt(i);
                }
            }
            if (!absent[5]) {
                out.writeInt(this.ints.length);
                for (long l : this.longs) {
                    out.writeLong(l);
                }
            }
            if (!absent[6]) {
                out.writeInt(this.floats.length);
                for (float f : this.floats) {
                    out.writeFloat(f);
                }
            }
            if (!absent[7]) {
                out.writeInt(this.doubles.length);
                for (double d : this.doubles) {
                    out.writeDouble(d);
                }
            }
            if (!absent[8]) {
                out.writeInt(this.strings.length);
                for (String s : this.strings) {
                    MessagePacket.method_804((String)s, (DataOutputStream)out);
                }
            }
            if (!absent[9]) {
                out.writeInt(this.objects.length);
                Gson gson = new Gson();
                for (Object o : this.objects) {
                    MessagePacket.method_804((String)gson.toJson(o), (DataOutputStream)out);
                    MessagePacket.method_804((String)(o == null ? "null" : o.getClass().getName()), (DataOutputStream)out);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void method_808(class_240 handler) {
        BiConsumer messageListener = (BiConsumer)MessageListenerRegistry.INSTANCE.get(this.identifier);
        if (messageListener != null) {
            messageListener.accept(PlayerHelper.getPlayerFromPacketHandler((class_240)handler), this);
        }
    }

    public int method_798() {
        return MessagePacket.size(this.identifier.toString().toCharArray()) + 2 + (this.booleans == null ? 0 : MessagePacket.size(this.booleans)) + (this.bytes == null ? 0 : MessagePacket.size(this.bytes)) + (this.shorts == null ? 0 : MessagePacket.size(this.shorts)) + (this.chars == null ? 0 : MessagePacket.size(this.chars)) + (this.ints == null ? 0 : MessagePacket.size(this.ints)) + (this.longs == null ? 0 : MessagePacket.size(this.longs)) + (this.floats == null ? 0 : MessagePacket.size(this.floats)) + (this.doubles == null ? 0 : MessagePacket.size(this.doubles)) + (this.strings == null ? 0 : MessagePacket.size(this.strings)) + (this.objects == null ? 0 : MessagePacket.size(this.objects));
    }

    @Override
    public Identifier getId() {
        return PACKET_ID;
    }

    public Object[] deserializeObjects() {
        this.objects = new Object[this.objectsInternal.length / 2];
        Gson gson = new Gson();
        for (int i = 0; i < this.objectsInternal.length; i += 2) {
            try {
                String objectJson = this.objectsInternal[0];
                String className = this.objectsInternal[1];
                this.objects[i] = className.equals("null") ? null : gson.fromJson(objectJson, Class.forName(className));
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.objects;
    }
}

