/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.recipe;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.chars.Char2ReferenceOpenHashMap;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_148;
import net.minecraft.class_17;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.tag.TagKey;
import net.modificationstation.stationapi.impl.recipe.StationShapedRecipe;
import net.modificationstation.stationapi.impl.recipe.StationShapelessRecipe;

public class CraftingRegistry {
    public static void addShapedRecipe(class_31 output, Object ... recipe) {
        StringBuilder ingredients = new StringBuilder();
        int currentElement = 0;
        int width = 0;
        int height = 0;
        Object object = recipe[currentElement];
        if (object instanceof String[]) {
            String[] grid = (String[])object;
            ++currentElement;
            for (int i = 0; i < grid.length; ++i) {
                String ingredientsLine = grid[i];
                ++height;
                width = ingredientsLine.length();
                ingredients.append(ingredientsLine);
            }
        } else {
            Object i;
            while ((i = recipe[currentElement]) instanceof String) {
                String ingredientsLine = (String)i;
                ++currentElement;
                ++height;
                width = ingredientsLine.length();
                ingredients.append(ingredientsLine);
            }
        }
        Char2ReferenceOpenHashMap keyToIngredient = new Char2ReferenceOpenHashMap();
        while (currentElement < recipe.length) {
            char c = ((Character)recipe[currentElement]).charValue();
            Either ingredient = null;
            Object element = recipe[currentElement + 1];
            if (element instanceof TagKey) {
                TagKey tag = (TagKey)element;
                Optional itemTagOpt = tag.tryCast(ItemRegistry.KEY);
                if (itemTagOpt.isPresent()) {
                    ingredient = Either.left((Object)((TagKey)itemTagOpt.get()));
                }
            } else if (element instanceof class_17) {
                class_17 block = (class_17)element;
                ingredient = Either.right((Object)new class_31(block, 1, -1));
            } else if (element instanceof class_31) {
                class_31 stack = (class_31)element;
                ingredient = Either.right((Object)stack);
            } else if (element instanceof class_124) {
                class_124 item = (class_124)element;
                ingredient = Either.right((Object)new class_31(item));
            }
            keyToIngredient.put(c, (Object)ingredient);
            currentElement += 2;
        }
        Either[] grid = new Either[width * height];
        for (int i = 0; i < width * height; ++i) {
            char c = ingredients.charAt(i);
            grid[i] = keyToIngredient.containsKey(c) ? ((Either)keyToIngredient.get(c)).mapRight(class_31::method_724) : null;
        }
        class_148.method_538().method_541().add(new StationShapedRecipe(width, height, grid, output));
    }

    public static void addShapelessRecipe(class_31 output, Object ... ingredients) {
        Either[] checkedIngredients = new Either[ingredients.length];
        for (Object ingredient : ingredients) {
            if (ingredient instanceof class_31) {
                class_31 stack = (class_31)ingredient;
                checkedIngredients[i] = Either.right((Object)stack.method_724());
                continue;
            }
            if (ingredient instanceof class_124) {
                class_124 item = (class_124)ingredient;
                checkedIngredients[i] = Either.right((Object)new class_31(item));
                continue;
            }
            if (ingredient instanceof class_17) {
                class_17 block = (class_17)ingredient;
                checkedIngredients[i] = Either.right((Object)new class_31(block));
                continue;
            }
            if (ingredient instanceof TagKey) {
                TagKey tag = (TagKey)ingredient;
                Optional itemTagOpt = tag.tryCast(ItemRegistry.KEY);
                if (!itemTagOpt.isPresent()) continue;
                checkedIngredients[i] = Either.left((Object)((TagKey)itemTagOpt.get()));
                continue;
            }
            throw new RuntimeException("Invalid shapeless recipe ingredient of type " + ingredient.getClass().getName() + "!");
        }
        class_148.method_538().method_541().add(new StationShapelessRecipe(output, checkedIngredients));
    }
}

