/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.api.recipe;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import net.minecraft.class_124;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.registry.RegistryEntry;
import net.modificationstation.stationapi.api.tag.TagKey;

public class FuelRegistry {
    private static final Reference2IntMap<TagKey<class_124>> TAG_FUEL_TIME = new Reference2IntOpenHashMap();
    private static final Reference2IntMap<class_124> ITEM_FUEL_TIME = new Reference2IntOpenHashMap();
    private static final Reference2IntMap<class_31> FUELS = new Reference2IntOpenHashMap();
    private static final Reference2IntMap<class_31> FUELS_VIEW = Reference2IntMaps.unmodifiable(FUELS);
    private static boolean viewInvalidated;

    public static int getFuelTime(class_31 stack) {
        return stack == null ? 0 : stack.getRegistryEntry().streamTags().mapToInt(arg_0 -> TAG_FUEL_TIME.getInt(arg_0)).filter(value -> value > 0).findFirst().orElseGet(() -> ITEM_FUEL_TIME.getInt((Object)stack.method_694()));
    }

    public static void addFuelTag(TagKey<class_124> tag, int fuelTime) {
        viewInvalidated = true;
        TAG_FUEL_TIME.put(tag, fuelTime);
    }

    public static void addFuelItem(class_124 item, int fuelTime) {
        viewInvalidated = true;
        ITEM_FUEL_TIME.put((Object)item, fuelTime);
    }

    public static Reference2IntMap<class_31> getFuelsView() {
        if (viewInvalidated) {
            FUELS.clear();
            for (Reference2IntMap.Entry entry : TAG_FUEL_TIME.reference2IntEntrySet()) {
                for (RegistryEntry item : ItemRegistry.INSTANCE.getOrCreateEntryList((TagKey)entry.getKey())) {
                    FUELS.put((Object)new class_31((class_124)item.value()), entry.getIntValue());
                }
            }
            for (Reference2IntMap.Entry entry : ITEM_FUEL_TIME.reference2IntEntrySet()) {
                FUELS.put((Object)new class_31((class_124)entry.getKey()), entry.getIntValue());
            }
            viewInvalidated = false;
        }
        return FUELS_VIEW;
    }
}

