/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.minecraft.class_124;
import net.modificationstation.stationapi.api.event.recipe.RecipeRegisterEvent;
import net.modificationstation.stationapi.api.event.registry.JsonRecipeParserRegistryEvent;
import net.modificationstation.stationapi.api.item.json.JsonItemKey;
import net.modificationstation.stationapi.api.mod.entrypoint.Entrypoint;
import net.modificationstation.stationapi.api.mod.entrypoint.EventBusPolicy;
import net.modificationstation.stationapi.api.recipe.CraftingRegistry;
import net.modificationstation.stationapi.api.recipe.SmeltingRegistry;
import net.modificationstation.stationapi.api.registry.JsonRecipeParserRegistry;
import net.modificationstation.stationapi.api.registry.JsonRecipesRegistry;
import net.modificationstation.stationapi.api.registry.Registry;
import net.modificationstation.stationapi.api.tag.TagKey;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.impl.recipe.JsonCraftingShaped;
import net.modificationstation.stationapi.impl.recipe.JsonCraftingShapeless;
import net.modificationstation.stationapi.impl.recipe.JsonSmelting;

@Entrypoint(eventBus=@EventBusPolicy(registerInstance=false))
@EventListener(phase="stationapi:internal")
public class JsonRecipeParserInit {
    @EventListener
    private static void registerJsonRecipeParsers(JsonRecipeParserRegistryEvent event) {
        Registry.register((Registry)event.registry, (Identifier)Identifier.of((String)"crafting_shaped"), JsonRecipeParserInit::parseCraftingShaped);
        Registry.register((Registry)event.registry, (Identifier)Identifier.of((String)"crafting_shapeless"), JsonRecipeParserInit::parseCraftingShapeless);
        Registry.register((Registry)event.registry, (Identifier)Identifier.of((String)"smelting"), JsonRecipeParserInit::parseSmelting);
    }

    @EventListener
    private static void parseAndRegisterRecipe(RecipeRegisterEvent event) {
        Consumer jsonRecipeParser = (Consumer)JsonRecipeParserRegistry.INSTANCE.get(event.recipeId);
        Set jsonRecipes = (Set)JsonRecipesRegistry.INSTANCE.get(event.recipeId);
        if (jsonRecipeParser != null && jsonRecipes != null) {
            jsonRecipes.forEach(jsonRecipeParser);
        }
    }

    private static void parseCraftingShaped(URL recipe) {
        JsonElement rawJson;
        try {
            rawJson = (JsonElement)new Gson().fromJson((Reader)new BufferedReader(new InputStreamReader(recipe.openStream())), JsonElement.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonCraftingShaped json = (JsonCraftingShaped)new Gson().fromJson(rawJson, JsonCraftingShaped.class);
        Set rawKeys = rawJson.getAsJsonObject().getAsJsonObject("key").entrySet();
        String[] pattern = json.getPattern();
        Object[] keys = new Object[rawKeys.size() * 2 + pattern.length];
        for (int i = 0; i < pattern.length; ++i) {
            keys[i] = pattern[i];
        }
        for (Map.Entry key : rawKeys) {
            keys[i] = Character.valueOf(((String)key.getKey()).charAt(0));
            keys[i + 1] = ((JsonItemKey)new Gson().fromJson((JsonElement)key.getValue(), JsonItemKey.class)).get().map(Function.identity(), Function.identity());
            i += 2;
        }
        CraftingRegistry.addShapedRecipe(json.getResult().getItemStack(), keys);
    }

    private static void parseCraftingShapeless(URL recipe) {
        JsonCraftingShapeless json;
        try {
            json = (JsonCraftingShapeless)new Gson().fromJson((Reader)new BufferedReader(new InputStreamReader(recipe.openStream())), JsonCraftingShapeless.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonItemKey[] ingredients = json.getIngredients();
        Object[] stacks = new Object[json.getIngredients().length];
        for (int i = 0; i < ingredients.length; ++i) {
            stacks[i] = ingredients[i].get().map(Function.identity(), Function.identity());
        }
        try {
            CraftingRegistry.addShapelessRecipe(json.getResult().getItemStack(), stacks);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Recipe: " + String.valueOf(recipe), e);
        }
    }

    private static void parseSmelting(URL recipe) {
        JsonSmelting json;
        try {
            json = (JsonSmelting)new Gson().fromJson((Reader)new BufferedReader(new InputStreamReader(recipe.openStream())), JsonSmelting.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        json.getIngredient().get().ifLeft(item -> SmeltingRegistry.addSmeltingRecipe(item, json.getResult().getItemStack())).ifRight(tag -> SmeltingRegistry.addSmeltingRecipe((TagKey<class_124>)tag, json.getResult().getItemStack()));
    }
}

