/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.recipe;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.event.mod.PreInitEvent;
import net.modificationstation.stationapi.api.mod.entrypoint.Entrypoint;
import net.modificationstation.stationapi.api.mod.entrypoint.EventBusPolicy;
import net.modificationstation.stationapi.api.registry.JsonRecipesRegistry;
import net.modificationstation.stationapi.api.registry.Registry;
import net.modificationstation.stationapi.api.resource.Filters;
import net.modificationstation.stationapi.api.resource.ResourceHelper;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.exception.MissingModException;
import net.modificationstation.stationapi.impl.recipe.JsonRecipeType;

@Entrypoint(eventBus=@EventBusPolicy(registerInstance=false))
@EventListener(phase="stationapi:internal")
public class JsonRecipesLoader {
    @EventListener
    private static void loadJsonRecipes(PreInitEvent event) {
        StationAPI.LOGGER.info("Searching for JSON recipes...");
        String recipePath = String.valueOf(StationAPI.NAMESPACE) + "/recipes";
        ResourceHelper.DATA.find(recipePath, Filters.FileType.JSON).forEach(JsonRecipesLoader::registerRecipe);
        ResourceHelper.ASSETS.find(recipePath, Filters.FileType.JSON).forEach(recipe -> {
            StationAPI.LOGGER.warn("Found a recipe (" + String.valueOf(recipe) + ") under assets directory, which is deprecated for recipes!");
            JsonRecipesLoader.registerRecipe(recipe);
        });
    }

    private static void registerRecipe(URL recipe) {
        try {
            Identifier recipeId;
            String rawId = ((JsonRecipeType)new Gson().fromJson((Reader)new InputStreamReader(recipe.openStream()), JsonRecipeType.class)).getType();
            try {
                recipeId = Identifier.of((String)rawId);
            }
            catch (MissingModException e) {
                StationAPI.LOGGER.warn("Found an unknown recipe type " + rawId + ". Ignoring.");
                return;
            }
            if (!JsonRecipesRegistry.INSTANCE.containsId(recipeId)) {
                Registry.register((Registry)JsonRecipesRegistry.INSTANCE, (Identifier)recipeId, new HashSet());
            }
            Objects.requireNonNull((Set)JsonRecipesRegistry.INSTANCE.get(recipeId)).add(recipe);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

