/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.recipe;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_159;
import net.minecraft.class_160;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.recipe.StationRecipe;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.registry.RegistryEntry;
import net.modificationstation.stationapi.api.registry.RegistryEntryList;
import net.modificationstation.stationapi.api.tag.TagKey;

public class StationShapedRecipe
implements class_160,
StationRecipe {
    private static final Random RANDOM = new Random();
    private final int width;
    private final int height;
    private final Either<TagKey<class_124>, class_31>[] grid;
    private final class_31 output;

    public StationShapedRecipe(int width, int height, Either<TagKey<class_124>, class_31>[] grid, class_31 output) {
        this.width = width;
        this.height = height;
        this.grid = grid;
        this.output = output;
    }

    public boolean method_2072(class_159 grid) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.matches(grid, x, y, true)) {
                    return true;
                }
                if (!this.matches(grid, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(class_159 grid, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                boolean ignoreDamage;
                class_31 itemToTest;
                int dx = x - startX;
                int dy = y - startY;
                Either<TagKey<class_124>, class_31> ingredient = null;
                if (dx >= 0 && dy >= 0 && dx < this.width && dy < this.height) {
                    ingredient = this.grid[(mirror ? this.width - dx - 1 : dx) + dy * this.width];
                }
                if ((itemToTest = grid.method_974(x, y)) == null && ingredient == null) continue;
                if (itemToTest == null || ingredient == null) {
                    return false;
                }
                Optional tagOpt = ingredient.left();
                if (tagOpt.isPresent()) {
                    if (itemToTest.isIn((TagKey)tagOpt.get())) continue;
                    return false;
                }
                Optional itemOpt = ingredient.right();
                if (!itemOpt.isPresent()) continue;
                class_31 item = (class_31)itemOpt.get();
                boolean bl = ignoreDamage = item.method_722() == -1;
                if (ignoreDamage) {
                    item.method_710(itemToTest.method_722());
                }
                boolean equals = item.method_702(itemToTest);
                if (ignoreDamage) {
                    item.method_710(-1);
                }
                if (equals) continue;
                return false;
            }
        }
        return true;
    }

    public class_31 method_2074(class_159 arg) {
        return this.output.method_724();
    }

    public int method_2071() {
        return this.width * this.height;
    }

    public class_31 method_2073() {
        return this.output;
    }

    @Override
    public class_31[] getIngredients() {
        class_31[] stacks = new class_31[9];
        for (int h = 0; h < this.height; ++h) {
            for (int w = 0; w < this.width; ++w) {
                int localId = h * this.width + w;
                Either<TagKey<class_124>, class_31> ingredient = this.grid[localId];
                if (ingredient == null) continue;
                int id = h * 3 + w;
                stacks[id] = (class_31)ingredient.map(tag -> new class_31((class_124)((RegistryEntry)((RegistryEntryList.Named)ItemRegistry.INSTANCE.getEntryList(tag).orElseThrow(() -> new RuntimeException("Identifier ingredient \"" + String.valueOf(tag.id()) + "\" has no entry in the tag registry!"))).getRandom(RANDOM).orElseThrow()).value()), Function.identity());
            }
        }
        return stacks;
    }

    @Override
    public class_31[] getOutputs() {
        return new class_31[]{this.output};
    }
}

