/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.registry.sync;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_169;
import net.minecraft.class_54;
import net.minecraft.class_629;
import net.modificationstation.stationapi.api.StationAPI;
import net.modificationstation.stationapi.api.event.registry.RegistryAttribute;
import net.modificationstation.stationapi.api.event.registry.RegistryAttributeHolder;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.registry.Registries;
import net.modificationstation.stationapi.api.registry.Registry;
import net.modificationstation.stationapi.api.registry.RegistryKey;
import net.modificationstation.stationapi.api.registry.RemapException;
import net.modificationstation.stationapi.api.registry.RemappableRegistry;
import net.modificationstation.stationapi.api.util.Formatting;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.impl.network.packet.s2c.play.RemapClientRegistryS2CPacket;
import org.jetbrains.annotations.Nullable;

public final class RegistrySyncManager {
    public static final boolean DEBUG = Boolean.getBoolean("stationapi.registry.debug");
    private static final boolean DEBUG_WRITE_REGISTRY_DATA = Boolean.getBoolean("stationapi.registry.debug.writeContentsAsCsv");
    public static boolean postBootstrap = false;

    private RegistrySyncManager() {
    }

    @Environment(value=EnvType.SERVER)
    public static void configureClient(class_54 player) {
        Reference2ReferenceMap<Identifier, Reference2IntMap<Identifier>> map = RegistrySyncManager.createAndPopulateRegistryMap();
        if (map == null) {
            return;
        }
        PacketHelper.sendTo((class_54)player, (class_169)new RemapClientRegistryS2CPacket(map));
    }

    @Nullable
    @Environment(value=EnvType.SERVER)
    public static Reference2ReferenceMap<Identifier, Reference2IntMap<Identifier>> createAndPopulateRegistryMap() {
        Reference2ReferenceLinkedOpenHashMap map = new Reference2ReferenceLinkedOpenHashMap();
        for (Identifier registryId : Registries.REGISTRIES.getIds()) {
            Registry registry = (Registry)Registries.REGISTRIES.get(registryId);
            RegistrySyncManager.storeRegistry((Map<Identifier, Reference2IntMap<Identifier>>)map, registryId, registry);
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    @Environment(value=EnvType.SERVER)
    private static <T> void storeRegistry(Map<Identifier, Reference2IntMap<Identifier>> map, Identifier registryId, Registry<T> registry) {
        RegistryAttributeHolder attributeHolder;
        if (DEBUG_WRITE_REGISTRY_DATA) {
            File location = new File(".stationapi" + File.separatorChar + "debug" + File.separatorChar + "registry");
            boolean c = true;
            if (!location.exists() && !location.mkdirs()) {
                StationAPI.LOGGER.warn("[station-registry-api debug] Could not create " + location.getAbsolutePath() + " directory!");
                c = false;
            }
            if (c && registry != null) {
                File file = new File(location, registryId.toString().replace(':', '.').replace('/', '.') + ".csv");
                try (FileOutputStream stream = new FileOutputStream(file);){
                    StringBuilder builder = new StringBuilder("Raw ID,String ID,Class Type\n");
                    for (Object o : registry) {
                        String classType = o == null ? "null" : o.getClass().getName();
                        Identifier id = registry.getId(o);
                        if (id == null) continue;
                        int rawId = registry.getRawId(o);
                        String stringId = id.toString();
                        builder.append("\"").append(rawId).append("\",\"").append(stringId).append("\",\"").append(classType).append("\"\n");
                    }
                    stream.write(builder.toString().getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException e) {
                    StationAPI.LOGGER.warn("[station-registry-api debug] Could not write to " + file.getAbsolutePath() + "!", (Throwable)e);
                }
            }
        }
        if (!(attributeHolder = RegistryAttributeHolder.get((RegistryKey)registry.getKey())).hasAttribute(RegistryAttribute.SYNCED)) {
            StationAPI.LOGGER.debug("Not syncing registry: {}", (Object)registryId);
            return;
        }
        if (!attributeHolder.hasAttribute(RegistryAttribute.MODDED)) {
            StationAPI.LOGGER.debug("Skipping un-modded registry: " + String.valueOf(registryId));
            return;
        }
        StationAPI.LOGGER.debug("Syncing registry: " + String.valueOf(registryId));
        if (registry instanceof RemappableRegistry) {
            Reference2IntLinkedOpenHashMap idMap = new Reference2IntLinkedOpenHashMap();
            IntOpenHashSet rawIdsFound = DEBUG ? new IntOpenHashSet() : null;
            for (Object o : registry) {
                Identifier id = registry.getId(o);
                if (id == null) continue;
                int rawId = registry.getRawId(o);
                if (DEBUG) {
                    if (registry.get(id) != o) {
                        StationAPI.LOGGER.error("[station-registry-api] Inconsistency detected in " + String.valueOf(registryId) + ": object " + String.valueOf(o) + " -> string ID " + String.valueOf(id) + " -> object " + String.valueOf(registry.get(id)) + "!");
                    }
                    if (registry.get(rawId) != o) {
                        StationAPI.LOGGER.error("[station-registry-api] Inconsistency detected in " + String.valueOf(registryId) + ": object " + String.valueOf(o) + " -> integer ID " + rawId + " -> object " + String.valueOf(registry.get(rawId)) + "!");
                    }
                    if (!rawIdsFound.add(rawId)) {
                        StationAPI.LOGGER.error("[station-registry-api] Inconsistency detected in " + String.valueOf(registryId) + ": multiple objects hold the raw ID " + rawId + " (this one is " + String.valueOf(id) + ")");
                    }
                }
                idMap.put((Object)id, rawId);
            }
            map.put(registryId, (Reference2IntMap<Identifier>)idMap);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void apply(Map<Identifier, Reference2IntMap<Identifier>> map, RemappableRegistry.RemapMode mode) throws RemapException {
        if (mode == RemappableRegistry.RemapMode.REMOTE) {
            RegistrySyncManager.checkRemoteRemap(map);
        }
        HashSet containedRegistries = Sets.newHashSet(map.keySet());
        for (Identifier registryId : Registries.REGISTRIES.getIds()) {
            if (!containedRegistries.remove(registryId)) continue;
            Reference2IntMap<Identifier> registryMap = map.get(registryId);
            Registry registry = (Registry)Registries.REGISTRIES.get(registryId);
            RegistryAttributeHolder attributeHolder = RegistryAttributeHolder.get((RegistryKey)registry.getKey());
            if (!attributeHolder.hasAttribute(RegistryAttribute.MODDED)) {
                StationAPI.LOGGER.debug("Not applying registry data to vanilla registry {}", (Object)registryId.toString());
                continue;
            }
            if (!(registry instanceof RemappableRegistry)) continue;
            Reference2IntOpenHashMap idMap = new Reference2IntOpenHashMap();
            for (Identifier key : registryMap.keySet()) {
                idMap.put((Object)key, registryMap.getInt((Object)key));
            }
            ((RemappableRegistry)registry).remap(registryId.toString(), (Reference2IntMap)idMap, mode);
        }
        if (!containedRegistries.isEmpty()) {
            StationAPI.LOGGER.warn("[station-registry-api] Could not find the following registries: " + Joiner.on((String)", ").join((Iterable)containedRegistries));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void checkRemoteRemap(Map<Identifier, Reference2IntMap<Identifier>> map) throws RemapException {
        HashMap<Identifier, List> missingEntries = new HashMap<Identifier, List>();
        for (Map.Entry entry : Registries.REGISTRIES.getEntrySet()) {
            Registry registry = (Registry)entry.getValue();
            Identifier registryId = ((RegistryKey)entry.getKey()).getValue();
            Reference2IntMap<Identifier> remoteRegistry = map.get(registryId);
            if (remoteRegistry == null) continue;
            for (Identifier remoteId : remoteRegistry.keySet()) {
                if (registry.containsId(remoteId)) continue;
                missingEntries.computeIfAbsent(registryId, i -> new ArrayList()).add(remoteId);
            }
        }
        if (missingEntries.isEmpty()) {
            return;
        }
        StationAPI.LOGGER.error("Received unknown remote registry entries from server");
        for (Map.Entry entry : missingEntries.entrySet()) {
            for (Identifier identifier : (List)entry.getValue()) {
                StationAPI.LOGGER.error("Registry entry ({}) is missing from local registry ({})", (Object)identifier, entry.getKey());
            }
        }
        StringBuilder text = new StringBuilder();
        int n = missingEntries.values().stream().mapToInt(List::size).sum();
        if (n == 1) {
            text.append(class_629.method_2049((String)"station-registry-api-v0.unknown-remote.title.singular"));
        } else {
            text.append(class_629.method_2050((String)"station-registry-api-v0.unknown-remote.title.plural", (Object[])new Object[]{n}));
        }
        text.append(Formatting.GREEN).append(class_629.method_2049((String)"station-registry-api-v0.unknown-remote.subtitle.1"));
        text.append(class_629.method_2049((String)"station-registry-api-v0.unknown-remote.subtitle.2"));
        int toDisplay = 4;
        List<String> namespaces = missingEntries.values().stream().flatMap(Collection::stream).map(id -> id.namespace.toString()).distinct().sorted().toList();
        for (int i2 = 0; i2 < Math.min(namespaces.size(), 4); ++i2) {
            text.append(Formatting.YELLOW).append(namespaces.get(i2));
            text.append("\n");
        }
        if (namespaces.size() > 4) {
            text.append(class_629.method_2050((String)"station-registry-api-v0.unknown-remote.footer", (Object[])new Object[]{namespaces.size() - 4}));
        }
        throw new RemapException(text.toString());
    }

    @Environment(value=EnvType.CLIENT)
    public static void unmap() throws RemapException {
        for (Identifier registryId : Registries.REGISTRIES.getIds()) {
            Registry registry = (Registry)Registries.REGISTRIES.get(registryId);
            if (!(registry instanceof RemappableRegistry)) continue;
            RemappableRegistry remappableRegistry = (RemappableRegistry)registry;
            remappableRegistry.unmap(registryId.toString());
        }
    }

    public static void bootstrapRegistries() {
        postBootstrap = true;
    }
}

