/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.client.arsenic;

import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ArsenicMixinConfigPlugin
implements IMixinConfigPlugin {
    private static final String JSON_KEY_DISABLE_ARSENIC = "station-renderer-api-v0:contains_renderer";
    private static final String JSON_KEY_FORCE_COMPATIBILITY = "station-renderer-arsenic:force_compatibility";
    private static boolean needsLoad = true;
    private static boolean arsenicApplicable = true;
    private static boolean forceCompatibility = false;

    private static void loadIfNeeded() {
        if (needsLoad) {
            for (ModContainer container : FabricLoader.getInstance().getAllMods()) {
                ModMetadata meta = container.getMetadata();
                if (meta.containsCustomValue(JSON_KEY_DISABLE_ARSENIC)) {
                    arsenicApplicable = false;
                    continue;
                }
                if (!meta.containsCustomValue(JSON_KEY_FORCE_COMPATIBILITY)) continue;
                forceCompatibility = true;
            }
            needsLoad = false;
        }
    }

    static boolean shouldApplyArsenic() {
        ArsenicMixinConfigPlugin.loadIfNeeded();
        return arsenicApplicable;
    }

    static boolean shouldForceCompatibility() {
        ArsenicMixinConfigPlugin.loadIfNeeded();
        return forceCompatibility;
    }

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return ArsenicMixinConfigPlugin.shouldApplyArsenic();
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

