/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.client.arsenic.renderer;

import com.google.common.base.Suppliers;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.modificationstation.stationapi.api.client.render.Renderer;
import net.modificationstation.stationapi.api.client.render.material.MaterialFinder;
import net.modificationstation.stationapi.api.client.render.material.RenderMaterial;
import net.modificationstation.stationapi.api.client.render.mesh.MeshBuilder;
import net.modificationstation.stationapi.api.client.render.model.BakedModelRenderer;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.RenderMaterialImpl;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.mesh.MeshBuilderImpl;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.render.BakedModelRendererImpl;

public final class ArsenicRenderer
implements Renderer {
    public static final ArsenicRenderer INSTANCE = new ArsenicRenderer();
    public static final RenderMaterialImpl.Value MATERIAL_STANDARD = (RenderMaterialImpl.Value)INSTANCE.materialFinder().find();
    private final Map<Identifier, RenderMaterial> materialMap = new IdentityHashMap<Identifier, RenderMaterial>();
    private final Supplier<BakedModelRenderer> bakedModelRenderer = Suppliers.memoize(BakedModelRendererImpl::new);

    public MeshBuilder meshBuilder() {
        return new MeshBuilderImpl();
    }

    public MaterialFinder materialFinder() {
        return new RenderMaterialImpl.Finder();
    }

    public RenderMaterial materialById(Identifier id) {
        return this.materialMap.get(id);
    }

    public boolean registerMaterial(Identifier id, RenderMaterial material) {
        if (this.materialMap.containsKey(id)) {
            return false;
        }
        this.materialMap.put(id, material);
        return true;
    }

    public BakedModelRenderer bakedModelRenderer() {
        return this.bakedModelRenderer.get();
    }

    private ArsenicRenderer() {
    }

    static {
        INSTANCE.registerMaterial(RenderMaterial.MATERIAL_STANDARD, MATERIAL_STANDARD);
    }
}

