/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.client.arsenic.renderer.aocalc;

import java.util.Arrays;
import net.minecraft.class_14;
import net.minecraft.class_17;
import net.minecraft.class_189;
import net.modificationstation.stationapi.api.client.render.model.BakedQuad;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.util.math.MathHelper;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.mesh.MutableQuadViewImpl;

public final class LightingCalculatorImpl {
    private static final float[] FULL_BRIGHTNESS = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private final int cacheRadius;
    private final int cacheDiameter;
    private final int cacheSelf;
    private class_17 block;
    private class_14 blockView;
    private int x;
    private int y;
    private int z;
    private boolean ao;
    private static final int UNCACHED_ID = -1;
    private final int[] emptyIdCache;
    private final int[] idCache;
    private final float[] emptyLightCache;
    private final float[] lightCache;
    public final float[] light = new float[4];

    public LightingCalculatorImpl(int radius) {
        this.cacheRadius = radius;
        this.cacheDiameter = this.cacheRadius * 2 + 1;
        int cacheSize = (int)Math.pow(this.cacheDiameter, 3.0);
        this.cacheSelf = cacheSize / 2;
        this.emptyIdCache = new int[cacheSize];
        this.idCache = new int[cacheSize];
        this.emptyLightCache = new float[cacheSize];
        this.lightCache = new float[cacheSize];
        Arrays.fill(this.emptyIdCache, -1);
        Arrays.fill(this.emptyLightCache, Float.NaN);
    }

    public void initialize(class_17 block, class_14 blockView, int x, int y, int z, boolean ao) {
        this.block = block;
        this.blockView = blockView;
        this.x = x;
        this.y = y;
        this.z = z;
        this.ao = ao;
        System.arraycopy(this.emptyIdCache, 0, this.idCache, 0, this.idCache.length);
        System.arraycopy(this.emptyLightCache, 0, this.lightCache, 0, this.lightCache.length);
    }

    private int id(int x, int y, int z) {
        int index = this.toIndex(x - this.x, y - this.y, z - this.z);
        int id = this.idCache[index];
        return id == -1 ? (this.idCache[index] = index == this.cacheSelf ? this.block.field_1915 : this.blockView.method_1776(x, y, z)) : id;
    }

    private float light(int x, int y, int z) {
        int index = this.toIndex(x - this.x, y - this.y, z - this.z);
        float brightness = this.lightCache[index];
        return Float.isNaN(brightness) ? this.block.method_1604(this.blockView, x, y, z) : brightness;
    }

    private int toIndex(int x, int y, int z) {
        return ((x + this.cacheRadius) * this.cacheDiameter + y + this.cacheRadius) * this.cacheDiameter + z + this.cacheRadius;
    }

    public void calculateForQuad(BakedQuad q) {
        float emission = q.getEmission();
        if (emission == 1.0f) {
            System.arraycopy(FULL_BRIGHTNESS, 0, this.light, 0, this.light.length);
            return;
        }
        Direction face = q.getFace();
        this.calculateForQuad(face, (float)this.x + Float.intBitsToFloat(q.getVertexData()[0]), (float)this.y + Float.intBitsToFloat(q.getVertexData()[1]), (float)this.z + Float.intBitsToFloat(q.getVertexData()[2]), (float)this.x + Float.intBitsToFloat(q.getVertexData()[8]), (float)this.y + Float.intBitsToFloat(q.getVertexData()[9]), (float)this.z + Float.intBitsToFloat(q.getVertexData()[10]), (float)this.x + Float.intBitsToFloat(q.getVertexData()[16]), (float)this.y + Float.intBitsToFloat(q.getVertexData()[17]), (float)this.z + Float.intBitsToFloat(q.getVertexData()[18]), (float)this.x + Float.intBitsToFloat(q.getVertexData()[24]), (float)this.y + Float.intBitsToFloat(q.getVertexData()[25]), (float)this.z + Float.intBitsToFloat(q.getVertexData()[26]), q.hasShade());
        if (emission == 0.0f) {
            return;
        }
        this.light[0] = MathHelper.lerp((double)emission, (float)this.light[0], (float)1.0f);
        this.light[1] = MathHelper.lerp((double)emission, (float)this.light[1], (float)1.0f);
        this.light[2] = MathHelper.lerp((double)emission, (float)this.light[2], (float)1.0f);
        this.light[3] = MathHelper.lerp((double)emission, (float)this.light[3], (float)1.0f);
    }

    public void calculateForQuad(MutableQuadViewImpl q) {
        this.calculateForQuad(q.lightFace(), (float)this.x + q.x(0), (float)this.y + q.y(0), (float)this.z + q.z(0), (float)this.x + q.x(1), (float)this.y + q.y(1), (float)this.z + q.z(1), (float)this.x + q.x(2), (float)this.y + q.y(2), (float)this.z + q.z(2), (float)this.x + q.x(3), (float)this.y + q.y(3), (float)this.z + q.z(3), q.hasShade());
    }

    private void calculateForQuad(Direction face, double v00x, double v00y, double v00z, double v01x, double v01y, double v01z, double v11x, double v11y, double v11z, double v10x, double v10y, double v10z, boolean shade) {
        if (this.ao) {
            this.quadSmooth(face, v00x, v00y, v00z, v01x, v01y, v01z, v11x, v11y, v11z, v10x, v10y, v10z);
        } else {
            this.quadFast(face, v00x, v00y, v00z, v01x, v01y, v01z, v11x, v11y, v11z, v10x, v10y, v10z);
        }
        if (shade) {
            this.shadeFace(face);
        }
    }

    private void quadSmooth(Direction face, double v00x, double v00y, double v00z, double v01x, double v01y, double v01z, double v11x, double v11y, double v11z, double v10x, double v10y, double v10z) {
        int v00x0 = class_189.method_645((double)(v00x - 0.5));
        int v00y0 = class_189.method_645((double)(v00y - 0.5));
        int v00z0 = class_189.method_645((double)(v00z - 0.5));
        int v01x0 = class_189.method_645((double)(v01x - 0.5));
        int v01y0 = class_189.method_645((double)(v01y - 0.5));
        int v01z0 = class_189.method_645((double)(v01z - 0.5));
        int v11x0 = class_189.method_645((double)(v11x - 0.5));
        int v11y0 = class_189.method_645((double)(v11y - 0.5));
        int v11z0 = class_189.method_645((double)(v11z - 0.5));
        int v10x0 = class_189.method_645((double)(v10x - 0.5));
        int v10y0 = class_189.method_645((double)(v10y - 0.5));
        int v10z0 = class_189.method_645((double)(v10z - 0.5));
        int v00x1 = v00x0 + 1;
        int v00y1 = v00y0 + 1;
        int v00z1 = v00z0 + 1;
        int v01x1 = v01x0 + 1;
        int v01y1 = v01y0 + 1;
        int v01z1 = v01z0 + 1;
        int v11x1 = v11x0 + 1;
        int v11y1 = v11y0 + 1;
        int v11z1 = v11z0 + 1;
        int v10x1 = v10x0 + 1;
        int v10y1 = v10y0 + 1;
        int v10z1 = v10z0 + 1;
        double v00dx = v00x - (double)v00x0;
        double v00dy = v00y - (double)v00y0;
        double v00dz = v00z - (double)v00z0;
        double v01dx = v01x - (double)v01x0;
        double v01dy = v01y - (double)v01y0;
        double v01dz = v01z - (double)v01z0;
        double v11dx = v11x - (double)v11x0;
        double v11dy = v11y - (double)v11y0;
        double v11dz = v11z - (double)v11z0;
        double v10dx = v10x - (double)v10x0;
        double v10dy = v10y - (double)v10y0;
        double v10dz = v10z - (double)v10z0;
        block0 : switch (face.getAxis()) {
            case X: {
                v00dy = v00dy < 0.5 ? v00dy + 0.5 : v00dy - 0.5;
                v00dz = v00dz < 0.5 ? v00dz + 0.5 : v00dz - 0.5;
                v01dy = v01dy < 0.5 ? v01dy + 0.5 : v01dy - 0.5;
                v01dz = v01dz < 0.5 ? v01dz + 0.5 : v01dz - 0.5;
                v11dy = v11dy < 0.5 ? v11dy + 0.5 : v11dy - 0.5;
                v11dz = v11dz < 0.5 ? v11dz + 0.5 : v11dz - 0.5;
                v10dy = v10dy < 0.5 ? v10dy + 0.5 : v10dy - 0.5;
                v10dz = v10dz < 0.5 ? v10dz + 0.5 : v10dz - 0.5;
                switch (face.getDirection()) {
                    case POSITIVE: {
                        this.light[0] = MathHelper.interpolate3D((double)v00dx, (double)v00dy, (double)v00dz, (float)this.light(v00x0, v00y0, v00z0), (float)this.light(v00x1, v00y0, v00z0), (float)this.light(v00x0, v00y1, v00z0), (float)this.light(v00x1, v00y1, v00z0), (float)this.light(v00x0, class_17.field_1942[this.id(v00x0, v00y0, v00z0)] || class_17.field_1942[this.id(v00x0, v00y1, v00z1)] ? v00y0 : v00y1, v00z1), (float)this.light(v00x1, class_17.field_1942[this.id(v00x1, v00y0, v00z0)] || class_17.field_1942[this.id(v00x1, v00y1, v00z1)] ? v00y0 : v00y1, v00z1), (float)this.light(v00x0, v00y1, v00z1), (float)this.light(v00x1, v00y1, v00z1));
                        this.light[1] = MathHelper.interpolate3D((double)v01dx, (double)v01dy, (double)v01dz, (float)this.light(v01x0, class_17.field_1942[this.id(v01x0, v01y0, v01z1)] || class_17.field_1942[this.id(v01x0, v01y1, v01z0)] ? v01y0 : v01y1, v01z0), (float)this.light(v01x1, class_17.field_1942[this.id(v01x1, v01y0, v01z1)] || class_17.field_1942[this.id(v01x1, v01y1, v01z0)] ? v01y0 : v01y1, v01z0), (float)this.light(v01x0, v01y1, v01z0), (float)this.light(v01x1, v01y1, v01z0), (float)this.light(v01x0, v01y0, v01z1), (float)this.light(v01x1, v01y0, v01z1), (float)this.light(v01x0, v01y1, v01z1), (float)this.light(v01x1, v01y1, v01z1));
                        this.light[2] = MathHelper.interpolate3D((double)v11dx, (double)v11dy, (double)v11dz, (float)this.light(v11x0, v11y0, v11z0), (float)this.light(v11x1, v11y0, v11z0), (float)this.light(v11x0, class_17.field_1942[this.id(v11x0, v11y1, v11z1)] || class_17.field_1942[this.id(v11x0, v11y0, v11z0)] ? v11y1 : v11y0, v11z0), (float)this.light(v11x1, class_17.field_1942[this.id(v11x1, v11y1, v11z1)] || class_17.field_1942[this.id(v11x1, v11y0, v11z0)] ? v11y1 : v11y0, v11z0), (float)this.light(v11x0, v11y0, v11z1), (float)this.light(v11x1, v11y0, v11z1), (float)this.light(v11x0, v11y1, v11z1), (float)this.light(v11x1, v11y1, v11z1));
                        this.light[3] = MathHelper.interpolate3D((double)v10dx, (double)v10dy, (double)v10dz, (float)this.light(v10x0, v10y0, v10z0), (float)this.light(v10x1, v10y0, v10z0), (float)this.light(v10x0, v10y1, v10z0), (float)this.light(v10x1, v10y1, v10z0), (float)this.light(v10x0, v10y0, v10z1), (float)this.light(v10x1, v10y0, v10z1), (float)this.light(v10x0, class_17.field_1942[this.id(v10x0, v10y1, v10z0)] || class_17.field_1942[this.id(v10x0, v10y0, v10z1)] ? v10y1 : v10y0, v10z1), (float)this.light(v10x1, class_17.field_1942[this.id(v10x1, v10y1, v10z0)] || class_17.field_1942[this.id(v10x1, v10y0, v10z1)] ? v10y1 : v10y0, v10z1));
                        break;
                    }
                    case NEGATIVE: {
                        --v00x0;
                        --v00x1;
                        --v01x0;
                        --v01x1;
                        this.light[0] = MathHelper.interpolate3D((double)v00dx, (double)v00dy, (double)v00dz, (float)this.light(v00x0, v00y0, v00z0), (float)this.light(v00x1, v00y0, v00z0), (float)this.light(v00x0, v00y1, v00z0), (float)this.light(v00x1, v00y1, v00z0), (float)this.light(v00x0, v00y0, v00z1), (float)this.light(v00x1, v00y0, v00z1), (float)this.light(v00x0, class_17.field_1942[this.id(v00x0, v00y0, v00z1)] || class_17.field_1942[this.id(v00x0, v00y1, v00z0)] ? v00y1 : v00y0, v00z1), (float)this.light(v00x1, class_17.field_1942[this.id(v00x1, v00y0, v00z1)] || class_17.field_1942[this.id(v00x1, v00y1, v00z0)] ? v00y1 : v00y0, v00z1));
                        this.light[1] = MathHelper.interpolate3D((double)v01dx, (double)v01dy, (double)v01dz, (float)this.light(v01x0, v01y0, v01z0), (float)this.light(v01x1, v01y0, v01z0), (float)this.light(v01x0, class_17.field_1942[this.id(v01x0, v01y0, v01z0)] || class_17.field_1942[this.id(v01x0, v01y1, v01z1)] ? v01y1 : v01y0, v01z0), (float)this.light(v01x1, class_17.field_1942[this.id(v01x1, v01y0, v01z0)] || class_17.field_1942[this.id(v01x1, v01y1, v01z1)] ? v01y1 : v01y0, v01z0), (float)this.light(v01x0, v01y0, v01z1), (float)this.light(v01x1, v01y0, v01z1), (float)this.light(v01x0, v01y1, v01z1), (float)this.light(v01x1, v01y1, v01z1));
                        this.light[2] = MathHelper.interpolate3D((double)v11dx, (double)v11dy, (double)v11dz, (float)this.light(v11x0, class_17.field_1942[this.id(v11x0, v11y1, v11z0)] || class_17.field_1942[this.id(v11x0, v11y0, v11z1)] ? v11y0 : v11y1, v11z0), (float)this.light(--v11x1, class_17.field_1942[this.id(v11x1, v11y1, v11z0)] || class_17.field_1942[this.id(v11x1, v11y0, v11z1)] ? v11y0 : v11y1, v11z0), (float)this.light(--v11x0, v11y1, v11z0), (float)this.light(v11x1, v11y1, v11z0), (float)this.light(v11x0, v11y0, v11z1), (float)this.light(v11x1, v11y0, v11z1), (float)this.light(v11x0, v11y1, v11z1), (float)this.light(v11x1, v11y1, v11z1));
                        this.light[3] = MathHelper.interpolate3D((double)v10dx, (double)v10dy, (double)v10dz, (float)this.light(--v10x0, v10y0, v10z0), (float)this.light(--v10x1, v10y0, v10z0), (float)this.light(v10x0, v10y1, v10z0), (float)this.light(v10x1, v10y1, v10z0), (float)this.light(v10x0, class_17.field_1942[this.id(v10x0, v10y1, v10z1)] || class_17.field_1942[this.id(v10x0, v10y0, v10z0)] ? v10y0 : v10y1, v10z1), (float)this.light(v10x1, class_17.field_1942[this.id(v10x1, v10y1, v10z1)] || class_17.field_1942[this.id(v10x1, v10y0, v10z0)] ? v10y0 : v10y1, v10z1), (float)this.light(v10x0, v10y1, v10z1), (float)this.light(v10x1, v10y1, v10z1));
                    }
                }
                break;
            }
            case Y: {
                v00dx = v00dx < 0.5 ? v00dx + 0.5 : v00dx - 0.5;
                v00dz = v00dz < 0.5 ? v00dz + 0.5 : v00dz - 0.5;
                v01dx = v01dx < 0.5 ? v01dx + 0.5 : v01dx - 0.5;
                v01dz = v01dz < 0.5 ? v01dz + 0.5 : v01dz - 0.5;
                v11dx = v11dx < 0.5 ? v11dx + 0.5 : v11dx - 0.5;
                v11dz = v11dz < 0.5 ? v11dz + 0.5 : v11dz - 0.5;
                v10dx = v10dx < 0.5 ? v10dx + 0.5 : v10dx - 0.5;
                v10dz = v10dz < 0.5 ? v10dz + 0.5 : v10dz - 0.5;
                switch (face.getDirection()) {
                    case POSITIVE: {
                        this.light[0] = MathHelper.interpolate3D((double)v00dx, (double)v00dy, (double)v00dz, (float)this.light(v00x0, v00y0, v00z0), (float)this.light(v00x1, v00y0, v00z0), (float)this.light(v00x0, v00y1, v00z0), (float)this.light(v00x1, v00y1, v00z0), (float)this.light(v00x0, v00y0, v00z1), (float)this.light(v00x1, v00y0, class_17.field_1942[this.id(v00x0, v00y0, v00z1)] || class_17.field_1942[this.id(v00x1, v00y0, v00z0)] ? v00z1 : v00z0), (float)this.light(v00x0, v00y1, v00z1), (float)this.light(v00x1, v00y1, class_17.field_1942[this.id(v00x0, v00y1, v00z1)] || class_17.field_1942[this.id(v00x1, v00y1, v00z0)] ? v00z1 : v00z0));
                        this.light[1] = MathHelper.interpolate3D((double)v01dx, (double)v01dy, (double)v01dz, (float)this.light(v01x0, v01y0, v01z0), (float)this.light(v01x1, v01y0, class_17.field_1942[this.id(v01x0, v01y0, v01z0)] || class_17.field_1942[this.id(v01x1, v01y0, v01z1)] ? v01z0 : v01z1), (float)this.light(v01x0, v01y1, v01z0), (float)this.light(v01x1, v01y1, class_17.field_1942[this.id(v01x0, v01y1, v01z0)] || class_17.field_1942[this.id(v01x1, v01y1, v01z1)] ? v01z0 : v01z1), (float)this.light(v01x0, v01y0, v01z1), (float)this.light(v01x1, v01y0, v01z1), (float)this.light(v01x0, v01y1, v01z1), (float)this.light(v01x1, v01y1, v01z1));
                        this.light[2] = MathHelper.interpolate3D((double)v11dx, (double)v11dy, (double)v11dz, (float)this.light(v11x0, v11y0, class_17.field_1942[this.id(v11x1, v11y0, v11z0)] || class_17.field_1942[this.id(v11x0, v11y0, v11z1)] ? v11z0 : v11z1), (float)this.light(v11x1, v11y0, v11z0), (float)this.light(v11x0, v11y1, class_17.field_1942[this.id(v11x1, v11y1, v11z0)] || class_17.field_1942[this.id(v11x0, v11y1, v11z1)] ? v11z0 : v11z1), (float)this.light(v11x1, v11y1, v11z0), (float)this.light(v11x0, v11y0, v11z1), (float)this.light(v11x1, v11y0, v11z1), (float)this.light(v11x0, v11y1, v11z1), (float)this.light(v11x1, v11y1, v11z1));
                        this.light[3] = MathHelper.interpolate3D((double)v10dx, (double)v10dy, (double)v10dz, (float)this.light(v10x0, v10y0, v10z0), (float)this.light(v10x1, v10y0, v10z0), (float)this.light(v10x0, v10y1, v10z0), (float)this.light(v10x1, v10y1, v10z0), (float)this.light(v10x0, v10y0, class_17.field_1942[this.id(v10x1, v10y0, v10z1)] || class_17.field_1942[this.id(v10x0, v10y0, v10z0)] ? v10z1 : v10z0), (float)this.light(v10x1, v10y0, v10z1), (float)this.light(v10x0, v10y1, class_17.field_1942[this.id(v10x1, v10y1, v10z1)] || class_17.field_1942[this.id(v10x0, v10y1, v10z0)] ? v10z1 : v10z0), (float)this.light(v10x1, v10y1, v10z1));
                        break;
                    }
                    case NEGATIVE: {
                        --v00y0;
                        --v00y1;
                        --v01y0;
                        --v01y1;
                        this.light[0] = MathHelper.interpolate3D((double)v00dx, (double)v00dy, (double)v00dz, (float)this.light(v00x0, v00y0, v00z0), (float)this.light(v00x1, v00y0, v00z0), (float)this.light(v00x0, v00y1, v00z0), (float)this.light(v00x1, v00y1, v00z0), (float)this.light(v00x0, v00y0, class_17.field_1942[this.id(v00x1, v00y0, v00z1)] || class_17.field_1942[this.id(v00x0, v00y0, v00z0)] ? v00z1 : v00z0), (float)this.light(v00x1, v00y0, v00z1), (float)this.light(v00x0, v00y1, class_17.field_1942[this.id(v00x1, v00y1, v00z1)] || class_17.field_1942[this.id(v00x0, v00y1, v00z0)] ? v00z1 : v00z0), (float)this.light(v00x1, v00y1, v00z1));
                        this.light[1] = MathHelper.interpolate3D((double)v01dx, (double)v01dy, (double)v01dz, (float)this.light(v01x0, v01y0, class_17.field_1942[this.id(v01x1, v01y0, v01z0)] || class_17.field_1942[this.id(v01x0, v01y0, v01z1)] ? v01z0 : v01z1), (float)this.light(v01x1, v01y0, v01z0), (float)this.light(v01x0, v01y1, class_17.field_1942[this.id(v01x1, v01y1, v01z0)] || class_17.field_1942[this.id(v01x0, v01y1, v01z1)] ? v01z0 : v01z1), (float)this.light(v01x1, v01y1, v01z0), (float)this.light(v01x0, v01y0, v01z1), (float)this.light(v01x1, v01y0, v01z1), (float)this.light(v01x0, v01y1, v01z1), (float)this.light(v01x1, v01y1, v01z1));
                        this.light[2] = MathHelper.interpolate3D((double)v11dx, (double)v11dy, (double)v11dz, (float)this.light(v11x0, v11y0, v11z0), (float)this.light(v11x1, v11y0, class_17.field_1942[this.id(v11x0, v11y0, v11z0)] || class_17.field_1942[this.id(v11x1, v11y0, v11z1)] ? v11z0 : v11z1), (float)this.light(v11x0, --v11y1, v11z0), (float)this.light(v11x1, v11y1, class_17.field_1942[this.id(v11x0, v11y1, v11z0)] || class_17.field_1942[this.id(v11x1, v11y1, v11z1)] ? v11z0 : v11z1), (float)this.light(v11x0, --v11y0, v11z1), (float)this.light(v11x1, v11y0, v11z1), (float)this.light(v11x0, v11y1, v11z1), (float)this.light(v11x1, v11y1, v11z1));
                        this.light[3] = MathHelper.interpolate3D((double)v10dx, (double)v10dy, (double)v10dz, (float)this.light(v10x0, --v10y0, v10z0), (float)this.light(v10x1, v10y0, v10z0), (float)this.light(v10x0, --v10y1, v10z0), (float)this.light(v10x1, v10y1, v10z0), (float)this.light(v10x0, v10y0, v10z1), (float)this.light(v10x1, v10y0, class_17.field_1942[this.id(v10x0, v10y0, v10z1)] || class_17.field_1942[this.id(v10x1, v10y0, v10z0)] ? v10z1 : v10z0), (float)this.light(v10x0, v10y1, v10z1), (float)this.light(v10x1, v10y1, class_17.field_1942[this.id(v10x0, v10y1, v10z1)] || class_17.field_1942[this.id(v10x1, v10y1, v10z0)] ? v10z1 : v10z0));
                    }
                }
                break;
            }
            case Z: {
                v00dx = v00dx < 0.5 ? v00dx + 0.5 : v00dx - 0.5;
                v00dy = v00dy < 0.5 ? v00dy + 0.5 : v00dy - 0.5;
                v01dx = v01dx < 0.5 ? v01dx + 0.5 : v01dx - 0.5;
                v01dy = v01dy < 0.5 ? v01dy + 0.5 : v01dy - 0.5;
                v11dx = v11dx < 0.5 ? v11dx + 0.5 : v11dx - 0.5;
                v11dy = v11dy < 0.5 ? v11dy + 0.5 : v11dy - 0.5;
                v10dx = v10dx < 0.5 ? v10dx + 0.5 : v10dx - 0.5;
                v10dy = v10dy < 0.5 ? v10dy + 0.5 : v10dy - 0.5;
                switch (face.getDirection()) {
                    case POSITIVE: {
                        this.light[0] = MathHelper.interpolate3D((double)v00dx, (double)v00dy, (double)v00dz, (float)this.light(v00x0, v00y0, v00z0), (float)this.light(v00x1, v00y0, v00z0), (float)this.light(v00x0, class_17.field_1942[this.id(v00x0, v00y0, v00z0)] || class_17.field_1942[this.id(v00x1, v00y1, v00z0)] ? v00y1 : v00y0, v00z0), (float)this.light(v00x1, v00y1, v00z0), (float)this.light(v00x0, v00y0, v00z1), (float)this.light(v00x1, v00y0, v00z1), (float)this.light(v00x0, class_17.field_1942[this.id(v00x0, v00y0, v00z1)] || class_17.field_1942[this.id(v00x1, v00y1, v00z1)] ? v00y1 : v00y0, v00z1), (float)this.light(v00x1, v00y1, v00z1));
                        this.light[1] = MathHelper.interpolate3D((double)v01dx, (double)v01dy, (double)v01dz, (float)this.light(v01x0, v01y0, v01z0), (float)this.light(v01x1, v01y0, v01z0), (float)this.light(v01x0, class_17.field_1942[this.id(v01x0, v01y0, v01z0)] || class_17.field_1942[this.id(v01x1, v01y1, v01z0)] ? v01y1 : v01y0, v01z0), (float)this.light(v01x1, v01y1, v01z0), (float)this.light(v01x0, v01y0, v01z1), (float)this.light(v01x1, v01y0, v01z1), (float)this.light(v01x0, class_17.field_1942[this.id(v01x0, v01y0, v01z1)] || class_17.field_1942[this.id(v01x1, v01y1, v01z1)] ? v01y1 : v01y0, v01z1), (float)this.light(v01x1, v01y1, v01z1));
                        this.light[2] = MathHelper.interpolate3D((double)v11dx, (double)v11dy, (double)v11dz, (float)this.light(v11x0, v11y0, v11z0), (float)this.light(v11x1, class_17.field_1942[this.id(v11x1, v11y1, v11z0)] || class_17.field_1942[this.id(v11x0, v11y0, v11z0)] ? v11y0 : v11y1, v11z0), (float)this.light(v11x0, v11y1, v11z0), (float)this.light(v11x1, v11y1, v11z0), (float)this.light(v11x0, v11y0, v11z1), (float)this.light(v11x1, class_17.field_1942[this.id(v11x1, v11y1, v11z1)] || class_17.field_1942[this.id(v11x0, v11y0, v11z1)] ? v11y0 : v11y1, v11z1), (float)this.light(v11x0, v11y1, v11z1), (float)this.light(v11x1, v11y1, v11z1));
                        this.light[3] = MathHelper.interpolate3D((double)v10dx, (double)v10dy, (double)v10dz, (float)this.light(v10x0, v10y0, v10z0), (float)this.light(v10x1, v10y0, v10z0), (float)this.light(v10x0, v10y1, v10z0), (float)this.light(v10x1, class_17.field_1942[this.id(v10x1, v10y0, v10z0)] || class_17.field_1942[this.id(v10x0, v10y1, v10z0)] ? v10y1 : v10y0, v10z0), (float)this.light(v10x0, v10y0, v10z1), (float)this.light(v10x1, v10y0, v10z1), (float)this.light(v10x0, v10y1, v10z1), (float)this.light(v10x1, class_17.field_1942[this.id(v10x1, v10y0, v10z1)] || class_17.field_1942[this.id(v10x0, v10y1, v10z1)] ? v10y1 : v10y0, v10z1));
                        break block0;
                    }
                    case NEGATIVE: {
                        --v00z0;
                        --v00z1;
                        --v01z0;
                        --v01z1;
                        --v11z0;
                        this.light[0] = MathHelper.interpolate3D((double)v00dx, (double)v00dy, (double)v00dz, (float)this.light(v00x0, v00y0, v00z0), (float)this.light(v00x1, v00y0, v00z0), (float)this.light(v00x0, class_17.field_1942[this.id(v00x0, v00y0, v00z0)] || class_17.field_1942[this.id(v00x1, v00y1, v00z0)] ? v00y1 : v00y0, v00z0), (float)this.light(v00x1, v00y1, v00z0), (float)this.light(v00x0, v00y0, v00z1), (float)this.light(v00x1, v00y0, v00z1), (float)this.light(v00x0, class_17.field_1942[this.id(v00x0, v00y0, v00z1)] || class_17.field_1942[this.id(v00x1, v00y1, v00z1)] ? v00y1 : v00y0, v00z1), (float)this.light(v00x1, v00y1, v00z1));
                        this.light[1] = MathHelper.interpolate3D((double)v01dx, (double)v01dy, (double)v01dz, (float)this.light(v01x0, v01y0, v01z0), (float)this.light(v01x1, v01y0, v01z0), (float)this.light(v01x0, class_17.field_1942[this.id(v01x0, v01y0, v01z0)] || class_17.field_1942[this.id(v01x1, v01y1, v01z0)] ? v01y1 : v01y0, v01z0), (float)this.light(v01x1, v01y1, v01z0), (float)this.light(v01x0, v01y0, v01z1), (float)this.light(v01x1, v01y0, v01z1), (float)this.light(v01x0, class_17.field_1942[this.id(v01x0, v01y0, v01z1)] || class_17.field_1942[this.id(v01x1, v01y1, v01z1)] ? v01y1 : v01y0, v01z1), (float)this.light(v01x1, v01y1, v01z1));
                        this.light[2] = MathHelper.interpolate3D((double)v11dx, (double)v11dy, (double)v11dz, (float)this.light(v11x0, v11y0, v11z0), (float)this.light(v11x1, class_17.field_1942[this.id(v11x1, v11y1, v11z0)] || class_17.field_1942[this.id(v11x0, v11y0, v11z0)] ? v11y0 : v11y1, v11z0), (float)this.light(v11x0, v11y1, v11z0), (float)this.light(v11x1, v11y1, v11z0), (float)this.light(v11x0, v11y0, --v11z1), (float)this.light(v11x1, class_17.field_1942[this.id(v11x1, v11y1, v11z1)] || class_17.field_1942[this.id(v11x0, v11y0, v11z1)] ? v11y0 : v11y1, v11z1), (float)this.light(v11x0, v11y1, v11z1), (float)this.light(v11x1, v11y1, v11z1));
                        this.light[3] = MathHelper.interpolate3D((double)v10dx, (double)v10dy, (double)v10dz, (float)this.light(v10x0, class_17.field_1942[this.id(v10x0, v10y1, --v10z0)] || class_17.field_1942[this.id(v10x1, v10y0, v10z0)] ? v10y0 : v10y1, v10z0), (float)this.light(v10x1, v10y0, v10z0), (float)this.light(v10x0, v10y1, v10z0), (float)this.light(v10x1, v10y1, v10z0), (float)this.light(v10x0, class_17.field_1942[this.id(v10x0, v10y1, --v10z1)] || class_17.field_1942[this.id(v10x1, v10y0, v10z1)] ? v10y0 : v10y1, v10z1), (float)this.light(v10x1, v10y0, v10z1), (float)this.light(v10x0, v10y1, v10z1), (float)this.light(v10x1, v10y1, v10z1));
                    }
                }
            }
        }
    }

    private void quadFast(Direction face, double v00x, double v00y, double v00z, double v01x, double v01y, double v01z, double v11x, double v11y, double v11z, double v10x, double v10y, double v10z) {
        double mX = (v00x + v01x + v11x + v10x) / 4.0;
        double mY = (v00y + v01y + v11y + v10y) / 4.0;
        double mZ = (v00z + v01z + v11z + v10z) / 4.0;
        this.light[3] = (switch (face.getAxis()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> Math.abs(mX - (double)this.x);
            case Direction.Axis.Y -> Math.abs(mY - (double)this.y);
            case Direction.Axis.Z -> Math.abs(mZ - (double)this.z);
        }) < (double)1.0E-5f ? this.light(class_189.method_645((double)mX) + face.getOffsetX(), class_189.method_645((double)mY) + face.getOffsetY(), class_189.method_645((double)mZ) + face.getOffsetZ()) : this.light(class_189.method_645((double)mX), class_189.method_645((double)mY), class_189.method_645((double)mZ));
        this.light[2] = this.light[3];
        this.light[1] = this.light[3];
        this.light[0] = this.light[3];
    }

    private void shadeFace(Direction face) {
        if (face != Direction.UP) {
            float shade = this.shadeMultiplier(face);
            this.light[0] = this.light[0] * shade;
            this.light[1] = this.light[1] * shade;
            this.light[2] = this.light[2] * shade;
            this.light[3] = this.light[3] * shade;
        }
    }

    public float shadeMultiplier(Direction face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> 0.5f;
            case Direction.UP -> 1.0f;
            case Direction.EAST, Direction.WEST -> 0.8f;
            case Direction.NORTH, Direction.SOUTH -> 0.6f;
        };
    }
}

