/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.client.arsenic.renderer.mesh;

import com.google.common.base.Preconditions;
import net.modificationstation.stationapi.api.client.render.material.RenderMaterial;
import net.modificationstation.stationapi.api.client.render.mesh.MutableQuadView;
import net.modificationstation.stationapi.api.client.render.mesh.QuadEmitter;
import net.modificationstation.stationapi.api.client.render.model.BakedQuad;
import net.modificationstation.stationapi.api.client.texture.Sprite;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.ArsenicRenderer;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.RenderMaterialImpl;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.helper.NormalHelper;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.helper.TextureHelper;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.mesh.EncodingFormat;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.mesh.QuadViewImpl;

public abstract class MutableQuadViewImpl
extends QuadViewImpl
implements QuadEmitter {
    public final void begin(int[] data, int baseIndex) {
        this.data = data;
        this.baseIndex = baseIndex;
        this.clear();
    }

    public void clear() {
        System.arraycopy(EncodingFormat.EMPTY, 0, this.data, this.baseIndex, EncodingFormat.TOTAL_STRIDE);
        this.isGeometryInvalid = true;
        this.nominalFace = null;
        this.normalFlags(0);
        this.tag(0);
        this.colorIndex(-1);
        this.cullFace(null);
        this.material(ArsenicRenderer.MATERIAL_STANDARD);
    }

    public final MutableQuadViewImpl material(RenderMaterial material) {
        if (material == null) {
            material = ArsenicRenderer.MATERIAL_STANDARD;
        }
        this.data[this.baseIndex + 0] = EncodingFormat.material(this.data[this.baseIndex + 0], (RenderMaterialImpl.Value)material);
        return this;
    }

    public final MutableQuadViewImpl cullFace(Direction face) {
        this.data[this.baseIndex + 0] = EncodingFormat.cullFace(this.data[this.baseIndex + 0], face);
        this.nominalFace(face);
        return this;
    }

    public final MutableQuadViewImpl nominalFace(Direction face) {
        this.nominalFace = face;
        return this;
    }

    public final MutableQuadViewImpl colorIndex(int colourIndex) {
        this.data[this.baseIndex + 1] = colourIndex;
        return this;
    }

    public final MutableQuadViewImpl tag(int tag) {
        this.data[this.baseIndex + 2] = tag;
        return this;
    }

    public final MutableQuadViewImpl fromVanilla(BakedQuad quad, RenderMaterial material, Direction cullFace) {
        System.arraycopy(quad.getVertexData(), 0, this.data, this.baseIndex + 3, EncodingFormat.QUAD_STRIDE);
        this.data[this.baseIndex + 0] = EncodingFormat.cullFace(0, cullFace);
        this.nominalFace(quad.getFace());
        this.colorIndex(quad.getColorIndex());
        this.material(material);
        this.tag(0);
        this.shade(quad.hasShade());
        this.isGeometryInvalid = true;
        return this;
    }

    public MutableQuadViewImpl pos(int vertexIndex, float x, float y, float z) {
        int index = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_X;
        this.data[index] = Float.floatToRawIntBits(x);
        this.data[index + 1] = Float.floatToRawIntBits(y);
        this.data[index + 2] = Float.floatToRawIntBits(z);
        this.isGeometryInvalid = true;
        return this;
    }

    protected void normalFlags(int flags) {
        this.data[this.baseIndex + 0] = EncodingFormat.normalFlags(this.data[this.baseIndex + 0], flags);
    }

    public MutableQuadViewImpl normal(int vertexIndex, float x, float y, float z) {
        this.normalFlags(this.normalFlags() | 1 << vertexIndex);
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL] = NormalHelper.packNormal(x, y, z, 0.0f);
        return this;
    }

    public final void populateMissingNormals() {
        int normalFlags = this.normalFlags();
        if (normalFlags == 15) {
            return;
        }
        int packedFaceNormal = NormalHelper.packNormal(this.faceNormal(), 0.0f);
        for (int v = 0; v < 4; ++v) {
            if ((normalFlags & 1 << v) != 0) continue;
            this.data[this.baseIndex + v * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL] = packedFaceNormal;
        }
        this.normalFlags(15);
    }

    public MutableQuadViewImpl spriteColor(int vertexIndex, int spriteIndex, int color) {
        Preconditions.checkArgument((spriteIndex == 0 ? 1 : 0) != 0, (String)"Unsupported sprite index: %s", (int)spriteIndex);
        this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_COLOR] = color;
        return this;
    }

    public MutableQuadViewImpl sprite(int vertexIndex, int spriteIndex, float u, float v) {
        Preconditions.checkArgument((spriteIndex == 0 ? 1 : 0) != 0, (String)"Unsupported sprite index: %s", (int)spriteIndex);
        int i = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_U;
        this.data[i] = Float.floatToRawIntBits(u);
        this.data[i + 1] = Float.floatToRawIntBits(v);
        return this;
    }

    public MutableQuadViewImpl spriteBake(int spriteIndex, Sprite sprite, int bakeFlags) {
        Preconditions.checkArgument((spriteIndex == 0 ? 1 : 0) != 0, (String)"Unsupported sprite index: %s", (int)spriteIndex);
        TextureHelper.bakeSprite((MutableQuadView)this, spriteIndex, sprite, bakeFlags);
        return this;
    }
}

