/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.client.arsenic.renderer.render;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_67;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.client.render.RenderContext;
import net.modificationstation.stationapi.api.client.render.mesh.Mesh;
import net.modificationstation.stationapi.api.client.render.mesh.MutableQuadView;
import net.modificationstation.stationapi.api.client.render.mesh.QuadEmitter;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.ArsenicRenderer;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.RenderMaterialImpl;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.aocalc.LightingCalculatorImpl;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.mesh.EncodingFormat;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.mesh.MeshImpl;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.mesh.MutableQuadViewImpl;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.render.AbstractQuadRenderer;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.render.BlockRenderInfo;

public abstract class AbstractMeshConsumer
extends AbstractQuadRenderer
implements Consumer<Mesh> {
    private final Maker editorQuad = new Maker();

    protected AbstractMeshConsumer(BlockRenderInfo blockInfo, Supplier<class_67> bufferFunc, LightingCalculatorImpl aoCalc, RenderContext.QuadTransform transform) {
        super(blockInfo, bufferFunc, aoCalc, transform);
    }

    @Override
    public void accept(Mesh mesh) {
        MeshImpl m = (MeshImpl)mesh;
        int[] data = m.data();
        int limit = data.length;
        for (int index = 0; index < limit; index += EncodingFormat.TOTAL_STRIDE) {
            System.arraycopy(data, index, this.editorQuad.data(), 0, EncodingFormat.TOTAL_STRIDE);
            this.editorQuad.load();
            this.renderQuad(this.editorQuad);
        }
    }

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    private void renderQuad(MutableQuadViewImpl q) {
        if (!this.transform.transform((MutableQuadView)this.editorQuad)) {
            return;
        }
        if (!this.blockInfo.shouldDrawQuad(q)) {
            return;
        }
        if (!this.blockInfo.shouldDrawFace(q.cullFace())) {
            return;
        }
        RenderMaterialImpl.Value mat = q.material();
        if (!mat.disableAo(0) && Minecraft.method_2148()) {
            this.aoCalc.calculateForQuad(q);
        }
        this.tesselateQuad(q, mat, 0);
    }

    private void tesselateQuad(MutableQuadViewImpl quad, RenderMaterialImpl.Value mat, int textureIndex) {
        int colorIndex;
        int n = colorIndex = mat.disableColorIndex(textureIndex) ? -1 : quad.colorIndex();
        if (this.blockInfo.defaultAo && !mat.disableAo(textureIndex)) {
            if (mat.emissive(textureIndex)) {
                this.tessellateSmoothEmissive(quad, colorIndex);
            } else {
                this.tessellateSmooth(quad, colorIndex);
            }
        } else if (mat.emissive(textureIndex)) {
            this.tessellateFlatEmissive(quad, colorIndex);
        } else {
            this.tessellateFlat(quad, colorIndex);
        }
    }

    private class Maker
    extends MutableQuadViewImpl
    implements QuadEmitter {
        private Maker() {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.material(ArsenicRenderer.MATERIAL_STANDARD);
        }

        public Maker emit() {
            this.computeGeometry();
            AbstractMeshConsumer.this.renderQuad(this);
            this.clear();
            return this;
        }
    }
}

