/*
 * Decompiled with CFR 0.152.
 */
package net.modificationstation.stationapi.impl.client.arsenic.renderer.render;

import java.util.function.Supplier;
import net.minecraft.class_67;
import net.modificationstation.stationapi.api.client.render.RenderContext;
import net.modificationstation.stationapi.api.util.math.Matrix3f;
import net.modificationstation.stationapi.api.util.math.Matrix4f;
import net.modificationstation.stationapi.api.util.math.Vec3f;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.aocalc.LightingCalculatorImpl;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.helper.ColorHelper;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.mesh.MutableQuadViewImpl;
import net.modificationstation.stationapi.impl.client.arsenic.renderer.render.BlockRenderInfo;

public abstract class AbstractQuadRenderer {
    static final int FULL_BRIGHTNESS = 0xF000F0;
    protected final Supplier<class_67> bufferFunc;
    protected final BlockRenderInfo blockInfo;
    protected final LightingCalculatorImpl aoCalc;
    protected final RenderContext.QuadTransform transform;
    protected final Vec3f normalVec = new Vec3f();

    protected abstract Matrix4f matrix();

    protected abstract Matrix3f normalMatrix();

    protected abstract int overlay();

    AbstractQuadRenderer(BlockRenderInfo blockInfo, Supplier<class_67> bufferFunc, LightingCalculatorImpl aoCalc, RenderContext.QuadTransform transform) {
        this.blockInfo = blockInfo;
        this.bufferFunc = bufferFunc;
        this.aoCalc = aoCalc;
        this.transform = transform;
    }

    private void colorizeQuad(MutableQuadViewImpl q, int blockColourIndex) {
        if (blockColourIndex == -1) {
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(q.spriteColor(i, 0)));
            }
        } else {
            int blockColour = this.blockInfo.blockColour(blockColourIndex);
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(ColorHelper.multiplyColour(blockColour, q.spriteColor(i, 0))));
            }
        }
    }

    private void bufferQuad(MutableQuadViewImpl q) {
        AbstractQuadRenderer.bufferQuad(this.bufferFunc.get(), q, this.matrix(), this.overlay(), this.normalMatrix(), this.normalVec);
    }

    public static void bufferQuad(class_67 buff, MutableQuadViewImpl quad, Matrix4f matrix, int overlay, Matrix3f normalMatrix, Vec3f normalVec) {
    }

    protected void tessellateSmooth(MutableQuadViewImpl q, int blockColorIndex) {
        this.colorizeQuad(q, blockColorIndex);
        for (int i = 0; i < 4; ++i) {
            q.spriteColor(i, 0, ColorHelper.multiplyRGB(q.spriteColor(i, 0), this.aoCalc.light[i]));
        }
        this.bufferQuad(q);
    }

    protected void tessellateSmoothEmissive(MutableQuadViewImpl q, int blockColorIndex) {
        this.colorizeQuad(q, blockColorIndex);
        this.bufferQuad(q);
    }

    protected void tessellateFlat(MutableQuadViewImpl quad, int blockColorIndex) {
        this.colorizeQuad(quad, blockColorIndex);
        for (int i = 0; i < 4; ++i) {
            quad.spriteColor(i, 0, ColorHelper.multiplyRGB(quad.spriteColor(i, 0), this.aoCalc.light[i]));
        }
        this.bufferQuad(quad);
    }

    protected void tessellateFlatEmissive(MutableQuadViewImpl quad, int blockColorIndex) {
        this.colorizeQuad(quad, blockColorIndex);
        this.shadeFlatQuad(quad);
        this.bufferQuad(quad);
    }

    private void shadeFlatQuad(MutableQuadViewImpl quad) {
        float shade = this.aoCalc.shadeMultiplier(quad.lightFace());
        for (int i = 0; i < 4; ++i) {
            quad.spriteColor(i, 0, ColorHelper.multiplyRGB(quad.spriteColor(i, 0), shade));
        }
    }
}

